<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRateGroup
 *
 * @ORM\Table(name="rt_rate_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_group_trf_yn", columns={"rt_rate_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RtRateGroup
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateGroupIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateGroupDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_group_id", type="integer", nullable=false)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_abbrv", type="string", length=5, nullable=true)
     */
    private $rtRateGroupAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_desc", type="string", length=255, nullable=true)
     */
    private $rtRateGroupDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_group_sys_code", type="boolean", nullable=true)
     */
    private $rtRateGroupSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_group_class", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtRateGroupClass;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_group_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateGroupDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_group_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateGroupInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateGroupTrfYn;



    /**
     * Get rtRateGroupIx
     *
     * @return string
     */
    public function getRtRateGroupIx()
    {
        return $this->rtRateGroupIx;
    }

    /**
     * Set rtRateGroupDb
     *
     * @param string $rtRateGroupDb
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupDb($rtRateGroupDb)
    {
        $this->rtRateGroupDb = $rtRateGroupDb;

        return $this;
    }

    /**
     * Get rtRateGroupDb
     *
     * @return string
     */
    public function getRtRateGroupDb()
    {
        return $this->rtRateGroupDb;
    }

    /**
     * Set rtRateGroupId
     *
     * @param integer $rtRateGroupId
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return integer
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set rtRateGroupAbbrv
     *
     * @param string $rtRateGroupAbbrv
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupAbbrv($rtRateGroupAbbrv)
    {
        $this->rtRateGroupAbbrv = $rtRateGroupAbbrv;

        return $this;
    }

    /**
     * Get rtRateGroupAbbrv
     *
     * @return string
     */
    public function getRtRateGroupAbbrv()
    {
        return $this->rtRateGroupAbbrv;
    }

    /**
     * Set rtRateGroupDesc
     *
     * @param string $rtRateGroupDesc
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupDesc($rtRateGroupDesc)
    {
        $this->rtRateGroupDesc = $rtRateGroupDesc;

        return $this;
    }

    /**
     * Get rtRateGroupDesc
     *
     * @return string
     */
    public function getRtRateGroupDesc()
    {
        return $this->rtRateGroupDesc;
    }

    /**
     * Set rtRateGroupSysCode
     *
     * @param boolean $rtRateGroupSysCode
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupSysCode($rtRateGroupSysCode)
    {
        $this->rtRateGroupSysCode = $rtRateGroupSysCode;

        return $this;
    }

    /**
     * Get rtRateGroupSysCode
     *
     * @return boolean
     */
    public function getRtRateGroupSysCode()
    {
        return $this->rtRateGroupSysCode;
    }

    /**
     * Set rtRateGroupClass
     *
     * @param boolean $rtRateGroupClass
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupClass($rtRateGroupClass)
    {
        $this->rtRateGroupClass = $rtRateGroupClass;

        return $this;
    }

    /**
     * Get rtRateGroupClass
     *
     * @return boolean
     */
    public function getRtRateGroupClass()
    {
        return $this->rtRateGroupClass;
    }

    /**
     * Set rtRateGroupDefaultYn
     *
     * @param boolean $rtRateGroupDefaultYn
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupDefaultYn($rtRateGroupDefaultYn)
    {
        $this->rtRateGroupDefaultYn = $rtRateGroupDefaultYn;

        return $this;
    }

    /**
     * Get rtRateGroupDefaultYn
     *
     * @return boolean
     */
    public function getRtRateGroupDefaultYn()
    {
        return $this->rtRateGroupDefaultYn;
    }

    /**
     * Set rtRateGroupInactiveYn
     *
     * @param boolean $rtRateGroupInactiveYn
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupInactiveYn($rtRateGroupInactiveYn)
    {
        $this->rtRateGroupInactiveYn = $rtRateGroupInactiveYn;

        return $this;
    }

    /**
     * Get rtRateGroupInactiveYn
     *
     * @return boolean
     */
    public function getRtRateGroupInactiveYn()
    {
        return $this->rtRateGroupInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRateGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateGroupTrfYn
     *
     * @param boolean $rtRateGroupTrfYn
     *
     * @return RtRateGroup
     */
    public function setRtRateGroupTrfYn($rtRateGroupTrfYn)
    {
        $this->rtRateGroupTrfYn = $rtRateGroupTrfYn;

        return $this;
    }

    /**
     * Get rtRateGroupTrfYn
     *
     * @return boolean
     */
    public function getRtRateGroupTrfYn()
    {
        return $this->rtRateGroupTrfYn;
    }
}
