<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRateGrpAmt
 *
 * @ORM\Table(name="rt_rate_grp_amt", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_grp_amt_trf_yn", columns={"rt_rate_grp_amt_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rt_rate_id", columns={"rt_rate_id"}), @ORM\Index(name="rt_rate_group_id", columns={"rt_rate_group_id"})})
 * @ORM\Entity
 */
class RtRateGrpAmt
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_grp_amt_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateGrpAmtIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_grp_amt_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateGrpAmtDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_grp_amt_id", type="integer", nullable=false)
     */
    private $rtRateGrpAmtId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_grp_amt_amount", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rtRateGrpAmtAmount;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_grp_amt_qty", type="integer", nullable=true)
     */
    private $rtRateGrpAmtQty;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_id", type="string", length=36, nullable=true)
     */
    private $rtRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_grp_amt_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateGrpAmtTrfYn;



    /**
     * Get rtRateGrpAmtIx
     *
     * @return string
     */
    public function getRtRateGrpAmtIx()
    {
        return $this->rtRateGrpAmtIx;
    }

    /**
     * Set rtRateGrpAmtDb
     *
     * @param string $rtRateGrpAmtDb
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGrpAmtDb($rtRateGrpAmtDb)
    {
        $this->rtRateGrpAmtDb = $rtRateGrpAmtDb;

        return $this;
    }

    /**
     * Get rtRateGrpAmtDb
     *
     * @return string
     */
    public function getRtRateGrpAmtDb()
    {
        return $this->rtRateGrpAmtDb;
    }

    /**
     * Set rtRateGrpAmtId
     *
     * @param integer $rtRateGrpAmtId
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGrpAmtId($rtRateGrpAmtId)
    {
        $this->rtRateGrpAmtId = $rtRateGrpAmtId;

        return $this;
    }

    /**
     * Get rtRateGrpAmtId
     *
     * @return integer
     */
    public function getRtRateGrpAmtId()
    {
        return $this->rtRateGrpAmtId;
    }

    /**
     * Set rtRateGrpAmtAmount
     *
     * @param string $rtRateGrpAmtAmount
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGrpAmtAmount($rtRateGrpAmtAmount)
    {
        $this->rtRateGrpAmtAmount = $rtRateGrpAmtAmount;

        return $this;
    }

    /**
     * Get rtRateGrpAmtAmount
     *
     * @return string
     */
    public function getRtRateGrpAmtAmount()
    {
        return $this->rtRateGrpAmtAmount;
    }

    /**
     * Set rtRateGrpAmtQty
     *
     * @param integer $rtRateGrpAmtQty
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGrpAmtQty($rtRateGrpAmtQty)
    {
        $this->rtRateGrpAmtQty = $rtRateGrpAmtQty;

        return $this;
    }

    /**
     * Get rtRateGrpAmtQty
     *
     * @return integer
     */
    public function getRtRateGrpAmtQty()
    {
        return $this->rtRateGrpAmtQty;
    }

    /**
     * Set rtRateId
     *
     * @param string $rtRateId
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateId($rtRateId)
    {
        $this->rtRateId = $rtRateId;

        return $this;
    }

    /**
     * Get rtRateId
     *
     * @return string
     */
    public function getRtRateId()
    {
        return $this->rtRateId;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRateGrpAmt
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateGrpAmtTrfYn
     *
     * @param boolean $rtRateGrpAmtTrfYn
     *
     * @return RtRateGrpAmt
     */
    public function setRtRateGrpAmtTrfYn($rtRateGrpAmtTrfYn)
    {
        $this->rtRateGrpAmtTrfYn = $rtRateGrpAmtTrfYn;

        return $this;
    }

    /**
     * Get rtRateGrpAmtTrfYn
     *
     * @return boolean
     */
    public function getRtRateGrpAmtTrfYn()
    {
        return $this->rtRateGrpAmtTrfYn;
    }
}
