<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRateType
 *
 * @ORM\Table(name="rt_rate_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_type_trf_yn", columns={"rt_rate_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rt_rate_type_desc", columns={"rt_rate_type_desc"})})
 * @ORM\Entity
 */
class RtRateType
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_type_id", type="integer", nullable=false)
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_abbrv", type="string", length=5, nullable=true)
     */
    private $rtRateTypeAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_colour", type="string", length=6, nullable=true)
     */
    private $rtRateTypeColour;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_desc", type="string", length=191, nullable=false)
     */
    private $rtRateTypeDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_note", type="string", length=255, nullable=true)
     */
    private $rtRateTypeNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_type_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateTypeInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateTypeTrfYn;



    /**
     * Get rtRateTypeIx
     *
     * @return string
     */
    public function getRtRateTypeIx()
    {
        return $this->rtRateTypeIx;
    }

    /**
     * Set rtRateTypeDb
     *
     * @param string $rtRateTypeDb
     *
     * @return RtRateType
     */
    public function setRtRateTypeDb($rtRateTypeDb)
    {
        $this->rtRateTypeDb = $rtRateTypeDb;

        return $this;
    }

    /**
     * Get rtRateTypeDb
     *
     * @return string
     */
    public function getRtRateTypeDb()
    {
        return $this->rtRateTypeDb;
    }

    /**
     * Set rtRateTypeId
     *
     * @param integer $rtRateTypeId
     *
     * @return RtRateType
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return integer
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set rtRateTypeAbbrv
     *
     * @param string $rtRateTypeAbbrv
     *
     * @return RtRateType
     */
    public function setRtRateTypeAbbrv($rtRateTypeAbbrv)
    {
        $this->rtRateTypeAbbrv = $rtRateTypeAbbrv;

        return $this;
    }

    /**
     * Get rtRateTypeAbbrv
     *
     * @return string
     */
    public function getRtRateTypeAbbrv()
    {
        return $this->rtRateTypeAbbrv;
    }

    /**
     * Set rtRateTypeColour
     *
     * @param string $rtRateTypeColour
     *
     * @return RtRateType
     */
    public function setRtRateTypeColour($rtRateTypeColour)
    {
        $this->rtRateTypeColour = $rtRateTypeColour;

        return $this;
    }

    /**
     * Get rtRateTypeColour
     *
     * @return string
     */
    public function getRtRateTypeColour()
    {
        return $this->rtRateTypeColour;
    }

    /**
     * Set rtRateTypeDesc
     *
     * @param string $rtRateTypeDesc
     *
     * @return RtRateType
     */
    public function setRtRateTypeDesc($rtRateTypeDesc)
    {
        $this->rtRateTypeDesc = $rtRateTypeDesc;

        return $this;
    }

    /**
     * Get rtRateTypeDesc
     *
     * @return string
     */
    public function getRtRateTypeDesc()
    {
        return $this->rtRateTypeDesc;
    }

    /**
     * Set rtRateTypeNote
     *
     * @param string $rtRateTypeNote
     *
     * @return RtRateType
     */
    public function setRtRateTypeNote($rtRateTypeNote)
    {
        $this->rtRateTypeNote = $rtRateTypeNote;

        return $this;
    }

    /**
     * Get rtRateTypeNote
     *
     * @return string
     */
    public function getRtRateTypeNote()
    {
        return $this->rtRateTypeNote;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RtRateType
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rtRateTypeInactiveYn
     *
     * @param boolean $rtRateTypeInactiveYn
     *
     * @return RtRateType
     */
    public function setRtRateTypeInactiveYn($rtRateTypeInactiveYn)
    {
        $this->rtRateTypeInactiveYn = $rtRateTypeInactiveYn;

        return $this;
    }

    /**
     * Get rtRateTypeInactiveYn
     *
     * @return boolean
     */
    public function getRtRateTypeInactiveYn()
    {
        return $this->rtRateTypeInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRateType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateTypeTrfYn
     *
     * @param boolean $rtRateTypeTrfYn
     *
     * @return RtRateType
     */
    public function setRtRateTypeTrfYn($rtRateTypeTrfYn)
    {
        $this->rtRateTypeTrfYn = $rtRateTypeTrfYn;

        return $this;
    }

    /**
     * Get rtRateTypeTrfYn
     *
     * @return boolean
     */
    public function getRtRateTypeTrfYn()
    {
        return $this->rtRateTypeTrfYn;
    }
}
