<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtTaxGroup
 *
 * @ORM\Table(name="rt_tax_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_tax_group_trf_yn", columns={"rt_tax_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RtTaxGroup
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtTaxGroupIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtTaxGroupDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_tax_group_id", type="integer", nullable=false)
     */
    private $rtTaxGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_abbrev", type="string", length=5, nullable=true)
     */
    private $rtTaxGroupAbbrev;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_desc", type="string", length=255, nullable=true)
     */
    private $rtTaxGroupDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_group_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtTaxGroupInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtTaxGroupTrfYn;



    /**
     * Get rtTaxGroupIx
     *
     * @return string
     */
    public function getRtTaxGroupIx()
    {
        return $this->rtTaxGroupIx;
    }

    /**
     * Set rtTaxGroupDb
     *
     * @param string $rtTaxGroupDb
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupDb($rtTaxGroupDb)
    {
        $this->rtTaxGroupDb = $rtTaxGroupDb;

        return $this;
    }

    /**
     * Get rtTaxGroupDb
     *
     * @return string
     */
    public function getRtTaxGroupDb()
    {
        return $this->rtTaxGroupDb;
    }

    /**
     * Set rtTaxGroupId
     *
     * @param integer $rtTaxGroupId
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupId($rtTaxGroupId)
    {
        $this->rtTaxGroupId = $rtTaxGroupId;

        return $this;
    }

    /**
     * Get rtTaxGroupId
     *
     * @return integer
     */
    public function getRtTaxGroupId()
    {
        return $this->rtTaxGroupId;
    }

    /**
     * Set rtTaxGroupAbbrev
     *
     * @param string $rtTaxGroupAbbrev
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupAbbrev($rtTaxGroupAbbrev)
    {
        $this->rtTaxGroupAbbrev = $rtTaxGroupAbbrev;

        return $this;
    }

    /**
     * Get rtTaxGroupAbbrev
     *
     * @return string
     */
    public function getRtTaxGroupAbbrev()
    {
        return $this->rtTaxGroupAbbrev;
    }

    /**
     * Set rtTaxGroupDesc
     *
     * @param string $rtTaxGroupDesc
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupDesc($rtTaxGroupDesc)
    {
        $this->rtTaxGroupDesc = $rtTaxGroupDesc;

        return $this;
    }

    /**
     * Get rtTaxGroupDesc
     *
     * @return string
     */
    public function getRtTaxGroupDesc()
    {
        return $this->rtTaxGroupDesc;
    }

    /**
     * Set rtTaxGroupInactiveYn
     *
     * @param boolean $rtTaxGroupInactiveYn
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupInactiveYn($rtTaxGroupInactiveYn)
    {
        $this->rtTaxGroupInactiveYn = $rtTaxGroupInactiveYn;

        return $this;
    }

    /**
     * Get rtTaxGroupInactiveYn
     *
     * @return boolean
     */
    public function getRtTaxGroupInactiveYn()
    {
        return $this->rtTaxGroupInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtTaxGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtTaxGroupTrfYn
     *
     * @param boolean $rtTaxGroupTrfYn
     *
     * @return RtTaxGroup
     */
    public function setRtTaxGroupTrfYn($rtTaxGroupTrfYn)
    {
        $this->rtTaxGroupTrfYn = $rtTaxGroupTrfYn;

        return $this;
    }

    /**
     * Get rtTaxGroupTrfYn
     *
     * @return boolean
     */
    public function getRtTaxGroupTrfYn()
    {
        return $this->rtTaxGroupTrfYn;
    }
}
