<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtTaxGroupItem
 *
 * @ORM\Table(name="rt_tax_group_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_tax_group_item_trf_yn", columns={"rt_tax_group_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_tax_rate_id", columns={"rf_tax_rate_id"}), @ORM\Index(name="rt_tax_group_id", columns={"rt_tax_group_id"})})
 * @ORM\Entity
 */
class RtTaxGroupItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtTaxGroupItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_item_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtTaxGroupItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_tax_group_item_id", type="integer", nullable=false)
     */
    private $rtTaxGroupItemId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_base_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtTaxBaseInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_group_id", type="string", length=36, nullable=true)
     */
    private $rtTaxGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_group_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtTaxGroupItemTrfYn;



    /**
     * Get rtTaxGroupItemIx
     *
     * @return string
     */
    public function getRtTaxGroupItemIx()
    {
        return $this->rtTaxGroupItemIx;
    }

    /**
     * Set rtTaxGroupItemDb
     *
     * @param string $rtTaxGroupItemDb
     *
     * @return RtTaxGroupItem
     */
    public function setRtTaxGroupItemDb($rtTaxGroupItemDb)
    {
        $this->rtTaxGroupItemDb = $rtTaxGroupItemDb;

        return $this;
    }

    /**
     * Get rtTaxGroupItemDb
     *
     * @return string
     */
    public function getRtTaxGroupItemDb()
    {
        return $this->rtTaxGroupItemDb;
    }

    /**
     * Set rtTaxGroupItemId
     *
     * @param integer $rtTaxGroupItemId
     *
     * @return RtTaxGroupItem
     */
    public function setRtTaxGroupItemId($rtTaxGroupItemId)
    {
        $this->rtTaxGroupItemId = $rtTaxGroupItemId;

        return $this;
    }

    /**
     * Get rtTaxGroupItemId
     *
     * @return integer
     */
    public function getRtTaxGroupItemId()
    {
        return $this->rtTaxGroupItemId;
    }

    /**
     * Set rtTaxBaseInd
     *
     * @param boolean $rtTaxBaseInd
     *
     * @return RtTaxGroupItem
     */
    public function setRtTaxBaseInd($rtTaxBaseInd)
    {
        $this->rtTaxBaseInd = $rtTaxBaseInd;

        return $this;
    }

    /**
     * Get rtTaxBaseInd
     *
     * @return boolean
     */
    public function getRtTaxBaseInd()
    {
        return $this->rtTaxBaseInd;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return RtTaxGroupItem
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set rtTaxGroupId
     *
     * @param string $rtTaxGroupId
     *
     * @return RtTaxGroupItem
     */
    public function setRtTaxGroupId($rtTaxGroupId)
    {
        $this->rtTaxGroupId = $rtTaxGroupId;

        return $this;
    }

    /**
     * Get rtTaxGroupId
     *
     * @return string
     */
    public function getRtTaxGroupId()
    {
        return $this->rtTaxGroupId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtTaxGroupItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtTaxGroupItemTrfYn
     *
     * @param boolean $rtTaxGroupItemTrfYn
     *
     * @return RtTaxGroupItem
     */
    public function setRtTaxGroupItemTrfYn($rtTaxGroupItemTrfYn)
    {
        $this->rtTaxGroupItemTrfYn = $rtTaxGroupItemTrfYn;

        return $this;
    }

    /**
     * Get rtTaxGroupItemTrfYn
     *
     * @return boolean
     */
    public function getRtTaxGroupItemTrfYn()
    {
        return $this->rtTaxGroupItemTrfYn;
    }
}
