<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvExtra
 *
 * @ORM\Table(name="rv_extra", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="rv_extra_trf_yn", columns={"rv_extra_trf_yn"}), @ORM\Index(name="fn_folio_id", columns={"fn_folio_id"}), @ORM\Index(name="rv_extra_void_link_id", columns={"rv_extra_void_link_id"})})
 * @ORM\Entity
 */
class RvExtra
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvExtraIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvExtraDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_id", type="integer", nullable=false)
     */
    private $rvExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_amt_comm", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_amt_gross", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraAmtGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_amt_nett", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraAmtNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_amt_payable", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraAmtPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_amt_tax", type="decimal", precision=16, scale=6, nullable=false, options={"default"="0.000000"})
     */
    private $rvExtraAmtTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_charge", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraCharge;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_comm_pay", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraCommPay;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_comm_rec", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraCommRec;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_extra_date_serv", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvExtraDateServ;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_discount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraDiscount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_extra_exch_expiry", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvExtraExchExpiry;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_exch_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="0.000000"})
     */
    private $rvExtraExchRate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_note", type="text", length=65535, nullable=true)
     */
    private $rvExtraNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_note_internal", type="text", length=65535, nullable=true)
     */
    private $rvExtraNoteInternal;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_ref", type="string", length=30, nullable=true)
     */
    private $rvExtraRef;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_supplier_conf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraSupplierConfYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvExtraTaxPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_travel_eta", type="string", length=50, nullable=true)
     */
    private $rvExtraTravelEta;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_travel_etd", type="string", length=50, nullable=true)
     */
    private $rvExtraTravelEtd;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_adult_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvExtraAdultCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_child_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvExtraChildCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvExtraNights;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_extra_date_depart", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvExtraDateDepart;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_units", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvExtraUnits;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_void_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraVoidInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_void_link_id", type="string", length=36, nullable=true)
     */
    private $rvExtraVoidLinkId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_void_reason", type="string", length=250, nullable=true)
     */
    private $rvExtraVoidReason;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_void_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraVoidSeq;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_extra_void_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvExtraVoidTime;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_void_time_tz", type="string", length=40, nullable=false)
     */
    private $rvExtraVoidTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_void_user_id", type="string", length=36, nullable=true)
     */
    private $rvExtraVoidUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_id", type="string", length=36, nullable=true)
     */
    private $acPosId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_id", type="string", length=36, nullable=true)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_inv_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_supplier_id", type="string", length=36, nullable=true)
     */
    private $prSupplierId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_ind", type="string", length=36, nullable=true)
     */
    private $rvExtraTaxInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_inv_curr_id", type="string", length=36, nullable=true)
     */
    private $rvExtraInvCurrId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $adModifyUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_id", type="string", length=36, nullable=true)
     */
    private $rvPhoneId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_id", type="string", length=36, nullable=true)
     */
    private $rvResItemGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_id", type="string", length=36, nullable=true)
     */
    private $fnInvoiceItemId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_extra_timestamp", type="datetime", columnDefinition="timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
     */
    private $rvExtraTimestamp;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_debug", type="text", length=65535, nullable=false)
     */
    private $rvExtraDebug;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraTrfYn;



    /**
     * Get rvExtraIx
     *
     * @return string
     */
    public function getRvExtraIx()
    {
        return $this->rvExtraIx;
    }

    /**
     * Set rvExtraDb
     *
     * @param string $rvExtraDb
     *
     * @return RvExtra
     */
    public function setRvExtraDb($rvExtraDb)
    {
        $this->rvExtraDb = $rvExtraDb;

        return $this;
    }

    /**
     * Get rvExtraDb
     *
     * @return string
     */
    public function getRvExtraDb()
    {
        return $this->rvExtraDb;
    }

    /**
     * Set rvExtraId
     *
     * @param integer $rvExtraId
     *
     * @return RvExtra
     */
    public function setRvExtraId($rvExtraId)
    {
        $this->rvExtraId = $rvExtraId;

        return $this;
    }

    /**
     * Get rvExtraId
     *
     * @return integer
     */
    public function getRvExtraId()
    {
        return $this->rvExtraId;
    }

    /**
     * Set rvExtraAmtComm
     *
     * @param string $rvExtraAmtComm
     *
     * @return RvExtra
     */
    public function setRvExtraAmtComm($rvExtraAmtComm)
    {
        $this->rvExtraAmtComm = $rvExtraAmtComm;

        return $this;
    }

    /**
     * Get rvExtraAmtComm
     *
     * @return string
     */
    public function getRvExtraAmtComm()
    {
        return $this->rvExtraAmtComm;
    }

    /**
     * Set rvExtraAmtGross
     *
     * @param string $rvExtraAmtGross
     *
     * @return RvExtra
     */
    public function setRvExtraAmtGross($rvExtraAmtGross)
    {
        $this->rvExtraAmtGross = $rvExtraAmtGross;

        return $this;
    }

    /**
     * Get rvExtraAmtGross
     *
     * @return string
     */
    public function getRvExtraAmtGross()
    {
        return $this->rvExtraAmtGross;
    }

    /**
     * Set rvExtraAmtNett
     *
     * @param string $rvExtraAmtNett
     *
     * @return RvExtra
     */
    public function setRvExtraAmtNett($rvExtraAmtNett)
    {
        $this->rvExtraAmtNett = $rvExtraAmtNett;

        return $this;
    }

    /**
     * Get rvExtraAmtNett
     *
     * @return string
     */
    public function getRvExtraAmtNett()
    {
        return $this->rvExtraAmtNett;
    }

    /**
     * Set rvExtraAmtPayable
     *
     * @param string $rvExtraAmtPayable
     *
     * @return RvExtra
     */
    public function setRvExtraAmtPayable($rvExtraAmtPayable)
    {
        $this->rvExtraAmtPayable = $rvExtraAmtPayable;

        return $this;
    }

    /**
     * Get rvExtraAmtPayable
     *
     * @return string
     */
    public function getRvExtraAmtPayable()
    {
        return $this->rvExtraAmtPayable;
    }

    /**
     * Set rvExtraAmtTax
     *
     * @param string $rvExtraAmtTax
     *
     * @return RvExtra
     */
    public function setRvExtraAmtTax($rvExtraAmtTax)
    {
        $this->rvExtraAmtTax = $rvExtraAmtTax;

        return $this;
    }

    /**
     * Get rvExtraAmtTax
     *
     * @return string
     */
    public function getRvExtraAmtTax()
    {
        return $this->rvExtraAmtTax;
    }

    /**
     * Set rvExtraCharge
     *
     * @param string $rvExtraCharge
     *
     * @return RvExtra
     */
    public function setRvExtraCharge($rvExtraCharge)
    {
        $this->rvExtraCharge = $rvExtraCharge;

        return $this;
    }

    /**
     * Get rvExtraCharge
     *
     * @return string
     */
    public function getRvExtraCharge()
    {
        return $this->rvExtraCharge;
    }

    /**
     * Set rvExtraCommPay
     *
     * @param string $rvExtraCommPay
     *
     * @return RvExtra
     */
    public function setRvExtraCommPay($rvExtraCommPay)
    {
        $this->rvExtraCommPay = $rvExtraCommPay;

        return $this;
    }

    /**
     * Get rvExtraCommPay
     *
     * @return string
     */
    public function getRvExtraCommPay()
    {
        return $this->rvExtraCommPay;
    }

    /**
     * Set rvExtraCommRec
     *
     * @param string $rvExtraCommRec
     *
     * @return RvExtra
     */
    public function setRvExtraCommRec($rvExtraCommRec)
    {
        $this->rvExtraCommRec = $rvExtraCommRec;

        return $this;
    }

    /**
     * Get rvExtraCommRec
     *
     * @return string
     */
    public function getRvExtraCommRec()
    {
        return $this->rvExtraCommRec;
    }

    /**
     * Set rvExtraDateServ
     *
     * @param \DateTime $rvExtraDateServ
     *
     * @return RvExtra
     */
    public function setRvExtraDateServ($rvExtraDateServ)
    {
        $this->rvExtraDateServ = $rvExtraDateServ;

        return $this;
    }

    /**
     * Get rvExtraDateServ
     *
     * @return \DateTime
     */
    public function getRvExtraDateServ()
    {
        return $this->rvExtraDateServ;
    }

    /**
     * Set rvExtraDiscount
     *
     * @param string $rvExtraDiscount
     *
     * @return RvExtra
     */
    public function setRvExtraDiscount($rvExtraDiscount)
    {
        $this->rvExtraDiscount = $rvExtraDiscount;

        return $this;
    }

    /**
     * Get rvExtraDiscount
     *
     * @return string
     */
    public function getRvExtraDiscount()
    {
        return $this->rvExtraDiscount;
    }

    /**
     * Set rvExtraExchExpiry
     *
     * @param \DateTime $rvExtraExchExpiry
     *
     * @return RvExtra
     */
    public function setRvExtraExchExpiry($rvExtraExchExpiry)
    {
        $this->rvExtraExchExpiry = $rvExtraExchExpiry;

        return $this;
    }

    /**
     * Get rvExtraExchExpiry
     *
     * @return \DateTime
     */
    public function getRvExtraExchExpiry()
    {
        return $this->rvExtraExchExpiry;
    }

    /**
     * Set rvExtraExchRate
     *
     * @param string $rvExtraExchRate
     *
     * @return RvExtra
     */
    public function setRvExtraExchRate($rvExtraExchRate)
    {
        $this->rvExtraExchRate = $rvExtraExchRate;

        return $this;
    }

    /**
     * Get rvExtraExchRate
     *
     * @return string
     */
    public function getRvExtraExchRate()
    {
        return $this->rvExtraExchRate;
    }

    /**
     * Set rvExtraNote
     *
     * @param string $rvExtraNote
     *
     * @return RvExtra
     */
    public function setRvExtraNote($rvExtraNote)
    {
        $this->rvExtraNote = $rvExtraNote;

        return $this;
    }

    /**
     * Get rvExtraNote
     *
     * @return string
     */
    public function getRvExtraNote()
    {
        return $this->rvExtraNote;
    }

    /**
     * Set rvExtraNoteInternal
     *
     * @param string $rvExtraNoteInternal
     *
     * @return RvExtra
     */
    public function setRvExtraNoteInternal($rvExtraNoteInternal)
    {
        $this->rvExtraNoteInternal = $rvExtraNoteInternal;

        return $this;
    }

    /**
     * Get rvExtraNoteInternal
     *
     * @return string
     */
    public function getRvExtraNoteInternal()
    {
        return $this->rvExtraNoteInternal;
    }

    /**
     * Set rvExtraRef
     *
     * @param string $rvExtraRef
     *
     * @return RvExtra
     */
    public function setRvExtraRef($rvExtraRef)
    {
        $this->rvExtraRef = $rvExtraRef;

        return $this;
    }

    /**
     * Get rvExtraRef
     *
     * @return string
     */
    public function getRvExtraRef()
    {
        return $this->rvExtraRef;
    }

    /**
     * Set rvExtraSupplierConfYn
     *
     * @param boolean $rvExtraSupplierConfYn
     *
     * @return RvExtra
     */
    public function setRvExtraSupplierConfYn($rvExtraSupplierConfYn)
    {
        $this->rvExtraSupplierConfYn = $rvExtraSupplierConfYn;

        return $this;
    }

    /**
     * Get rvExtraSupplierConfYn
     *
     * @return boolean
     */
    public function getRvExtraSupplierConfYn()
    {
        return $this->rvExtraSupplierConfYn;
    }

    /**
     * Set rvExtraTaxPerc
     *
     * @param string $rvExtraTaxPerc
     *
     * @return RvExtra
     */
    public function setRvExtraTaxPerc($rvExtraTaxPerc)
    {
        $this->rvExtraTaxPerc = $rvExtraTaxPerc;

        return $this;
    }

    /**
     * Get rvExtraTaxPerc
     *
     * @return string
     */
    public function getRvExtraTaxPerc()
    {
        return $this->rvExtraTaxPerc;
    }

    /**
     * Set rvExtraTravelEta
     *
     * @param string $rvExtraTravelEta
     *
     * @return RvExtra
     */
    public function setRvExtraTravelEta($rvExtraTravelEta)
    {
        $this->rvExtraTravelEta = $rvExtraTravelEta;

        return $this;
    }

    /**
     * Get rvExtraTravelEta
     *
     * @return string
     */
    public function getRvExtraTravelEta()
    {
        return $this->rvExtraTravelEta;
    }

    /**
     * Set rvExtraTravelEtd
     *
     * @param string $rvExtraTravelEtd
     *
     * @return RvExtra
     */
    public function setRvExtraTravelEtd($rvExtraTravelEtd)
    {
        $this->rvExtraTravelEtd = $rvExtraTravelEtd;

        return $this;
    }

    /**
     * Get rvExtraTravelEtd
     *
     * @return string
     */
    public function getRvExtraTravelEtd()
    {
        return $this->rvExtraTravelEtd;
    }

    /**
     * Set rvExtraAdultCount
     *
     * @param integer $rvExtraAdultCount
     *
     * @return RvExtra
     */
    public function setRvExtraAdultCount($rvExtraAdultCount)
    {
        $this->rvExtraAdultCount = $rvExtraAdultCount;

        return $this;
    }

    /**
     * Get rvExtraAdultCount
     *
     * @return integer
     */
    public function getRvExtraAdultCount()
    {
        return $this->rvExtraAdultCount;
    }

    /**
     * Set rvExtraChildCount
     *
     * @param integer $rvExtraChildCount
     *
     * @return RvExtra
     */
    public function setRvExtraChildCount($rvExtraChildCount)
    {
        $this->rvExtraChildCount = $rvExtraChildCount;

        return $this;
    }

    /**
     * Get rvExtraChildCount
     *
     * @return integer
     */
    public function getRvExtraChildCount()
    {
        return $this->rvExtraChildCount;
    }

    /**
     * Set rvExtraNights
     *
     * @param integer $rvExtraNights
     *
     * @return RvExtra
     */
    public function setRvExtraNights($rvExtraNights)
    {
        $this->rvExtraNights = $rvExtraNights;

        return $this;
    }

    /**
     * Get rvExtraNights
     *
     * @return integer
     */
    public function getRvExtraNights()
    {
        return $this->rvExtraNights;
    }

    /**
     * Set rvExtraDateDepart
     *
     * @param \DateTime $rvExtraDateDepart
     *
     * @return RvExtra
     */
    public function setRvExtraDateDepart($rvExtraDateDepart)
    {
        $this->rvExtraDateDepart = $rvExtraDateDepart;

        return $this;
    }

    /**
     * Get rvExtraDateDepart
     *
     * @return \DateTime
     */
    public function getRvExtraDateDepart()
    {
        return $this->rvExtraDateDepart;
    }

    /**
     * Set rvExtraInd
     *
     * @param boolean $rvExtraInd
     *
     * @return RvExtra
     */
    public function setRvExtraInd($rvExtraInd)
    {
        $this->rvExtraInd = $rvExtraInd;

        return $this;
    }

    /**
     * Get rvExtraInd
     *
     * @return boolean
     */
    public function getRvExtraInd()
    {
        return $this->rvExtraInd;
    }

    /**
     * Set rvExtraUnits
     *
     * @param integer $rvExtraUnits
     *
     * @return RvExtra
     */
    public function setRvExtraUnits($rvExtraUnits)
    {
        $this->rvExtraUnits = $rvExtraUnits;

        return $this;
    }

    /**
     * Get rvExtraUnits
     *
     * @return integer
     */
    public function getRvExtraUnits()
    {
        return $this->rvExtraUnits;
    }

    /**
     * Set rvExtraVoidInd
     *
     * @param boolean $rvExtraVoidInd
     *
     * @return RvExtra
     */
    public function setRvExtraVoidInd($rvExtraVoidInd)
    {
        $this->rvExtraVoidInd = $rvExtraVoidInd;

        return $this;
    }

    /**
     * Get rvExtraVoidInd
     *
     * @return boolean
     */
    public function getRvExtraVoidInd()
    {
        return $this->rvExtraVoidInd;
    }

    /**
     * Set rvExtraVoidLinkId
     *
     * @param string $rvExtraVoidLinkId
     *
     * @return RvExtra
     */
    public function setRvExtraVoidLinkId($rvExtraVoidLinkId)
    {
        $this->rvExtraVoidLinkId = $rvExtraVoidLinkId;

        return $this;
    }

    /**
     * Get rvExtraVoidLinkId
     *
     * @return string
     */
    public function getRvExtraVoidLinkId()
    {
        return $this->rvExtraVoidLinkId;
    }

    /**
     * Set rvExtraVoidReason
     *
     * @param string $rvExtraVoidReason
     *
     * @return RvExtra
     */
    public function setRvExtraVoidReason($rvExtraVoidReason)
    {
        $this->rvExtraVoidReason = $rvExtraVoidReason;

        return $this;
    }

    /**
     * Get rvExtraVoidReason
     *
     * @return string
     */
    public function getRvExtraVoidReason()
    {
        return $this->rvExtraVoidReason;
    }

    /**
     * Set rvExtraVoidSeq
     *
     * @param boolean $rvExtraVoidSeq
     *
     * @return RvExtra
     */
    public function setRvExtraVoidSeq($rvExtraVoidSeq)
    {
        $this->rvExtraVoidSeq = $rvExtraVoidSeq;

        return $this;
    }

    /**
     * Get rvExtraVoidSeq
     *
     * @return boolean
     */
    public function getRvExtraVoidSeq()
    {
        return $this->rvExtraVoidSeq;
    }

    /**
     * Set rvExtraVoidTime
     *
     * @param \DateTime $rvExtraVoidTime
     *
     * @return RvExtra
     */
    public function setRvExtraVoidTime($rvExtraVoidTime)
    {
        $this->rvExtraVoidTime = $rvExtraVoidTime;

        return $this;
    }

    /**
     * Get rvExtraVoidTime
     *
     * @return \DateTime
     */
    public function getRvExtraVoidTime()
    {
        return $this->rvExtraVoidTime;
    }

    /**
     * Set rvExtraVoidTimeTz
     *
     * @param string $rvExtraVoidTimeTz
     *
     * @return RvExtra
     */
    public function setRvExtraVoidTimeTz($rvExtraVoidTimeTz)
    {
        $this->rvExtraVoidTimeTz = $rvExtraVoidTimeTz;

        return $this;
    }

    /**
     * Get rvExtraVoidTimeTz
     *
     * @return string
     */
    public function getRvExtraVoidTimeTz()
    {
        return $this->rvExtraVoidTimeTz;
    }

    /**
     * Set rvExtraVoidUserId
     *
     * @param string $rvExtraVoidUserId
     *
     * @return RvExtra
     */
    public function setRvExtraVoidUserId($rvExtraVoidUserId)
    {
        $this->rvExtraVoidUserId = $rvExtraVoidUserId;

        return $this;
    }

    /**
     * Get rvExtraVoidUserId
     *
     * @return string
     */
    public function getRvExtraVoidUserId()
    {
        return $this->rvExtraVoidUserId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return RvExtra
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set acPosId
     *
     * @param string $acPosId
     *
     * @return RvExtra
     */
    public function setAcPosId($acPosId)
    {
        $this->acPosId = $acPosId;

        return $this;
    }

    /**
     * Get acPosId
     *
     * @return string
     */
    public function getAcPosId()
    {
        return $this->acPosId;
    }

    /**
     * Set fnFolioId
     *
     * @param string $fnFolioId
     *
     * @return RvExtra
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return string
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RvExtra
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set prBusinessInvId
     *
     * @param string $prBusinessInvId
     *
     * @return RvExtra
     */
    public function setPrBusinessInvId($prBusinessInvId)
    {
        $this->prBusinessInvId = $prBusinessInvId;

        return $this;
    }

    /**
     * Get prBusinessInvId
     *
     * @return string
     */
    public function getPrBusinessInvId()
    {
        return $this->prBusinessInvId;
    }

    /**
     * Set prSupplierId
     *
     * @param string $prSupplierId
     *
     * @return RvExtra
     */
    public function setPrSupplierId($prSupplierId)
    {
        $this->prSupplierId = $prSupplierId;

        return $this;
    }

    /**
     * Get prSupplierId
     *
     * @return string
     */
    public function getPrSupplierId()
    {
        return $this->prSupplierId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RvExtra
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfTaxId
     *
     * @param string $rfTaxId
     *
     * @return RvExtra
     */
    public function setRfTaxId($rfTaxId)
    {
        $this->rfTaxId = $rfTaxId;

        return $this;
    }

    /**
     * Get rfTaxId
     *
     * @return string
     */
    public function getRfTaxId()
    {
        return $this->rfTaxId;
    }

    /**
     * Set rvExtraTaxInd
     *
     * @param string $rvExtraTaxInd
     *
     * @return RvExtra
     */
    public function setRvExtraTaxInd($rvExtraTaxInd)
    {
        $this->rvExtraTaxInd = $rvExtraTaxInd;

        return $this;
    }

    /**
     * Get rvExtraTaxInd
     *
     * @return string
     */
    public function getRvExtraTaxInd()
    {
        return $this->rvExtraTaxInd;
    }

    /**
     * Set rvExtraInvCurrId
     *
     * @param string $rvExtraInvCurrId
     *
     * @return RvExtra
     */
    public function setRvExtraInvCurrId($rvExtraInvCurrId)
    {
        $this->rvExtraInvCurrId = $rvExtraInvCurrId;

        return $this;
    }

    /**
     * Get rvExtraInvCurrId
     *
     * @return string
     */
    public function getRvExtraInvCurrId()
    {
        return $this->rvExtraInvCurrId;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return RvExtra
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RvExtra
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RvExtra
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return RvExtra
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return RvExtra
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return RvExtra
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set rvPhoneId
     *
     * @param string $rvPhoneId
     *
     * @return RvExtra
     */
    public function setRvPhoneId($rvPhoneId)
    {
        $this->rvPhoneId = $rvPhoneId;

        return $this;
    }

    /**
     * Get rvPhoneId
     *
     * @return string
     */
    public function getRvPhoneId()
    {
        return $this->rvPhoneId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvExtra
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvResItemGroupId
     *
     * @param string $rvResItemGroupId
     *
     * @return RvExtra
     */
    public function setRvResItemGroupId($rvResItemGroupId)
    {
        $this->rvResItemGroupId = $rvResItemGroupId;

        return $this;
    }

    /**
     * Get rvResItemGroupId
     *
     * @return string
     */
    public function getRvResItemGroupId()
    {
        return $this->rvResItemGroupId;
    }

    /**
     * Set fnInvoiceItemId
     *
     * @param string $fnInvoiceItemId
     *
     * @return RvExtra
     */
    public function setFnInvoiceItemId($fnInvoiceItemId)
    {
        $this->fnInvoiceItemId = $fnInvoiceItemId;

        return $this;
    }

    /**
     * Get fnInvoiceItemId
     *
     * @return string
     */
    public function getFnInvoiceItemId()
    {
        return $this->fnInvoiceItemId;
    }

    /**
     * Set rvExtraTimestamp
     *
     * @param \DateTime $rvExtraTimestamp
     *
     * @return RvExtra
     */
    public function setRvExtraTimestamp($rvExtraTimestamp)
    {
        $this->rvExtraTimestamp = $rvExtraTimestamp;

        return $this;
    }

    /**
     * Get rvExtraTimestamp
     *
     * @return \DateTime
     */
    public function getRvExtraTimestamp()
    {
        return $this->rvExtraTimestamp;
    }

    /**
     * Set rvExtraDebug
     *
     * @param string $rvExtraDebug
     *
     * @return RvExtra
     */
    public function setRvExtraDebug($rvExtraDebug)
    {
        $this->rvExtraDebug = $rvExtraDebug;

        return $this;
    }

    /**
     * Get rvExtraDebug
     *
     * @return string
     */
    public function getRvExtraDebug()
    {
        return $this->rvExtraDebug;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvExtra
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvExtraTrfYn
     *
     * @param boolean $rvExtraTrfYn
     *
     * @return RvExtra
     */
    public function setRvExtraTrfYn($rvExtraTrfYn)
    {
        $this->rvExtraTrfYn = $rvExtraTrfYn;

        return $this;
    }

    /**
     * Get rvExtraTrfYn
     *
     * @return boolean
     */
    public function getRvExtraTrfYn()
    {
        return $this->rvExtraTrfYn;
    }
}
