<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvExtraProp
 *
 * @ORM\Table(name="rv_extra_prop", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_extra_prop_trf_yn", columns={"rv_extra_prop_trf_yn"})})
 * @ORM\Entity
 */
class RvExtraProp
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_prop_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvExtraPropIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_prop_db", type="string", length=2, nullable=false, options={"default"="0", "fixed"="true"})
     */
    private $rvExtraPropDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_prop_id", type="integer", nullable=false)
     */
    private $rvExtraPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_id", type="string", length=36, nullable=true)
     */
    private $rvExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_prop_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraPropTrfYn;



    /**
     * Get rvExtraPropIx
     *
     * @return string
     */
    public function getRvExtraPropIx()
    {
        return $this->rvExtraPropIx;
    }

    /**
     * Set rvExtraPropDb
     *
     * @param string $rvExtraPropDb
     *
     * @return RvExtraProp
     */
    public function setRvExtraPropDb($rvExtraPropDb)
    {
        $this->rvExtraPropDb = $rvExtraPropDb;

        return $this;
    }

    /**
     * Get rvExtraPropDb
     *
     * @return string
     */
    public function getRvExtraPropDb()
    {
        return $this->rvExtraPropDb;
    }

    /**
     * Set rvExtraPropId
     *
     * @param integer $rvExtraPropId
     *
     * @return RvExtraProp
     */
    public function setRvExtraPropId($rvExtraPropId)
    {
        $this->rvExtraPropId = $rvExtraPropId;

        return $this;
    }

    /**
     * Get rvExtraPropId
     *
     * @return integer
     */
    public function getRvExtraPropId()
    {
        return $this->rvExtraPropId;
    }

    /**
     * Set rvExtraId
     *
     * @param string $rvExtraId
     *
     * @return RvExtraProp
     */
    public function setRvExtraId($rvExtraId)
    {
        $this->rvExtraId = $rvExtraId;

        return $this;
    }

    /**
     * Get rvExtraId
     *
     * @return string
     */
    public function getRvExtraId()
    {
        return $this->rvExtraId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RvExtraProp
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvExtraProp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvExtraPropTrfYn
     *
     * @param boolean $rvExtraPropTrfYn
     *
     * @return RvExtraProp
     */
    public function setRvExtraPropTrfYn($rvExtraPropTrfYn)
    {
        $this->rvExtraPropTrfYn = $rvExtraPropTrfYn;

        return $this;
    }

    /**
     * Get rvExtraPropTrfYn
     *
     * @return boolean
     */
    public function getRvExtraPropTrfYn()
    {
        return $this->rvExtraPropTrfYn;
    }
}
