<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvExtraTax
 *
 * @ORM\Table(name="rv_extra_tax", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), name="rv_extra_tax_trf_yn", columns={"rv_extra_tax_trf_yn"}), @ORM\Index(name="rf_tax_rate_id", columns={"rf_tax_rate_id"}), @ORM\Index(name="rv_extra_id", columns={"rv_extra_id"})})
 * @ORM\Entity
 */
class RvExtraTax
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvExtraTaxIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvExtraTaxDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_extra_tax_id", type="integer", nullable=false)
     */
    private $rvExtraTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_perc", type="decimal", precision=16, scale=2, nullable=true, options={"default"="0.00"})
     */
    private $rvExtraTaxPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_tax_amt", type="decimal", precision=16, scale=6, nullable=true, options={"default"="0.000000"})
     */
    private $rvExtraTaxAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $adModifyUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_extra_tax_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvExtraTaxTrfYn;



    /**
     * Get rvExtraTaxIx
     *
     * @return string
     */
    public function getRvExtraTaxIx()
    {
        return $this->rvExtraTaxIx;
    }

    /**
     * Set rvExtraTaxDb
     *
     * @param string $rvExtraTaxDb
     *
     * @return RvExtraTax
     */
    public function setRvExtraTaxDb($rvExtraTaxDb)
    {
        $this->rvExtraTaxDb = $rvExtraTaxDb;

        return $this;
    }

    /**
     * Get rvExtraTaxDb
     *
     * @return string
     */
    public function getRvExtraTaxDb()
    {
        return $this->rvExtraTaxDb;
    }

    /**
     * Set rvExtraTaxId
     *
     * @param integer $rvExtraTaxId
     *
     * @return RvExtraTax
     */
    public function setRvExtraTaxId($rvExtraTaxId)
    {
        $this->rvExtraTaxId = $rvExtraTaxId;

        return $this;
    }

    /**
     * Get rvExtraTaxId
     *
     * @return integer
     */
    public function getRvExtraTaxId()
    {
        return $this->rvExtraTaxId;
    }

    /**
     * Set rvExtraId
     *
     * @param string $rvExtraId
     *
     * @return RvExtraTax
     */
    public function setRvExtraId($rvExtraId)
    {
        $this->rvExtraId = $rvExtraId;

        return $this;
    }

    /**
     * Get rvExtraId
     *
     * @return string
     */
    public function getRvExtraId()
    {
        return $this->rvExtraId;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return RvExtraTax
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set rvExtraTaxPerc
     *
     * @param string $rvExtraTaxPerc
     *
     * @return RvExtraTax
     */
    public function setRvExtraTaxPerc($rvExtraTaxPerc)
    {
        $this->rvExtraTaxPerc = $rvExtraTaxPerc;

        return $this;
    }

    /**
     * Get rvExtraTaxPerc
     *
     * @return string
     */
    public function getRvExtraTaxPerc()
    {
        return $this->rvExtraTaxPerc;
    }

    /**
     * Set rvExtraTaxAmt
     *
     * @param string $rvExtraTaxAmt
     *
     * @return RvExtraTax
     */
    public function setRvExtraTaxAmt($rvExtraTaxAmt)
    {
        $this->rvExtraTaxAmt = $rvExtraTaxAmt;

        return $this;
    }

    /**
     * Get rvExtraTaxAmt
     *
     * @return string
     */
    public function getRvExtraTaxAmt()
    {
        return $this->rvExtraTaxAmt;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return RvExtraTax
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RvExtraTax
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RvExtraTax
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return RvExtraTax
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return RvExtraTax
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return RvExtraTax
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvExtraTax
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvExtraTaxTrfYn
     *
     * @param boolean $rvExtraTaxTrfYn
     *
     * @return RvExtraTax
     */
    public function setRvExtraTaxTrfYn($rvExtraTaxTrfYn)
    {
        $this->rvExtraTaxTrfYn = $rvExtraTaxTrfYn;

        return $this;
    }

    /**
     * Get rvExtraTaxTrfYn
     *
     * @return boolean
     */
    public function getRvExtraTaxTrfYn()
    {
        return $this->rvExtraTaxTrfYn;
    }
}
