<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvNote
 *
 * @ORM\Table(name="rv_note", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="rv_note_trf_yn", columns={"rv_note_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvNote
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvNoteIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvNoteDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_note_id", type="integer", nullable=false)
     */
    private $rvNoteId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_conf", type="text", length=65535, nullable=true)
     */
    private $rvNoteConf;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_general", type="text", length=65535, nullable=true)
     */
    private $rvNoteGeneral;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_guests", type="text", length=65535, nullable=true)
     */
    private $rvNoteGuests;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_internal", type="text", length=65535, nullable=true)
     */
    private $rvNoteInternal;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_id", type="string", length=36, nullable=true)
     */
    private $rfCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_note_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvNoteTrfYn;



    /**
     * Get rvNoteIx
     *
     * @return string
     */
    public function getRvNoteIx()
    {
        return $this->rvNoteIx;
    }

    /**
     * Set rvNoteDb
     *
     * @param string $rvNoteDb
     *
     * @return RvNote
     */
    public function setRvNoteDb($rvNoteDb)
    {
        $this->rvNoteDb = $rvNoteDb;

        return $this;
    }

    /**
     * Get rvNoteDb
     *
     * @return string
     */
    public function getRvNoteDb()
    {
        return $this->rvNoteDb;
    }

    /**
     * Set rvNoteId
     *
     * @param integer $rvNoteId
     *
     * @return RvNote
     */
    public function setRvNoteId($rvNoteId)
    {
        $this->rvNoteId = $rvNoteId;

        return $this;
    }

    /**
     * Get rvNoteId
     *
     * @return integer
     */
    public function getRvNoteId()
    {
        return $this->rvNoteId;
    }

    /**
     * Set rvNoteConf
     *
     * @param string $rvNoteConf
     *
     * @return RvNote
     */
    public function setRvNoteConf($rvNoteConf)
    {
        $this->rvNoteConf = $rvNoteConf;

        return $this;
    }

    /**
     * Get rvNoteConf
     *
     * @return string
     */
    public function getRvNoteConf()
    {
        return $this->rvNoteConf;
    }

    /**
     * Set rvNoteGeneral
     *
     * @param string $rvNoteGeneral
     *
     * @return RvNote
     */
    public function setRvNoteGeneral($rvNoteGeneral)
    {
        $this->rvNoteGeneral = $rvNoteGeneral;

        return $this;
    }

    /**
     * Get rvNoteGeneral
     *
     * @return string
     */
    public function getRvNoteGeneral()
    {
        return $this->rvNoteGeneral;
    }

    /**
     * Set rvNoteGuests
     *
     * @param string $rvNoteGuests
     *
     * @return RvNote
     */
    public function setRvNoteGuests($rvNoteGuests)
    {
        $this->rvNoteGuests = $rvNoteGuests;

        return $this;
    }

    /**
     * Get rvNoteGuests
     *
     * @return string
     */
    public function getRvNoteGuests()
    {
        return $this->rvNoteGuests;
    }

    /**
     * Set rvNoteInternal
     *
     * @param string $rvNoteInternal
     *
     * @return RvNote
     */
    public function setRvNoteInternal($rvNoteInternal)
    {
        $this->rvNoteInternal = $rvNoteInternal;

        return $this;
    }

    /**
     * Get rvNoteInternal
     *
     * @return string
     */
    public function getRvNoteInternal()
    {
        return $this->rvNoteInternal;
    }

    /**
     * Set rfCountryId
     *
     * @param string $rfCountryId
     *
     * @return RvNote
     */
    public function setRfCountryId($rfCountryId)
    {
        $this->rfCountryId = $rfCountryId;

        return $this;
    }

    /**
     * Get rfCountryId
     *
     * @return string
     */
    public function getRfCountryId()
    {
        return $this->rfCountryId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvNote
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RvNote
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RvNote
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return RvNote
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvNote
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvNoteTrfYn
     *
     * @param boolean $rvNoteTrfYn
     *
     * @return RvNote
     */
    public function setRvNoteTrfYn($rvNoteTrfYn)
    {
        $this->rvNoteTrfYn = $rvNoteTrfYn;

        return $this;
    }

    /**
     * Get rvNoteTrfYn
     *
     * @return boolean
     */
    public function getRvNoteTrfYn()
    {
        return $this->rvNoteTrfYn;
    }
}
