<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvPayPlanItem
 *
 * @ORM\Table(name="rv_pay_plan_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="rv_pay_plan_item_trf_yn", columns={"rv_pay_plan_item_trf_yn"})})
 * @ORM\Entity
 */
class RvPayPlanItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_plan_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvPayPlanItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_plan_item_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvPayPlanItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_pay_plan_item_id", type="integer", nullable=false)
     */
    private $rvPayPlanItemId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pay_plan_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvPayPlanDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_plan_amount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPayPlanAmount;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_pay_plan_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPayPlanItemTrfYn;



    /**
     * Get rvPayPlanItemIx
     *
     * @return string
     */
    public function getRvPayPlanItemIx()
    {
        return $this->rvPayPlanItemIx;
    }

    /**
     * Set rvPayPlanItemDb
     *
     * @param string $rvPayPlanItemDb
     *
     * @return RvPayPlanItem
     */
    public function setRvPayPlanItemDb($rvPayPlanItemDb)
    {
        $this->rvPayPlanItemDb = $rvPayPlanItemDb;

        return $this;
    }

    /**
     * Get rvPayPlanItemDb
     *
     * @return string
     */
    public function getRvPayPlanItemDb()
    {
        return $this->rvPayPlanItemDb;
    }

    /**
     * Set rvPayPlanItemId
     *
     * @param integer $rvPayPlanItemId
     *
     * @return RvPayPlanItem
     */
    public function setRvPayPlanItemId($rvPayPlanItemId)
    {
        $this->rvPayPlanItemId = $rvPayPlanItemId;

        return $this;
    }

    /**
     * Get rvPayPlanItemId
     *
     * @return integer
     */
    public function getRvPayPlanItemId()
    {
        return $this->rvPayPlanItemId;
    }

    /**
     * Set rvPayPlanDate
     *
     * @param \DateTime $rvPayPlanDate
     *
     * @return RvPayPlanItem
     */
    public function setRvPayPlanDate($rvPayPlanDate)
    {
        $this->rvPayPlanDate = $rvPayPlanDate;

        return $this;
    }

    /**
     * Get rvPayPlanDate
     *
     * @return \DateTime
     */
    public function getRvPayPlanDate()
    {
        return $this->rvPayPlanDate;
    }

    /**
     * Set rvPayPlanAmount
     *
     * @param string $rvPayPlanAmount
     *
     * @return RvPayPlanItem
     */
    public function setRvPayPlanAmount($rvPayPlanAmount)
    {
        $this->rvPayPlanAmount = $rvPayPlanAmount;

        return $this;
    }

    /**
     * Get rvPayPlanAmount
     *
     * @return string
     */
    public function getRvPayPlanAmount()
    {
        return $this->rvPayPlanAmount;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvPayPlanItem
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvPayPlanItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvPayPlanItemTrfYn
     *
     * @param boolean $rvPayPlanItemTrfYn
     *
     * @return RvPayPlanItem
     */
    public function setRvPayPlanItemTrfYn($rvPayPlanItemTrfYn)
    {
        $this->rvPayPlanItemTrfYn = $rvPayPlanItemTrfYn;

        return $this;
    }

    /**
     * Get rvPayPlanItemTrfYn
     *
     * @return boolean
     */
    public function getRvPayPlanItemTrfYn()
    {
        return $this->rvPayPlanItemTrfYn;
    }
}
