<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvPayment
 *
 * @ORM\Table(name="rv_payment", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_payment_trf_yn", columns={"rv_payment_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvPayment
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvPaymentIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvPaymentDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_payment_id", type="integer", nullable=false)
     */
    private $rvPaymentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pmnt_amount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.000000"})
     */
    private $rvPmntAmount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pmnt_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvPmntDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pmnt_date_created", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvPmntDateCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pmnt_date_created_tz", type="string", length=40, nullable=false)
     */
    private $rvPmntDateCreatedTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pmnt_note", type="text", length=65535, nullable=true)
     */
    private $rvPmntNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pmnt_ref", type="text", length=65535, nullable=true)
     */
    private $rvPmntRef;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_mthd_pmnt_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfMthdPmntId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pmnt_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvPmntUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_payment_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPaymentTrfYn;



    /**
     * Get rvPaymentIx
     *
     * @return string
     */
    public function getRvPaymentIx()
    {
        return $this->rvPaymentIx;
    }

    /**
     * Set rvPaymentDb
     *
     * @param string $rvPaymentDb
     *
     * @return RvPayment
     */
    public function setRvPaymentDb($rvPaymentDb)
    {
        $this->rvPaymentDb = $rvPaymentDb;

        return $this;
    }

    /**
     * Get rvPaymentDb
     *
     * @return string
     */
    public function getRvPaymentDb()
    {
        return $this->rvPaymentDb;
    }

    /**
     * Set rvPaymentId
     *
     * @param integer $rvPaymentId
     *
     * @return RvPayment
     */
    public function setRvPaymentId($rvPaymentId)
    {
        $this->rvPaymentId = $rvPaymentId;

        return $this;
    }

    /**
     * Get rvPaymentId
     *
     * @return integer
     */
    public function getRvPaymentId()
    {
        return $this->rvPaymentId;
    }

    /**
     * Set rvPmntAmount
     *
     * @param string $rvPmntAmount
     *
     * @return RvPayment
     */
    public function setRvPmntAmount($rvPmntAmount)
    {
        $this->rvPmntAmount = $rvPmntAmount;

        return $this;
    }

    /**
     * Get rvPmntAmount
     *
     * @return string
     */
    public function getRvPmntAmount()
    {
        return $this->rvPmntAmount;
    }

    /**
     * Set rvPmntDate
     *
     * @param \DateTime $rvPmntDate
     *
     * @return RvPayment
     */
    public function setRvPmntDate($rvPmntDate)
    {
        $this->rvPmntDate = $rvPmntDate;

        return $this;
    }

    /**
     * Get rvPmntDate
     *
     * @return \DateTime
     */
    public function getRvPmntDate()
    {
        return $this->rvPmntDate;
    }

    /**
     * Set rvPmntDateCreated
     *
     * @param \DateTime $rvPmntDateCreated
     *
     * @return RvPayment
     */
    public function setRvPmntDateCreated($rvPmntDateCreated)
    {
        $this->rvPmntDateCreated = $rvPmntDateCreated;

        return $this;
    }

    /**
     * Get rvPmntDateCreated
     *
     * @return \DateTime
     */
    public function getRvPmntDateCreated()
    {
        return $this->rvPmntDateCreated;
    }

    /**
     * Set rvPmntDateCreatedTz
     *
     * @param string $rvPmntDateCreatedTz
     *
     * @return RvPayment
     */
    public function setRvPmntDateCreatedTz($rvPmntDateCreatedTz)
    {
        $this->rvPmntDateCreatedTz = $rvPmntDateCreatedTz;

        return $this;
    }

    /**
     * Get rvPmntDateCreatedTz
     *
     * @return string
     */
    public function getRvPmntDateCreatedTz()
    {
        return $this->rvPmntDateCreatedTz;
    }

    /**
     * Set rvPmntNote
     *
     * @param string $rvPmntNote
     *
     * @return RvPayment
     */
    public function setRvPmntNote($rvPmntNote)
    {
        $this->rvPmntNote = $rvPmntNote;

        return $this;
    }

    /**
     * Get rvPmntNote
     *
     * @return string
     */
    public function getRvPmntNote()
    {
        return $this->rvPmntNote;
    }

    /**
     * Set rvPmntRef
     *
     * @param string $rvPmntRef
     *
     * @return RvPayment
     */
    public function setRvPmntRef($rvPmntRef)
    {
        $this->rvPmntRef = $rvPmntRef;

        return $this;
    }

    /**
     * Get rvPmntRef
     *
     * @return string
     */
    public function getRvPmntRef()
    {
        return $this->rvPmntRef;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return RvPayment
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return RvPayment
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RvPayment
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfMthdPmntId
     *
     * @param string $rfMthdPmntId
     *
     * @return RvPayment
     */
    public function setRfMthdPmntId($rfMthdPmntId)
    {
        $this->rfMthdPmntId = $rfMthdPmntId;

        return $this;
    }

    /**
     * Get rfMthdPmntId
     *
     * @return string
     */
    public function getRfMthdPmntId()
    {
        return $this->rfMthdPmntId;
    }

    /**
     * Set rvPmntUserId
     *
     * @param string $rvPmntUserId
     *
     * @return RvPayment
     */
    public function setRvPmntUserId($rvPmntUserId)
    {
        $this->rvPmntUserId = $rvPmntUserId;

        return $this;
    }

    /**
     * Get rvPmntUserId
     *
     * @return string
     */
    public function getRvPmntUserId()
    {
        return $this->rvPmntUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvPayment
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvPaymentTrfYn
     *
     * @param boolean $rvPaymentTrfYn
     *
     * @return RvPayment
     */
    public function setRvPaymentTrfYn($rvPaymentTrfYn)
    {
        $this->rvPaymentTrfYn = $rvPaymentTrfYn;

        return $this;
    }

    /**
     * Get rvPaymentTrfYn
     *
     * @return boolean
     */
    public function getRvPaymentTrfYn()
    {
        return $this->rvPaymentTrfYn;
    }
}
