<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvPaymentGateway
 *
 * @ORM\Table(name="rv_payment_gateway", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_payment_gateway_trf_yn", columns={"rv_payment_gateway_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvPaymentGateway
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvPaymentGatewayIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvPaymentGatewayDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_payment_gateway_id", type="integer", nullable=false)
     */
    private $rvPaymentGatewayId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_amt_req", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPaymentGatewayAmtReq;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_amt_paid", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPaymentGatewayAmtPaid;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_ref", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $rvPaymentGatewayRef;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_payment_gateway_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPaymentGatewayInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_log", type="text", length=65535, nullable=true)
     */
    private $rvPaymentGatewayLog;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_id", type="string", length=36, nullable=true)
     */
    private $pgAccountId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_payment_gateway_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPaymentGatewayTrfYn;



    /**
     * Get rvPaymentGatewayIx
     *
     * @return string
     */
    public function getRvPaymentGatewayIx()
    {
        return $this->rvPaymentGatewayIx;
    }

    /**
     * Set rvPaymentGatewayDb
     *
     * @param string $rvPaymentGatewayDb
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayDb($rvPaymentGatewayDb)
    {
        $this->rvPaymentGatewayDb = $rvPaymentGatewayDb;

        return $this;
    }

    /**
     * Get rvPaymentGatewayDb
     *
     * @return string
     */
    public function getRvPaymentGatewayDb()
    {
        return $this->rvPaymentGatewayDb;
    }

    /**
     * Set rvPaymentGatewayId
     *
     * @param integer $rvPaymentGatewayId
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayId($rvPaymentGatewayId)
    {
        $this->rvPaymentGatewayId = $rvPaymentGatewayId;

        return $this;
    }

    /**
     * Get rvPaymentGatewayId
     *
     * @return integer
     */
    public function getRvPaymentGatewayId()
    {
        return $this->rvPaymentGatewayId;
    }

    /**
     * Set rvPaymentGatewayAmtReq
     *
     * @param string $rvPaymentGatewayAmtReq
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayAmtReq($rvPaymentGatewayAmtReq)
    {
        $this->rvPaymentGatewayAmtReq = $rvPaymentGatewayAmtReq;

        return $this;
    }

    /**
     * Get rvPaymentGatewayAmtReq
     *
     * @return string
     */
    public function getRvPaymentGatewayAmtReq()
    {
        return $this->rvPaymentGatewayAmtReq;
    }

    /**
     * Set rvPaymentGatewayAmtPaid
     *
     * @param string $rvPaymentGatewayAmtPaid
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayAmtPaid($rvPaymentGatewayAmtPaid)
    {
        $this->rvPaymentGatewayAmtPaid = $rvPaymentGatewayAmtPaid;

        return $this;
    }

    /**
     * Get rvPaymentGatewayAmtPaid
     *
     * @return string
     */
    public function getRvPaymentGatewayAmtPaid()
    {
        return $this->rvPaymentGatewayAmtPaid;
    }

    /**
     * Set rvPaymentGatewayRef
     *
     * @param string $rvPaymentGatewayRef
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayRef($rvPaymentGatewayRef)
    {
        $this->rvPaymentGatewayRef = $rvPaymentGatewayRef;

        return $this;
    }

    /**
     * Get rvPaymentGatewayRef
     *
     * @return string
     */
    public function getRvPaymentGatewayRef()
    {
        return $this->rvPaymentGatewayRef;
    }

    /**
     * Set rvPaymentGatewayInd
     *
     * @param boolean $rvPaymentGatewayInd
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayInd($rvPaymentGatewayInd)
    {
        $this->rvPaymentGatewayInd = $rvPaymentGatewayInd;

        return $this;
    }

    /**
     * Get rvPaymentGatewayInd
     *
     * @return boolean
     */
    public function getRvPaymentGatewayInd()
    {
        return $this->rvPaymentGatewayInd;
    }

    /**
     * Set rvPaymentGatewayLog
     *
     * @param string $rvPaymentGatewayLog
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayLog($rvPaymentGatewayLog)
    {
        $this->rvPaymentGatewayLog = $rvPaymentGatewayLog;

        return $this;
    }

    /**
     * Get rvPaymentGatewayLog
     *
     * @return string
     */
    public function getRvPaymentGatewayLog()
    {
        return $this->rvPaymentGatewayLog;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RvPaymentGateway
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvPaymentGateway
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set pgAccountId
     *
     * @param string $pgAccountId
     *
     * @return RvPaymentGateway
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return string
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RvPaymentGateway
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RvPaymentGateway
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return RvPaymentGateway
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return RvPaymentGateway
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return RvPaymentGateway
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return RvPaymentGateway
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return RvPaymentGateway
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return RvPaymentGateway
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return RvPaymentGateway
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvPaymentGateway
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvPaymentGatewayTrfYn
     *
     * @param boolean $rvPaymentGatewayTrfYn
     *
     * @return RvPaymentGateway
     */
    public function setRvPaymentGatewayTrfYn($rvPaymentGatewayTrfYn)
    {
        $this->rvPaymentGatewayTrfYn = $rvPaymentGatewayTrfYn;

        return $this;
    }

    /**
     * Get rvPaymentGatewayTrfYn
     *
     * @return boolean
     */
    public function getRvPaymentGatewayTrfYn()
    {
        return $this->rvPaymentGatewayTrfYn;
    }
}
