<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvPaymentItem
 *
 * @ORM\Table(name="rv_payment_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_payment_item_trf_yn", columns={"rv_payment_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="rv_payment_id", columns={"rv_payment_id"}), @ORM\Index(name="fn_folio_id", columns={"fn_folio_id"}), @ORM\Index(name="fn_folio_id_2", columns={"fn_folio_id"})})
 * @ORM\Entity
 */
class RvPaymentItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvPaymentItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvPaymentItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_payment_item_id", type="integer", nullable=false)
     */
    private $rvPaymentItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvPaymentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_gateway_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentGatewayId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_amt", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPaymentItemAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_item_amt_rec", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPayItemAmtRec;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pay_item_date_posted", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvPayItemDatePosted;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_item_exch_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="0.000000"})
     */
    private $rvPayItemExchRate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pay_item_timestamp", type="datetime", columnDefinition="timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
     */
    private $rvPayItemTimestamp;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_pay_item_void_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvPayItemVoidTime;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_item_void_time_tz", type="string", length=40, nullable=false)
     */
    private $rvPayItemVoidTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_pay_item_void_user_id", type="string", length=36, nullable=true)
     */
    private $rvPayItemVoidUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_id", type="string", length=36, nullable=true)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_id", type="string", length=36, nullable=true)
     */
    private $fnTranId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_contra_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentContraId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_payment_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPaymentItemTrfYn;



    /**
     * Get rvPaymentItemIx
     *
     * @return string
     */
    public function getRvPaymentItemIx()
    {
        return $this->rvPaymentItemIx;
    }

    /**
     * Set rvPaymentItemDb
     *
     * @param string $rvPaymentItemDb
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentItemDb($rvPaymentItemDb)
    {
        $this->rvPaymentItemDb = $rvPaymentItemDb;

        return $this;
    }

    /**
     * Get rvPaymentItemDb
     *
     * @return string
     */
    public function getRvPaymentItemDb()
    {
        return $this->rvPaymentItemDb;
    }

    /**
     * Set rvPaymentItemId
     *
     * @param integer $rvPaymentItemId
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentItemId($rvPaymentItemId)
    {
        $this->rvPaymentItemId = $rvPaymentItemId;

        return $this;
    }

    /**
     * Get rvPaymentItemId
     *
     * @return integer
     */
    public function getRvPaymentItemId()
    {
        return $this->rvPaymentItemId;
    }

    /**
     * Set rvPaymentId
     *
     * @param string $rvPaymentId
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentId($rvPaymentId)
    {
        $this->rvPaymentId = $rvPaymentId;

        return $this;
    }

    /**
     * Get rvPaymentId
     *
     * @return string
     */
    public function getRvPaymentId()
    {
        return $this->rvPaymentId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvPaymentItem
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvPaymentGatewayId
     *
     * @param string $rvPaymentGatewayId
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentGatewayId($rvPaymentGatewayId)
    {
        $this->rvPaymentGatewayId = $rvPaymentGatewayId;

        return $this;
    }

    /**
     * Get rvPaymentGatewayId
     *
     * @return string
     */
    public function getRvPaymentGatewayId()
    {
        return $this->rvPaymentGatewayId;
    }

    /**
     * Set rvPaymentItemAmt
     *
     * @param string $rvPaymentItemAmt
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentItemAmt($rvPaymentItemAmt)
    {
        $this->rvPaymentItemAmt = $rvPaymentItemAmt;

        return $this;
    }

    /**
     * Get rvPaymentItemAmt
     *
     * @return string
     */
    public function getRvPaymentItemAmt()
    {
        return $this->rvPaymentItemAmt;
    }

    /**
     * Set rvPayItemAmtRec
     *
     * @param string $rvPayItemAmtRec
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemAmtRec($rvPayItemAmtRec)
    {
        $this->rvPayItemAmtRec = $rvPayItemAmtRec;

        return $this;
    }

    /**
     * Get rvPayItemAmtRec
     *
     * @return string
     */
    public function getRvPayItemAmtRec()
    {
        return $this->rvPayItemAmtRec;
    }

    /**
     * Set rvPayItemDatePosted
     *
     * @param \DateTime $rvPayItemDatePosted
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemDatePosted($rvPayItemDatePosted)
    {
        $this->rvPayItemDatePosted = $rvPayItemDatePosted;

        return $this;
    }

    /**
     * Get rvPayItemDatePosted
     *
     * @return \DateTime
     */
    public function getRvPayItemDatePosted()
    {
        return $this->rvPayItemDatePosted;
    }

    /**
     * Set rvPayItemExchRate
     *
     * @param string $rvPayItemExchRate
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemExchRate($rvPayItemExchRate)
    {
        $this->rvPayItemExchRate = $rvPayItemExchRate;

        return $this;
    }

    /**
     * Get rvPayItemExchRate
     *
     * @return string
     */
    public function getRvPayItemExchRate()
    {
        return $this->rvPayItemExchRate;
    }

    /**
     * Set rvPayItemTimestamp
     *
     * @param \DateTime $rvPayItemTimestamp
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemTimestamp($rvPayItemTimestamp)
    {
        $this->rvPayItemTimestamp = $rvPayItemTimestamp;

        return $this;
    }

    /**
     * Get rvPayItemTimestamp
     *
     * @return \DateTime
     */
    public function getRvPayItemTimestamp()
    {
        return $this->rvPayItemTimestamp;
    }

    /**
     * Set rvPayItemVoidTime
     *
     * @param \DateTime $rvPayItemVoidTime
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemVoidTime($rvPayItemVoidTime)
    {
        $this->rvPayItemVoidTime = $rvPayItemVoidTime;

        return $this;
    }

    /**
     * Get rvPayItemVoidTime
     *
     * @return \DateTime
     */
    public function getRvPayItemVoidTime()
    {
        return $this->rvPayItemVoidTime;
    }

    /**
     * Set rvPayItemVoidTimeTz
     *
     * @param string $rvPayItemVoidTimeTz
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemVoidTimeTz($rvPayItemVoidTimeTz)
    {
        $this->rvPayItemVoidTimeTz = $rvPayItemVoidTimeTz;

        return $this;
    }

    /**
     * Get rvPayItemVoidTimeTz
     *
     * @return string
     */
    public function getRvPayItemVoidTimeTz()
    {
        return $this->rvPayItemVoidTimeTz;
    }

    /**
     * Set rvPayItemVoidUserId
     *
     * @param string $rvPayItemVoidUserId
     *
     * @return RvPaymentItem
     */
    public function setRvPayItemVoidUserId($rvPayItemVoidUserId)
    {
        $this->rvPayItemVoidUserId = $rvPayItemVoidUserId;

        return $this;
    }

    /**
     * Get rvPayItemVoidUserId
     *
     * @return string
     */
    public function getRvPayItemVoidUserId()
    {
        return $this->rvPayItemVoidUserId;
    }

    /**
     * Set fnFolioId
     *
     * @param string $fnFolioId
     *
     * @return RvPaymentItem
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return string
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set fnTranId
     *
     * @param string $fnTranId
     *
     * @return RvPaymentItem
     */
    public function setFnTranId($fnTranId)
    {
        $this->fnTranId = $fnTranId;

        return $this;
    }

    /**
     * Get fnTranId
     *
     * @return string
     */
    public function getFnTranId()
    {
        return $this->fnTranId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RvPaymentItem
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rvPaymentContraId
     *
     * @param string $rvPaymentContraId
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentContraId($rvPaymentContraId)
    {
        $this->rvPaymentContraId = $rvPaymentContraId;

        return $this;
    }

    /**
     * Get rvPaymentContraId
     *
     * @return string
     */
    public function getRvPaymentContraId()
    {
        return $this->rvPaymentContraId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvPaymentItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvPaymentItemTrfYn
     *
     * @param boolean $rvPaymentItemTrfYn
     *
     * @return RvPaymentItem
     */
    public function setRvPaymentItemTrfYn($rvPaymentItemTrfYn)
    {
        $this->rvPaymentItemTrfYn = $rvPaymentItemTrfYn;

        return $this;
    }

    /**
     * Get rvPaymentItemTrfYn
     *
     * @return boolean
     */
    public function getRvPaymentItemTrfYn()
    {
        return $this->rvPaymentItemTrfYn;
    }
}
