<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvPhone
 *
 * @ORM\Table(name="rv_phone", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_phone_trf_yn", columns={"rv_phone_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvPhone
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvPhoneIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvPhoneDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_phone_id", type="integer", nullable=false)
     */
    private $rvPhoneId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_type", type="string", length=1, nullable=true, options={"fixed"="true"})
     */
    private $rvPhoneType;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_num", type="string", length=20, nullable=true)
     */
    private $rvPhoneNum;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_dept", type="string", length=11, nullable=true)
     */
    private $rvPhoneDept;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_extn", type="string", length=20, nullable=true)
     */
    private $rvPhoneExtn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_phone_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvPhoneDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_date_tz", type="string", length=40, nullable=false)
     */
    private $rvPhoneDateTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_phone_dur", type="time", nullable=false, options={"default"="00:00:00"})
     */
    private $rvPhoneDur;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_phone_cost", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvPhoneCost;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_extra_id", type="string", length=36, nullable=true)
     */
    private $rvExtraId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_rec", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateRec;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_rec_tz", type="string", length=40, nullable=false)
     */
    private $syDateRecTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_upd", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateUpd;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_upd_tz", type="string", length=40, nullable=false)
     */
    private $syDateUpdTz;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_phone_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvPhoneTrfYn;



    /**
     * Get rvPhoneIx
     *
     * @return string
     */
    public function getRvPhoneIx()
    {
        return $this->rvPhoneIx;
    }

    /**
     * Set rvPhoneDb
     *
     * @param string $rvPhoneDb
     *
     * @return RvPhone
     */
    public function setRvPhoneDb($rvPhoneDb)
    {
        $this->rvPhoneDb = $rvPhoneDb;

        return $this;
    }

    /**
     * Get rvPhoneDb
     *
     * @return string
     */
    public function getRvPhoneDb()
    {
        return $this->rvPhoneDb;
    }

    /**
     * Set rvPhoneId
     *
     * @param integer $rvPhoneId
     *
     * @return RvPhone
     */
    public function setRvPhoneId($rvPhoneId)
    {
        $this->rvPhoneId = $rvPhoneId;

        return $this;
    }

    /**
     * Get rvPhoneId
     *
     * @return integer
     */
    public function getRvPhoneId()
    {
        return $this->rvPhoneId;
    }

    /**
     * Set rvPhoneType
     *
     * @param string $rvPhoneType
     *
     * @return RvPhone
     */
    public function setRvPhoneType($rvPhoneType)
    {
        $this->rvPhoneType = $rvPhoneType;

        return $this;
    }

    /**
     * Get rvPhoneType
     *
     * @return string
     */
    public function getRvPhoneType()
    {
        return $this->rvPhoneType;
    }

    /**
     * Set rvPhoneNum
     *
     * @param string $rvPhoneNum
     *
     * @return RvPhone
     */
    public function setRvPhoneNum($rvPhoneNum)
    {
        $this->rvPhoneNum = $rvPhoneNum;

        return $this;
    }

    /**
     * Get rvPhoneNum
     *
     * @return string
     */
    public function getRvPhoneNum()
    {
        return $this->rvPhoneNum;
    }

    /**
     * Set rvPhoneDept
     *
     * @param string $rvPhoneDept
     *
     * @return RvPhone
     */
    public function setRvPhoneDept($rvPhoneDept)
    {
        $this->rvPhoneDept = $rvPhoneDept;

        return $this;
    }

    /**
     * Get rvPhoneDept
     *
     * @return string
     */
    public function getRvPhoneDept()
    {
        return $this->rvPhoneDept;
    }

    /**
     * Set rvPhoneExtn
     *
     * @param string $rvPhoneExtn
     *
     * @return RvPhone
     */
    public function setRvPhoneExtn($rvPhoneExtn)
    {
        $this->rvPhoneExtn = $rvPhoneExtn;

        return $this;
    }

    /**
     * Get rvPhoneExtn
     *
     * @return string
     */
    public function getRvPhoneExtn()
    {
        return $this->rvPhoneExtn;
    }

    /**
     * Set rvPhoneDate
     *
     * @param \DateTime $rvPhoneDate
     *
     * @return RvPhone
     */
    public function setRvPhoneDate($rvPhoneDate)
    {
        $this->rvPhoneDate = $rvPhoneDate;

        return $this;
    }

    /**
     * Get rvPhoneDate
     *
     * @return \DateTime
     */
    public function getRvPhoneDate()
    {
        return $this->rvPhoneDate;
    }

    /**
     * Set rvPhoneDateTz
     *
     * @param string $rvPhoneDateTz
     *
     * @return RvPhone
     */
    public function setRvPhoneDateTz($rvPhoneDateTz)
    {
        $this->rvPhoneDateTz = $rvPhoneDateTz;

        return $this;
    }

    /**
     * Get rvPhoneDateTz
     *
     * @return string
     */
    public function getRvPhoneDateTz()
    {
        return $this->rvPhoneDateTz;
    }

    /**
     * Set rvPhoneDur
     *
     * @param \DateTime $rvPhoneDur
     *
     * @return RvPhone
     */
    public function setRvPhoneDur($rvPhoneDur)
    {
        $this->rvPhoneDur = $rvPhoneDur;

        return $this;
    }

    /**
     * Get rvPhoneDur
     *
     * @return \DateTime
     */
    public function getRvPhoneDur()
    {
        return $this->rvPhoneDur;
    }

    /**
     * Set rvPhoneCost
     *
     * @param string $rvPhoneCost
     *
     * @return RvPhone
     */
    public function setRvPhoneCost($rvPhoneCost)
    {
        $this->rvPhoneCost = $rvPhoneCost;

        return $this;
    }

    /**
     * Get rvPhoneCost
     *
     * @return string
     */
    public function getRvPhoneCost()
    {
        return $this->rvPhoneCost;
    }

    /**
     * Set rvExtraId
     *
     * @param string $rvExtraId
     *
     * @return RvPhone
     */
    public function setRvExtraId($rvExtraId)
    {
        $this->rvExtraId = $rvExtraId;

        return $this;
    }

    /**
     * Get rvExtraId
     *
     * @return string
     */
    public function getRvExtraId()
    {
        return $this->rvExtraId;
    }

    /**
     * Set syDateRec
     *
     * @param \DateTime $syDateRec
     *
     * @return RvPhone
     */
    public function setSyDateRec($syDateRec)
    {
        $this->syDateRec = $syDateRec;

        return $this;
    }

    /**
     * Get syDateRec
     *
     * @return \DateTime
     */
    public function getSyDateRec()
    {
        return $this->syDateRec;
    }

    /**
     * Set syDateRecTz
     *
     * @param string $syDateRecTz
     *
     * @return RvPhone
     */
    public function setSyDateRecTz($syDateRecTz)
    {
        $this->syDateRecTz = $syDateRecTz;

        return $this;
    }

    /**
     * Get syDateRecTz
     *
     * @return string
     */
    public function getSyDateRecTz()
    {
        return $this->syDateRecTz;
    }

    /**
     * Set syDateUpd
     *
     * @param \DateTime $syDateUpd
     *
     * @return RvPhone
     */
    public function setSyDateUpd($syDateUpd)
    {
        $this->syDateUpd = $syDateUpd;

        return $this;
    }

    /**
     * Get syDateUpd
     *
     * @return \DateTime
     */
    public function getSyDateUpd()
    {
        return $this->syDateUpd;
    }

    /**
     * Set syDateUpdTz
     *
     * @param string $syDateUpdTz
     *
     * @return RvPhone
     */
    public function setSyDateUpdTz($syDateUpdTz)
    {
        $this->syDateUpdTz = $syDateUpdTz;

        return $this;
    }

    /**
     * Get syDateUpdTz
     *
     * @return string
     */
    public function getSyDateUpdTz()
    {
        return $this->syDateUpdTz;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvPhone
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvPhoneTrfYn
     *
     * @param boolean $rvPhoneTrfYn
     *
     * @return RvPhone
     */
    public function setRvPhoneTrfYn($rvPhoneTrfYn)
    {
        $this->rvPhoneTrfYn = $rvPhoneTrfYn;

        return $this;
    }

    /**
     * Get rvPhoneTrfYn
     *
     * @return boolean
     */
    public function getRvPhoneTrfYn()
    {
        return $this->rvPhoneTrfYn;
    }
}
