<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvResItemComp
 *
 * @ORM\Table(name="rv_res_item_comp", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_item_id", columns={"rv_reservation_item_id"}), @ORM\Index(name="rv_res_item_comp_trf_yn", columns={"rv_res_item_comp_trf_yn"})})
 * @ORM\Entity
 */
class RvResItemComp
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvResItemCompIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvResItemCompDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_comp_id", type="integer", nullable=false)
     */
    private $rvResItemCompId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_comm", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemCompAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_comm_calc", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemCompAmtCommCalc;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_gross", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemCompAmtGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_nett", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemCompAmtNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_payable", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompAmtPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvItemCompAmtTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_amt_sp_discount", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemCompAmtSpDiscount;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_comm_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCompCommInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_disc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompDisc;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_rate", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompRate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_rate_comm", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompRateComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_tax_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompTaxPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_comp_var", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemCompVar;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_freq_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCompFreqInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_freq_factor", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rvItemCompFreqFactor;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_edit_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCompEditYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_option_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCompOptionYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comp_separate_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCompSeparateYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_id", type="string", length=36, nullable=true)
     */
    private $rtComponentId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_ind", type="boolean", nullable=false, options={"default"="10"})
     */
    private $rtTaxInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_id", type="string", length=36, nullable=true)
     */
    private $rtTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_id", type="string", length=36, nullable=true)
     */
    private $fnInvoiceItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_id", type="string", length=36, nullable=true)
     */
    private $rvReservationItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_res_item_comp_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvResItemCompTrfYn;



    /**
     * Get rvResItemCompIx
     *
     * @return string
     */
    public function getRvResItemCompIx()
    {
        return $this->rvResItemCompIx;
    }

    /**
     * Set rvResItemCompDb
     *
     * @param string $rvResItemCompDb
     *
     * @return RvResItemComp
     */
    public function setRvResItemCompDb($rvResItemCompDb)
    {
        $this->rvResItemCompDb = $rvResItemCompDb;

        return $this;
    }

    /**
     * Get rvResItemCompDb
     *
     * @return string
     */
    public function getRvResItemCompDb()
    {
        return $this->rvResItemCompDb;
    }

    /**
     * Set rvResItemCompId
     *
     * @param integer $rvResItemCompId
     *
     * @return RvResItemComp
     */
    public function setRvResItemCompId($rvResItemCompId)
    {
        $this->rvResItemCompId = $rvResItemCompId;

        return $this;
    }

    /**
     * Get rvResItemCompId
     *
     * @return integer
     */
    public function getRvResItemCompId()
    {
        return $this->rvResItemCompId;
    }

    /**
     * Set rvItemCompAmtComm
     *
     * @param string $rvItemCompAmtComm
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtComm($rvItemCompAmtComm)
    {
        $this->rvItemCompAmtComm = $rvItemCompAmtComm;

        return $this;
    }

    /**
     * Get rvItemCompAmtComm
     *
     * @return string
     */
    public function getRvItemCompAmtComm()
    {
        return $this->rvItemCompAmtComm;
    }

    /**
     * Set rvItemCompAmtCommCalc
     *
     * @param string $rvItemCompAmtCommCalc
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtCommCalc($rvItemCompAmtCommCalc)
    {
        $this->rvItemCompAmtCommCalc = $rvItemCompAmtCommCalc;

        return $this;
    }

    /**
     * Get rvItemCompAmtCommCalc
     *
     * @return string
     */
    public function getRvItemCompAmtCommCalc()
    {
        return $this->rvItemCompAmtCommCalc;
    }

    /**
     * Set rvItemCompAmtGross
     *
     * @param string $rvItemCompAmtGross
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtGross($rvItemCompAmtGross)
    {
        $this->rvItemCompAmtGross = $rvItemCompAmtGross;

        return $this;
    }

    /**
     * Get rvItemCompAmtGross
     *
     * @return string
     */
    public function getRvItemCompAmtGross()
    {
        return $this->rvItemCompAmtGross;
    }

    /**
     * Set rvItemCompAmtNett
     *
     * @param string $rvItemCompAmtNett
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtNett($rvItemCompAmtNett)
    {
        $this->rvItemCompAmtNett = $rvItemCompAmtNett;

        return $this;
    }

    /**
     * Get rvItemCompAmtNett
     *
     * @return string
     */
    public function getRvItemCompAmtNett()
    {
        return $this->rvItemCompAmtNett;
    }

    /**
     * Set rvItemCompAmtPayable
     *
     * @param string $rvItemCompAmtPayable
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtPayable($rvItemCompAmtPayable)
    {
        $this->rvItemCompAmtPayable = $rvItemCompAmtPayable;

        return $this;
    }

    /**
     * Get rvItemCompAmtPayable
     *
     * @return string
     */
    public function getRvItemCompAmtPayable()
    {
        return $this->rvItemCompAmtPayable;
    }

    /**
     * Set rvItemCompAmtTax
     *
     * @param string $rvItemCompAmtTax
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtTax($rvItemCompAmtTax)
    {
        $this->rvItemCompAmtTax = $rvItemCompAmtTax;

        return $this;
    }

    /**
     * Get rvItemCompAmtTax
     *
     * @return string
     */
    public function getRvItemCompAmtTax()
    {
        return $this->rvItemCompAmtTax;
    }

    /**
     * Set rvItemCompAmtSpDiscount
     *
     * @param string $rvItemCompAmtSpDiscount
     *
     * @return RvResItemComp
     */
    public function setRvItemCompAmtSpDiscount($rvItemCompAmtSpDiscount)
    {
        $this->rvItemCompAmtSpDiscount = $rvItemCompAmtSpDiscount;

        return $this;
    }

    /**
     * Get rvItemCompAmtSpDiscount
     *
     * @return string
     */
    public function getRvItemCompAmtSpDiscount()
    {
        return $this->rvItemCompAmtSpDiscount;
    }

    /**
     * Set rvItemCompCommInd
     *
     * @param boolean $rvItemCompCommInd
     *
     * @return RvResItemComp
     */
    public function setRvItemCompCommInd($rvItemCompCommInd)
    {
        $this->rvItemCompCommInd = $rvItemCompCommInd;

        return $this;
    }

    /**
     * Get rvItemCompCommInd
     *
     * @return boolean
     */
    public function getRvItemCompCommInd()
    {
        return $this->rvItemCompCommInd;
    }

    /**
     * Set rvItemCompDisc
     *
     * @param string $rvItemCompDisc
     *
     * @return RvResItemComp
     */
    public function setRvItemCompDisc($rvItemCompDisc)
    {
        $this->rvItemCompDisc = $rvItemCompDisc;

        return $this;
    }

    /**
     * Get rvItemCompDisc
     *
     * @return string
     */
    public function getRvItemCompDisc()
    {
        return $this->rvItemCompDisc;
    }

    /**
     * Set rvItemCompRate
     *
     * @param string $rvItemCompRate
     *
     * @return RvResItemComp
     */
    public function setRvItemCompRate($rvItemCompRate)
    {
        $this->rvItemCompRate = $rvItemCompRate;

        return $this;
    }

    /**
     * Get rvItemCompRate
     *
     * @return string
     */
    public function getRvItemCompRate()
    {
        return $this->rvItemCompRate;
    }

    /**
     * Set rvItemCompRateComm
     *
     * @param string $rvItemCompRateComm
     *
     * @return RvResItemComp
     */
    public function setRvItemCompRateComm($rvItemCompRateComm)
    {
        $this->rvItemCompRateComm = $rvItemCompRateComm;

        return $this;
    }

    /**
     * Get rvItemCompRateComm
     *
     * @return string
     */
    public function getRvItemCompRateComm()
    {
        return $this->rvItemCompRateComm;
    }

    /**
     * Set rvItemCompTaxPerc
     *
     * @param string $rvItemCompTaxPerc
     *
     * @return RvResItemComp
     */
    public function setRvItemCompTaxPerc($rvItemCompTaxPerc)
    {
        $this->rvItemCompTaxPerc = $rvItemCompTaxPerc;

        return $this;
    }

    /**
     * Get rvItemCompTaxPerc
     *
     * @return string
     */
    public function getRvItemCompTaxPerc()
    {
        return $this->rvItemCompTaxPerc;
    }

    /**
     * Set rvItemCompVar
     *
     * @param string $rvItemCompVar
     *
     * @return RvResItemComp
     */
    public function setRvItemCompVar($rvItemCompVar)
    {
        $this->rvItemCompVar = $rvItemCompVar;

        return $this;
    }

    /**
     * Get rvItemCompVar
     *
     * @return string
     */
    public function getRvItemCompVar()
    {
        return $this->rvItemCompVar;
    }

    /**
     * Set rvItemCompFreqInd
     *
     * @param boolean $rvItemCompFreqInd
     *
     * @return RvResItemComp
     */
    public function setRvItemCompFreqInd($rvItemCompFreqInd)
    {
        $this->rvItemCompFreqInd = $rvItemCompFreqInd;

        return $this;
    }

    /**
     * Get rvItemCompFreqInd
     *
     * @return boolean
     */
    public function getRvItemCompFreqInd()
    {
        return $this->rvItemCompFreqInd;
    }

    /**
     * Set rvItemCompFreqFactor
     *
     * @param boolean $rvItemCompFreqFactor
     *
     * @return RvResItemComp
     */
    public function setRvItemCompFreqFactor($rvItemCompFreqFactor)
    {
        $this->rvItemCompFreqFactor = $rvItemCompFreqFactor;

        return $this;
    }

    /**
     * Get rvItemCompFreqFactor
     *
     * @return boolean
     */
    public function getRvItemCompFreqFactor()
    {
        return $this->rvItemCompFreqFactor;
    }

    /**
     * Set rvItemCompEditYn
     *
     * @param boolean $rvItemCompEditYn
     *
     * @return RvResItemComp
     */
    public function setRvItemCompEditYn($rvItemCompEditYn)
    {
        $this->rvItemCompEditYn = $rvItemCompEditYn;

        return $this;
    }

    /**
     * Get rvItemCompEditYn
     *
     * @return boolean
     */
    public function getRvItemCompEditYn()
    {
        return $this->rvItemCompEditYn;
    }

    /**
     * Set rvItemCompOptionYn
     *
     * @param boolean $rvItemCompOptionYn
     *
     * @return RvResItemComp
     */
    public function setRvItemCompOptionYn($rvItemCompOptionYn)
    {
        $this->rvItemCompOptionYn = $rvItemCompOptionYn;

        return $this;
    }

    /**
     * Get rvItemCompOptionYn
     *
     * @return boolean
     */
    public function getRvItemCompOptionYn()
    {
        return $this->rvItemCompOptionYn;
    }

    /**
     * Set rvItemCompSeparateYn
     *
     * @param boolean $rvItemCompSeparateYn
     *
     * @return RvResItemComp
     */
    public function setRvItemCompSeparateYn($rvItemCompSeparateYn)
    {
        $this->rvItemCompSeparateYn = $rvItemCompSeparateYn;

        return $this;
    }

    /**
     * Get rvItemCompSeparateYn
     *
     * @return boolean
     */
    public function getRvItemCompSeparateYn()
    {
        return $this->rvItemCompSeparateYn;
    }

    /**
     * Set rtComponentId
     *
     * @param string $rtComponentId
     *
     * @return RvResItemComp
     */
    public function setRtComponentId($rtComponentId)
    {
        $this->rtComponentId = $rtComponentId;

        return $this;
    }

    /**
     * Get rtComponentId
     *
     * @return string
     */
    public function getRtComponentId()
    {
        return $this->rtComponentId;
    }

    /**
     * Set rtTaxInd
     *
     * @param boolean $rtTaxInd
     *
     * @return RvResItemComp
     */
    public function setRtTaxInd($rtTaxInd)
    {
        $this->rtTaxInd = $rtTaxInd;

        return $this;
    }

    /**
     * Get rtTaxInd
     *
     * @return boolean
     */
    public function getRtTaxInd()
    {
        return $this->rtTaxInd;
    }

    /**
     * Set rtTaxId
     *
     * @param string $rtTaxId
     *
     * @return RvResItemComp
     */
    public function setRtTaxId($rtTaxId)
    {
        $this->rtTaxId = $rtTaxId;

        return $this;
    }

    /**
     * Get rtTaxId
     *
     * @return string
     */
    public function getRtTaxId()
    {
        return $this->rtTaxId;
    }

    /**
     * Set fnInvoiceItemId
     *
     * @param string $fnInvoiceItemId
     *
     * @return RvResItemComp
     */
    public function setFnInvoiceItemId($fnInvoiceItemId)
    {
        $this->fnInvoiceItemId = $fnInvoiceItemId;

        return $this;
    }

    /**
     * Get fnInvoiceItemId
     *
     * @return string
     */
    public function getFnInvoiceItemId()
    {
        return $this->fnInvoiceItemId;
    }

    /**
     * Set rvReservationItemId
     *
     * @param string $rvReservationItemId
     *
     * @return RvResItemComp
     */
    public function setRvReservationItemId($rvReservationItemId)
    {
        $this->rvReservationItemId = $rvReservationItemId;

        return $this;
    }

    /**
     * Get rvReservationItemId
     *
     * @return string
     */
    public function getRvReservationItemId()
    {
        return $this->rvReservationItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvResItemComp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvResItemCompTrfYn
     *
     * @param boolean $rvResItemCompTrfYn
     *
     * @return RvResItemComp
     */
    public function setRvResItemCompTrfYn($rvResItemCompTrfYn)
    {
        $this->rvResItemCompTrfYn = $rvResItemCompTrfYn;

        return $this;
    }

    /**
     * Get rvResItemCompTrfYn
     *
     * @return boolean
     */
    public function getRvResItemCompTrfYn()
    {
        return $this->rvResItemCompTrfYn;
    }
}
