<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvResItemCompTax
 *
 * @ORM\Table(name="rv_res_item_comp_tax", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_tax_rate_id", columns={"rf_tax_rate_id"}), @ORM\Index(name="rv_res_item_comp_id", columns={"rv_res_item_comp_id"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_res_item_comp_tax_trf_yn", columns={"rv_res_item_comp_tax_trf_yn"})})
 * @ORM\Entity
 */
class RvResItemCompTax
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_tax_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvResItemCompTaxIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_tax_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvResItemCompTaxDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_comp_tax_id", type="integer", nullable=false)
     */
    private $rvResItemCompTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_tax_amt", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvResItemCompTaxAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_tax_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvResItemCompTaxPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_comp_id", type="string", length=36, nullable=true)
     */
    private $rvResItemCompId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_res_item_comp_tax_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvResItemCompTaxTrfYn;



    /**
     * Get rvResItemCompTaxIx
     *
     * @return string
     */
    public function getRvResItemCompTaxIx()
    {
        return $this->rvResItemCompTaxIx;
    }

    /**
     * Set rvResItemCompTaxDb
     *
     * @param string $rvResItemCompTaxDb
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompTaxDb($rvResItemCompTaxDb)
    {
        $this->rvResItemCompTaxDb = $rvResItemCompTaxDb;

        return $this;
    }

    /**
     * Get rvResItemCompTaxDb
     *
     * @return string
     */
    public function getRvResItemCompTaxDb()
    {
        return $this->rvResItemCompTaxDb;
    }

    /**
     * Set rvResItemCompTaxId
     *
     * @param integer $rvResItemCompTaxId
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompTaxId($rvResItemCompTaxId)
    {
        $this->rvResItemCompTaxId = $rvResItemCompTaxId;

        return $this;
    }

    /**
     * Get rvResItemCompTaxId
     *
     * @return integer
     */
    public function getRvResItemCompTaxId()
    {
        return $this->rvResItemCompTaxId;
    }

    /**
     * Set rvResItemCompTaxAmt
     *
     * @param string $rvResItemCompTaxAmt
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompTaxAmt($rvResItemCompTaxAmt)
    {
        $this->rvResItemCompTaxAmt = $rvResItemCompTaxAmt;

        return $this;
    }

    /**
     * Get rvResItemCompTaxAmt
     *
     * @return string
     */
    public function getRvResItemCompTaxAmt()
    {
        return $this->rvResItemCompTaxAmt;
    }

    /**
     * Set rvResItemCompTaxPerc
     *
     * @param string $rvResItemCompTaxPerc
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompTaxPerc($rvResItemCompTaxPerc)
    {
        $this->rvResItemCompTaxPerc = $rvResItemCompTaxPerc;

        return $this;
    }

    /**
     * Get rvResItemCompTaxPerc
     *
     * @return string
     */
    public function getRvResItemCompTaxPerc()
    {
        return $this->rvResItemCompTaxPerc;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return RvResItemCompTax
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set rvResItemCompId
     *
     * @param string $rvResItemCompId
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompId($rvResItemCompId)
    {
        $this->rvResItemCompId = $rvResItemCompId;

        return $this;
    }

    /**
     * Get rvResItemCompId
     *
     * @return string
     */
    public function getRvResItemCompId()
    {
        return $this->rvResItemCompId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvResItemCompTax
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvResItemCompTaxTrfYn
     *
     * @param boolean $rvResItemCompTaxTrfYn
     *
     * @return RvResItemCompTax
     */
    public function setRvResItemCompTaxTrfYn($rvResItemCompTaxTrfYn)
    {
        $this->rvResItemCompTaxTrfYn = $rvResItemCompTaxTrfYn;

        return $this;
    }

    /**
     * Get rvResItemCompTaxTrfYn
     *
     * @return boolean
     */
    public function getRvResItemCompTaxTrfYn()
    {
        return $this->rvResItemCompTaxTrfYn;
    }
}
