<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvResItemGroup
 *
 * @ORM\Table(name="rv_res_item_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_item_id", columns={"rv_reservation_item_id"}), @ORM\Index(name="ac_accomm_room_id", columns={"ac_accomm_room_id"}), @ORM\Index(name="rv_res_item_group_trf_yn", columns={"rv_res_item_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvResItemGroup
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvResItemGroupIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvResItemGroupDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_group_id", type="integer", nullable=false)
     */
    private $rvResItemGroupId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_grp_date_allocated", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvGrpDateAllocated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_grp_status_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvGrpStatusTime;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_grp_status_time_tz", type="string", length=40, nullable=false)
     */
    private $rvGrpStatusTimeTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_grp_status_ind", type="boolean", nullable=false, options={"default"="2"})
     */
    private $rvGrpStatusInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_grp_accomm_overide_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvGrpAccommOverideYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_id", type="string", length=36, nullable=true)
     */
    private $rvReservationItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_id", type="string", length=36, nullable=true)
     */
    private $acAccommRoomId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_room_requested_yn", type="boolean", nullable=true)
     */
    private $rvRoomRequestedYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_room_request_reason", type="string", length=255, nullable=true)
     */
    private $rvRoomRequestReason;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_res_item_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvResItemGroupTrfYn;



    /**
     * Get rvResItemGroupIx
     *
     * @return string
     */
    public function getRvResItemGroupIx()
    {
        return $this->rvResItemGroupIx;
    }

    /**
     * Set rvResItemGroupDb
     *
     * @param string $rvResItemGroupDb
     *
     * @return RvResItemGroup
     */
    public function setRvResItemGroupDb($rvResItemGroupDb)
    {
        $this->rvResItemGroupDb = $rvResItemGroupDb;

        return $this;
    }

    /**
     * Get rvResItemGroupDb
     *
     * @return string
     */
    public function getRvResItemGroupDb()
    {
        return $this->rvResItemGroupDb;
    }

    /**
     * Set rvResItemGroupId
     *
     * @param integer $rvResItemGroupId
     *
     * @return RvResItemGroup
     */
    public function setRvResItemGroupId($rvResItemGroupId)
    {
        $this->rvResItemGroupId = $rvResItemGroupId;

        return $this;
    }

    /**
     * Get rvResItemGroupId
     *
     * @return integer
     */
    public function getRvResItemGroupId()
    {
        return $this->rvResItemGroupId;
    }

    /**
     * Set rvGrpDateAllocated
     *
     * @param \DateTime $rvGrpDateAllocated
     *
     * @return RvResItemGroup
     */
    public function setRvGrpDateAllocated($rvGrpDateAllocated)
    {
        $this->rvGrpDateAllocated = $rvGrpDateAllocated;

        return $this;
    }

    /**
     * Get rvGrpDateAllocated
     *
     * @return \DateTime
     */
    public function getRvGrpDateAllocated()
    {
        return $this->rvGrpDateAllocated;
    }

    /**
     * Set rvGrpStatusTime
     *
     * @param \DateTime $rvGrpStatusTime
     *
     * @return RvResItemGroup
     */
    public function setRvGrpStatusTime($rvGrpStatusTime)
    {
        $this->rvGrpStatusTime = $rvGrpStatusTime;

        return $this;
    }

    /**
     * Get rvGrpStatusTime
     *
     * @return \DateTime
     */
    public function getRvGrpStatusTime()
    {
        return $this->rvGrpStatusTime;
    }

    /**
     * Set rvGrpStatusTimeTz
     *
     * @param string $rvGrpStatusTimeTz
     *
     * @return RvResItemGroup
     */
    public function setRvGrpStatusTimeTz($rvGrpStatusTimeTz)
    {
        $this->rvGrpStatusTimeTz = $rvGrpStatusTimeTz;

        return $this;
    }

    /**
     * Get rvGrpStatusTimeTz
     *
     * @return string
     */
    public function getRvGrpStatusTimeTz()
    {
        return $this->rvGrpStatusTimeTz;
    }

    /**
     * Set rvGrpStatusInd
     *
     * @param boolean $rvGrpStatusInd
     *
     * @return RvResItemGroup
     */
    public function setRvGrpStatusInd($rvGrpStatusInd)
    {
        $this->rvGrpStatusInd = $rvGrpStatusInd;

        return $this;
    }

    /**
     * Get rvGrpStatusInd
     *
     * @return boolean
     */
    public function getRvGrpStatusInd()
    {
        return $this->rvGrpStatusInd;
    }

    /**
     * Set rvGrpAccommOverideYn
     *
     * @param boolean $rvGrpAccommOverideYn
     *
     * @return RvResItemGroup
     */
    public function setRvGrpAccommOverideYn($rvGrpAccommOverideYn)
    {
        $this->rvGrpAccommOverideYn = $rvGrpAccommOverideYn;

        return $this;
    }

    /**
     * Get rvGrpAccommOverideYn
     *
     * @return boolean
     */
    public function getRvGrpAccommOverideYn()
    {
        return $this->rvGrpAccommOverideYn;
    }

    /**
     * Set rvReservationItemId
     *
     * @param string $rvReservationItemId
     *
     * @return RvResItemGroup
     */
    public function setRvReservationItemId($rvReservationItemId)
    {
        $this->rvReservationItemId = $rvReservationItemId;

        return $this;
    }

    /**
     * Get rvReservationItemId
     *
     * @return string
     */
    public function getRvReservationItemId()
    {
        return $this->rvReservationItemId;
    }

    /**
     * Set acAccommRoomId
     *
     * @param string $acAccommRoomId
     *
     * @return RvResItemGroup
     */
    public function setAcAccommRoomId($acAccommRoomId)
    {
        $this->acAccommRoomId = $acAccommRoomId;

        return $this;
    }

    /**
     * Get acAccommRoomId
     *
     * @return string
     */
    public function getAcAccommRoomId()
    {
        return $this->acAccommRoomId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return RvResItemGroup
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set rvRoomRequestedYn
     *
     * @param boolean $rvRoomRequestedYn
     *
     * @return RvResItemGroup
     */
    public function setRvRoomRequestedYn($rvRoomRequestedYn)
    {
        $this->rvRoomRequestedYn = $rvRoomRequestedYn;

        return $this;
    }

    /**
     * Get rvRoomRequestedYn
     *
     * @return boolean
     */
    public function getRvRoomRequestedYn()
    {
        return $this->rvRoomRequestedYn;
    }

    /**
     * Set rvRoomRequestReason
     *
     * @param string $rvRoomRequestReason
     *
     * @return RvResItemGroup
     */
    public function setRvRoomRequestReason($rvRoomRequestReason)
    {
        $this->rvRoomRequestReason = $rvRoomRequestReason;

        return $this;
    }

    /**
     * Get rvRoomRequestReason
     *
     * @return string
     */
    public function getRvRoomRequestReason()
    {
        return $this->rvRoomRequestReason;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvResItemGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvResItemGroupTrfYn
     *
     * @param boolean $rvResItemGroupTrfYn
     *
     * @return RvResItemGroup
     */
    public function setRvResItemGroupTrfYn($rvResItemGroupTrfYn)
    {
        $this->rvResItemGroupTrfYn = $rvResItemGroupTrfYn;

        return $this;
    }

    /**
     * Get rvResItemGroupTrfYn
     *
     * @return boolean
     */
    public function getRvResItemGroupTrfYn()
    {
        return $this->rvResItemGroupTrfYn;
    }
}
