<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvResItemGuest
 *
 * @ORM\Table(name="rv_res_item_guest", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_res_item_guest_trf_yn", columns={"rv_res_item_guest_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_item_id", columns={"rv_reservation_item_id"}), @ORM\Index(name="pr_guest_id", columns={"pr_guest_id"})})
 * @ORM\Entity
 */
class RvResItemGuest
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_guest_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvResItemGuestIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_guest_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvResItemGuestDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_guest_id", type="integer", nullable=false)
     */
    private $rvResItemGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=true)
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_id", type="string", length=36, nullable=true)
     */
    private $rvResItemGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_id", type="string", length=36, nullable=true)
     */
    private $rvReservationItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_res_item_guest_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvResItemGuestTrfYn;



    /**
     * Get rvResItemGuestIx
     *
     * @return string
     */
    public function getRvResItemGuestIx()
    {
        return $this->rvResItemGuestIx;
    }

    /**
     * Set rvResItemGuestDb
     *
     * @param string $rvResItemGuestDb
     *
     * @return RvResItemGuest
     */
    public function setRvResItemGuestDb($rvResItemGuestDb)
    {
        $this->rvResItemGuestDb = $rvResItemGuestDb;

        return $this;
    }

    /**
     * Get rvResItemGuestDb
     *
     * @return string
     */
    public function getRvResItemGuestDb()
    {
        return $this->rvResItemGuestDb;
    }

    /**
     * Set rvResItemGuestId
     *
     * @param integer $rvResItemGuestId
     *
     * @return RvResItemGuest
     */
    public function setRvResItemGuestId($rvResItemGuestId)
    {
        $this->rvResItemGuestId = $rvResItemGuestId;

        return $this;
    }

    /**
     * Get rvResItemGuestId
     *
     * @return integer
     */
    public function getRvResItemGuestId()
    {
        return $this->rvResItemGuestId;
    }

    /**
     * Set prGuestId
     *
     * @param string $prGuestId
     *
     * @return RvResItemGuest
     */
    public function setPrGuestId($prGuestId)
    {
        $this->prGuestId = $prGuestId;

        return $this;
    }

    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set rvResItemGroupId
     *
     * @param string $rvResItemGroupId
     *
     * @return RvResItemGuest
     */
    public function setRvResItemGroupId($rvResItemGroupId)
    {
        $this->rvResItemGroupId = $rvResItemGroupId;

        return $this;
    }

    /**
     * Get rvResItemGroupId
     *
     * @return string
     */
    public function getRvResItemGroupId()
    {
        return $this->rvResItemGroupId;
    }

    /**
     * Set rvReservationItemId
     *
     * @param string $rvReservationItemId
     *
     * @return RvResItemGuest
     */
    public function setRvReservationItemId($rvReservationItemId)
    {
        $this->rvReservationItemId = $rvReservationItemId;

        return $this;
    }

    /**
     * Get rvReservationItemId
     *
     * @return string
     */
    public function getRvReservationItemId()
    {
        return $this->rvReservationItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvResItemGuest
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvResItemGuestTrfYn
     *
     * @param boolean $rvResItemGuestTrfYn
     *
     * @return RvResItemGuest
     */
    public function setRvResItemGuestTrfYn($rvResItemGuestTrfYn)
    {
        $this->rvResItemGuestTrfYn = $rvResItemGuestTrfYn;

        return $this;
    }

    /**
     * Get rvResItemGuestTrfYn
     *
     * @return boolean
     */
    public function getRvResItemGuestTrfYn()
    {
        return $this->rvResItemGuestTrfYn;
    }
}
