<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvResItemRateGrp
 *
 * @ORM\Table(name="rv_res_item_rate_grp", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_res_item_rate_grp_trf_yn", columns={"rv_res_item_rate_grp_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rt_rate_group_id", columns={"rt_rate_group_id"}), @ORM\Index(name="rv_reservation_item_id", columns={"rv_reservation_item_id"})})
 * @ORM\Entity
 */
class RvResItemRateGrp
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_rate_grp_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvResItemRateGrpIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_rate_grp_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvResItemRateGrpDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_rate_grp_id", type="integer", nullable=false)
     */
    private $rvResItemRateGrpId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_res_item_rate_grp_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvResItemRateGrpCount;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_rate_grp_overide_amt", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvResItemRateGrpOverideAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_id", type="string", length=36, nullable=true)
     */
    private $rvReservationItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_res_item_rate_grp_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvResItemRateGrpTrfYn;



    /**
     * Get rvResItemRateGrpIx
     *
     * @return string
     */
    public function getRvResItemRateGrpIx()
    {
        return $this->rvResItemRateGrpIx;
    }

    /**
     * Set rvResItemRateGrpDb
     *
     * @param string $rvResItemRateGrpDb
     *
     * @return RvResItemRateGrp
     */
    public function setRvResItemRateGrpDb($rvResItemRateGrpDb)
    {
        $this->rvResItemRateGrpDb = $rvResItemRateGrpDb;

        return $this;
    }

    /**
     * Get rvResItemRateGrpDb
     *
     * @return string
     */
    public function getRvResItemRateGrpDb()
    {
        return $this->rvResItemRateGrpDb;
    }

    /**
     * Set rvResItemRateGrpId
     *
     * @param integer $rvResItemRateGrpId
     *
     * @return RvResItemRateGrp
     */
    public function setRvResItemRateGrpId($rvResItemRateGrpId)
    {
        $this->rvResItemRateGrpId = $rvResItemRateGrpId;

        return $this;
    }

    /**
     * Get rvResItemRateGrpId
     *
     * @return integer
     */
    public function getRvResItemRateGrpId()
    {
        return $this->rvResItemRateGrpId;
    }

    /**
     * Set rvResItemRateGrpCount
     *
     * @param integer $rvResItemRateGrpCount
     *
     * @return RvResItemRateGrp
     */
    public function setRvResItemRateGrpCount($rvResItemRateGrpCount)
    {
        $this->rvResItemRateGrpCount = $rvResItemRateGrpCount;

        return $this;
    }

    /**
     * Get rvResItemRateGrpCount
     *
     * @return integer
     */
    public function getRvResItemRateGrpCount()
    {
        return $this->rvResItemRateGrpCount;
    }

    /**
     * Set rvResItemRateGrpOverideAmt
     *
     * @param string $rvResItemRateGrpOverideAmt
     *
     * @return RvResItemRateGrp
     */
    public function setRvResItemRateGrpOverideAmt($rvResItemRateGrpOverideAmt)
    {
        $this->rvResItemRateGrpOverideAmt = $rvResItemRateGrpOverideAmt;

        return $this;
    }

    /**
     * Get rvResItemRateGrpOverideAmt
     *
     * @return string
     */
    public function getRvResItemRateGrpOverideAmt()
    {
        return $this->rvResItemRateGrpOverideAmt;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return RvResItemRateGrp
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set rvReservationItemId
     *
     * @param string $rvReservationItemId
     *
     * @return RvResItemRateGrp
     */
    public function setRvReservationItemId($rvReservationItemId)
    {
        $this->rvReservationItemId = $rvReservationItemId;

        return $this;
    }

    /**
     * Get rvReservationItemId
     *
     * @return string
     */
    public function getRvReservationItemId()
    {
        return $this->rvReservationItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvResItemRateGrp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvResItemRateGrpTrfYn
     *
     * @param boolean $rvResItemRateGrpTrfYn
     *
     * @return RvResItemRateGrp
     */
    public function setRvResItemRateGrpTrfYn($rvResItemRateGrpTrfYn)
    {
        $this->rvResItemRateGrpTrfYn = $rvResItemRateGrpTrfYn;

        return $this;
    }

    /**
     * Get rvResItemRateGrpTrfYn
     *
     * @return boolean
     */
    public function getRvResItemRateGrpTrfYn()
    {
        return $this->rvResItemRateGrpTrfYn;
    }
}
