<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvReservation
 *
 * @ORM\Table(name="rv_reservation", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_consultant_id", columns={"rv_consultant_id"}), @ORM\Index(name="rv_agent_id", columns={"rv_agent_id"}), @ORM\Index(name="rv_corr_persona_id", columns={"rv_corr_persona_id"}), @ORM\Index(name="rv_date_arrive", columns={"rv_date_arrive"}), @ORM\Index(name="rv_date_depart", columns={"rv_date_depart"}), @ORM\Index(name="rf_reservation_status_id", columns={"rf_reservation_status_id"}), @ORM\Index(name="rv_reservation_trf_yn", columns={"rv_reservation_trf_yn"}), @ORM\Index(name="rv_agent_ref", columns={"rv_agent_ref"}), @ORM\Index(name="rv_res_name", columns={"rv_res_name"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvReservation
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvReservationIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvReservationDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_reservation_id", type="integer", nullable=false)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_action_note", type="string", length=50, nullable=true)
     */
    private $rvActionNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_action_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvActionYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_agent_ref", type="string", length=255, nullable=false, options={"default"=""})
     */
    private $rvAgentRef;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_accomm_comm", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvAmtAccommComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_accomm_gross", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvAmtAccommGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_accomm_nett", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvAmtAccommNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_accomm_payable", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvAmtAccommPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_accomm_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvAmtAccommTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_extra_comm", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtExtraComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_extra_gross", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtExtraGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_extra_nett", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtExtraNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_extra_payable", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtExtraPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_extra_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvAmtExtraTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_paid", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtPaid;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_travel_comm", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtTravelComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_travel_gross", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtTravelGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_travel_nett", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtTravelNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_travel_payable", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtTravelPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_travel_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvAmtTravelTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_amt_sp_discount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvAmtSpDiscount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_alloc_expiry_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvAllocExpiryDate;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_alloc_expiry_days", type="integer", nullable=false, options={"default"="0"})
     */
    private $rvAllocExpiryDays;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_cancel_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvCancelDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_cancel_reason", type="text", length=65535, nullable=true)
     */
    private $rvCancelReason;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_commission_deduct_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvCommissionDeductYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_commission_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvCommissionPerc;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_confirmation_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvConfirmationDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_create_expiry_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"})
     */
    private $rvCreateExpiryDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_arrive", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateArrive;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_changed", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateChanged;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_consultant", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateConsultant;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_deleted", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateDeleted;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_depart", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateDepart;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_proforma", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateProforma;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_quote", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateQuote;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_date_recorded", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvDateRecorded;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_exchg_expiry_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvExchgExpiryDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_exchg_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="1.000000"})
     */
    private $rvExchgRate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_folio_level_ind", type="boolean", nullable=false, options={"default"="3"})
     */
    private $rvFolioLevelInd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_invoice_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvInvoiceDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_conf", type="text", length=65535, nullable=true)
     */
    private $rvNoteConf;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_general", type="text", length=65535, nullable=true)
     */
    private $rvNoteGeneral;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_guests", type="text", length=65535, nullable=true)
     */
    private $rvNoteGuests;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_internal", type="text", length=65535, nullable=true)
     */
    private $rvNoteInternal;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_pax_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvPaxCount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_prov_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvProvDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_provision_expiry_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvProvisionExpiryDate;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_ref_num", type="integer", nullable=false, options={"default"="0"})
     */
    private $rvRefNum;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_name", type="string", length=50, nullable=true)
     */
    private $rvResName;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_reservation_type_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvReservationTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_tba_extra_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvTbaExtraYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_tba_travel_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvTbaTravelYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_wait_list_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"})
     */
    private $rvWaitListDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_id", type="string", length=36, nullable=true)
     */
    private $acPayPlanId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_id", type="string", length=36, nullable=true)
     */
    private $rfCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rtRateTypeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_reservation_status_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfReservationStatusId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_confirmation_id", type="string", length=36, nullable=true)
     */
    private $rfConfirmationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_ix", type="string", length=36, nullable=true)
     */
    private $rfSourceIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_agent_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvAgentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_billing_persona_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvBillingPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_cancel_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvCancelUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_confirmation_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvConfirmationUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_consultant_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvConsultantId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_corr_persona_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvCorrPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_invoice_currency_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvInvoiceCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_invoice_persona_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvInvoicePersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_note_business_id", type="string", length=36, nullable=true)
     */
    private $rvNoteBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_origin_agent_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvOriginAgentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_wait_list_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvWaitListUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_wetu_id", type="string", length=40, nullable=true)
     */
    private $rvWetuId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_wetu_timestamp", type="datetime", nullable=true, options={"default"=null}, columnDefinition="timestamp NULL DEFAULT NULL")

     */
    private $rvWetuTimestamp;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_reservation_timestamp", type="datetime", columnDefinition="timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")

     */
    private $rvReservationTimestamp;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_reservation_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prReservationUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_period_id", type="string", length=36, nullable=true)
     */
    private $blBlockPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_id", type="string", length=36, nullable=true)
     */
    private $acPosId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_deleted_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvDeletedYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_mod_request_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvModRequestYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_mod_request_date", type="datetime", nullable=true)
     */
    private $rvModRequestDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_mod_request_ack_date", type="datetime", nullable=true)
     */
    private $rvModRequestAckDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_mod_request_ack_id", type="string", length=36, nullable=true)
     */
    private $rvModRequestAckId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_mod_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvModYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_mod_date", type="datetime", nullable=true)
     */
    private $rvModDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_mod_ack_date", type="datetime", nullable=true)
     */
    private $rvModAckDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_mod_ack_id", type="string", length=36, nullable=true)
     */
    private $rvModAckId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_reservation_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvReservationTrfYn;



    /**
     * Get rvReservationIx
     *
     * @return string
     */
    public function getRvReservationIx()
    {
        return $this->rvReservationIx;
    }

    /**
     * Set rvReservationDb
     *
     * @param string $rvReservationDb
     *
     * @return RvReservation
     */
    public function setRvReservationDb($rvReservationDb)
    {
        $this->rvReservationDb = $rvReservationDb;

        return $this;
    }

    /**
     * Get rvReservationDb
     *
     * @return string
     */
    public function getRvReservationDb()
    {
        return $this->rvReservationDb;
    }

    /**
     * Set rvReservationId
     *
     * @param integer $rvReservationId
     *
     * @return RvReservation
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return integer
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvActionNote
     *
     * @param string $rvActionNote
     *
     * @return RvReservation
     */
    public function setRvActionNote($rvActionNote)
    {
        $this->rvActionNote = $rvActionNote;

        return $this;
    }

    /**
     * Get rvActionNote
     *
     * @return string
     */
    public function getRvActionNote()
    {
        return $this->rvActionNote;
    }

    /**
     * Set rvActionYn
     *
     * @param boolean $rvActionYn
     *
     * @return RvReservation
     */
    public function setRvActionYn($rvActionYn)
    {
        $this->rvActionYn = $rvActionYn;

        return $this;
    }

    /**
     * Get rvActionYn
     *
     * @return boolean
     */
    public function getRvActionYn()
    {
        return $this->rvActionYn;
    }

    /**
     * Set rvAgentRef
     *
     * @param string $rvAgentRef
     *
     * @return RvReservation
     */
    public function setRvAgentRef($rvAgentRef)
    {
        $this->rvAgentRef = $rvAgentRef;

        return $this;
    }

    /**
     * Get rvAgentRef
     *
     * @return string
     */
    public function getRvAgentRef()
    {
        return $this->rvAgentRef;
    }

    /**
     * Set rvAmtAccommComm
     *
     * @param string $rvAmtAccommComm
     *
     * @return RvReservation
     */
    public function setRvAmtAccommComm($rvAmtAccommComm)
    {
        $this->rvAmtAccommComm = $rvAmtAccommComm;

        return $this;
    }

    /**
     * Get rvAmtAccommComm
     *
     * @return string
     */
    public function getRvAmtAccommComm()
    {
        return $this->rvAmtAccommComm;
    }

    /**
     * Set rvAmtAccommGross
     *
     * @param string $rvAmtAccommGross
     *
     * @return RvReservation
     */
    public function setRvAmtAccommGross($rvAmtAccommGross)
    {
        $this->rvAmtAccommGross = $rvAmtAccommGross;

        return $this;
    }

    /**
     * Get rvAmtAccommGross
     *
     * @return string
     */
    public function getRvAmtAccommGross()
    {
        return $this->rvAmtAccommGross;
    }

    /**
     * Set rvAmtAccommNett
     *
     * @param string $rvAmtAccommNett
     *
     * @return RvReservation
     */
    public function setRvAmtAccommNett($rvAmtAccommNett)
    {
        $this->rvAmtAccommNett = $rvAmtAccommNett;

        return $this;
    }

    /**
     * Get rvAmtAccommNett
     *
     * @return string
     */
    public function getRvAmtAccommNett()
    {
        return $this->rvAmtAccommNett;
    }

    /**
     * Set rvAmtAccommPayable
     *
     * @param string $rvAmtAccommPayable
     *
     * @return RvReservation
     */
    public function setRvAmtAccommPayable($rvAmtAccommPayable)
    {
        $this->rvAmtAccommPayable = $rvAmtAccommPayable;

        return $this;
    }

    /**
     * Get rvAmtAccommPayable
     *
     * @return string
     */
    public function getRvAmtAccommPayable()
    {
        return $this->rvAmtAccommPayable;
    }

    /**
     * Set rvAmtAccommTax
     *
     * @param string $rvAmtAccommTax
     *
     * @return RvReservation
     */
    public function setRvAmtAccommTax($rvAmtAccommTax)
    {
        $this->rvAmtAccommTax = $rvAmtAccommTax;

        return $this;
    }

    /**
     * Get rvAmtAccommTax
     *
     * @return string
     */
    public function getRvAmtAccommTax()
    {
        return $this->rvAmtAccommTax;
    }

    /**
     * Set rvAmtExtraComm
     *
     * @param string $rvAmtExtraComm
     *
     * @return RvReservation
     */
    public function setRvAmtExtraComm($rvAmtExtraComm)
    {
        $this->rvAmtExtraComm = $rvAmtExtraComm;

        return $this;
    }

    /**
     * Get rvAmtExtraComm
     *
     * @return string
     */
    public function getRvAmtExtraComm()
    {
        return $this->rvAmtExtraComm;
    }

    /**
     * Set rvAmtExtraGross
     *
     * @param string $rvAmtExtraGross
     *
     * @return RvReservation
     */
    public function setRvAmtExtraGross($rvAmtExtraGross)
    {
        $this->rvAmtExtraGross = $rvAmtExtraGross;

        return $this;
    }

    /**
     * Get rvAmtExtraGross
     *
     * @return string
     */
    public function getRvAmtExtraGross()
    {
        return $this->rvAmtExtraGross;
    }

    /**
     * Set rvAmtExtraNett
     *
     * @param string $rvAmtExtraNett
     *
     * @return RvReservation
     */
    public function setRvAmtExtraNett($rvAmtExtraNett)
    {
        $this->rvAmtExtraNett = $rvAmtExtraNett;

        return $this;
    }

    /**
     * Get rvAmtExtraNett
     *
     * @return string
     */
    public function getRvAmtExtraNett()
    {
        return $this->rvAmtExtraNett;
    }

    /**
     * Set rvAmtExtraPayable
     *
     * @param string $rvAmtExtraPayable
     *
     * @return RvReservation
     */
    public function setRvAmtExtraPayable($rvAmtExtraPayable)
    {
        $this->rvAmtExtraPayable = $rvAmtExtraPayable;

        return $this;
    }

    /**
     * Get rvAmtExtraPayable
     *
     * @return string
     */
    public function getRvAmtExtraPayable()
    {
        return $this->rvAmtExtraPayable;
    }

    /**
     * Set rvAmtExtraTax
     *
     * @param string $rvAmtExtraTax
     *
     * @return RvReservation
     */
    public function setRvAmtExtraTax($rvAmtExtraTax)
    {
        $this->rvAmtExtraTax = $rvAmtExtraTax;

        return $this;
    }

    /**
     * Get rvAmtExtraTax
     *
     * @return string
     */
    public function getRvAmtExtraTax()
    {
        return $this->rvAmtExtraTax;
    }

    /**
     * Set rvAmtPaid
     *
     * @param string $rvAmtPaid
     *
     * @return RvReservation
     */
    public function setRvAmtPaid($rvAmtPaid)
    {
        $this->rvAmtPaid = $rvAmtPaid;

        return $this;
    }

    /**
     * Get rvAmtPaid
     *
     * @return string
     */
    public function getRvAmtPaid()
    {
        return $this->rvAmtPaid;
    }

    /**
     * Set rvAmtTravelComm
     *
     * @param string $rvAmtTravelComm
     *
     * @return RvReservation
     */
    public function setRvAmtTravelComm($rvAmtTravelComm)
    {
        $this->rvAmtTravelComm = $rvAmtTravelComm;

        return $this;
    }

    /**
     * Get rvAmtTravelComm
     *
     * @return string
     */
    public function getRvAmtTravelComm()
    {
        return $this->rvAmtTravelComm;
    }

    /**
     * Set rvAmtTravelGross
     *
     * @param string $rvAmtTravelGross
     *
     * @return RvReservation
     */
    public function setRvAmtTravelGross($rvAmtTravelGross)
    {
        $this->rvAmtTravelGross = $rvAmtTravelGross;

        return $this;
    }

    /**
     * Get rvAmtTravelGross
     *
     * @return string
     */
    public function getRvAmtTravelGross()
    {
        return $this->rvAmtTravelGross;
    }

    /**
     * Set rvAmtTravelNett
     *
     * @param string $rvAmtTravelNett
     *
     * @return RvReservation
     */
    public function setRvAmtTravelNett($rvAmtTravelNett)
    {
        $this->rvAmtTravelNett = $rvAmtTravelNett;

        return $this;
    }

    /**
     * Get rvAmtTravelNett
     *
     * @return string
     */
    public function getRvAmtTravelNett()
    {
        return $this->rvAmtTravelNett;
    }

    /**
     * Set rvAmtTravelPayable
     *
     * @param string $rvAmtTravelPayable
     *
     * @return RvReservation
     */
    public function setRvAmtTravelPayable($rvAmtTravelPayable)
    {
        $this->rvAmtTravelPayable = $rvAmtTravelPayable;

        return $this;
    }

    /**
     * Get rvAmtTravelPayable
     *
     * @return string
     */
    public function getRvAmtTravelPayable()
    {
        return $this->rvAmtTravelPayable;
    }

    /**
     * Set rvAmtTravelTax
     *
     * @param string $rvAmtTravelTax
     *
     * @return RvReservation
     */
    public function setRvAmtTravelTax($rvAmtTravelTax)
    {
        $this->rvAmtTravelTax = $rvAmtTravelTax;

        return $this;
    }

    /**
     * Get rvAmtTravelTax
     *
     * @return string
     */
    public function getRvAmtTravelTax()
    {
        return $this->rvAmtTravelTax;
    }

    /**
     * Set rvAmtSpDiscount
     *
     * @param string $rvAmtSpDiscount
     *
     * @return RvReservation
     */
    public function setRvAmtSpDiscount($rvAmtSpDiscount)
    {
        $this->rvAmtSpDiscount = $rvAmtSpDiscount;

        return $this;
    }

    /**
     * Get rvAmtSpDiscount
     *
     * @return string
     */
    public function getRvAmtSpDiscount()
    {
        return $this->rvAmtSpDiscount;
    }

    /**
     * Set rvAllocExpiryDate
     *
     * @param \DateTime $rvAllocExpiryDate
     *
     * @return RvReservation
     */
    public function setRvAllocExpiryDate($rvAllocExpiryDate)
    {
        $this->rvAllocExpiryDate = $rvAllocExpiryDate;

        return $this;
    }

    /**
     * Get rvAllocExpiryDate
     *
     * @return \DateTime
     */
    public function getRvAllocExpiryDate()
    {
        return $this->rvAllocExpiryDate;
    }

    /**
     * Set rvAllocExpiryDays
     *
     * @param integer $rvAllocExpiryDays
     *
     * @return RvReservation
     */
    public function setRvAllocExpiryDays($rvAllocExpiryDays)
    {
        $this->rvAllocExpiryDays = $rvAllocExpiryDays;

        return $this;
    }

    /**
     * Get rvAllocExpiryDays
     *
     * @return integer
     */
    public function getRvAllocExpiryDays()
    {
        return $this->rvAllocExpiryDays;
    }

    /**
     * Set rvCancelDate
     *
     * @param \DateTime $rvCancelDate
     *
     * @return RvReservation
     */
    public function setRvCancelDate($rvCancelDate)
    {
        $this->rvCancelDate = $rvCancelDate;

        return $this;
    }

    /**
     * Get rvCancelDate
     *
     * @return \DateTime
     */
    public function getRvCancelDate()
    {
        return $this->rvCancelDate;
    }

    /**
     * Set rvCancelReason
     *
     * @param string $rvCancelReason
     *
     * @return RvReservation
     */
    public function setRvCancelReason($rvCancelReason)
    {
        $this->rvCancelReason = $rvCancelReason;

        return $this;
    }

    /**
     * Get rvCancelReason
     *
     * @return string
     */
    public function getRvCancelReason()
    {
        return $this->rvCancelReason;
    }

    /**
     * Set rvCommissionDeductYn
     *
     * @param boolean $rvCommissionDeductYn
     *
     * @return RvReservation
     */
    public function setRvCommissionDeductYn($rvCommissionDeductYn)
    {
        $this->rvCommissionDeductYn = $rvCommissionDeductYn;

        return $this;
    }

    /**
     * Get rvCommissionDeductYn
     *
     * @return boolean
     */
    public function getRvCommissionDeductYn()
    {
        return $this->rvCommissionDeductYn;
    }

    /**
     * Set rvCommissionPerc
     *
     * @param string $rvCommissionPerc
     *
     * @return RvReservation
     */
    public function setRvCommissionPerc($rvCommissionPerc)
    {
        $this->rvCommissionPerc = $rvCommissionPerc;

        return $this;
    }

    /**
     * Get rvCommissionPerc
     *
     * @return string
     */
    public function getRvCommissionPerc()
    {
        return $this->rvCommissionPerc;
    }

    /**
     * Set rvConfirmationDate
     *
     * @param \DateTime $rvConfirmationDate
     *
     * @return RvReservation
     */
    public function setRvConfirmationDate($rvConfirmationDate)
    {
        $this->rvConfirmationDate = $rvConfirmationDate;

        return $this;
    }

    /**
     * Get rvConfirmationDate
     *
     * @return \DateTime
     */
    public function getRvConfirmationDate()
    {
        return $this->rvConfirmationDate;
    }

    /**
     * Set rvCreateExpiryDate
     *
     * @param \DateTime $rvCreateExpiryDate
     *
     * @return RvReservation
     */
    public function setRvCreateExpiryDate($rvCreateExpiryDate)
    {
        $this->rvCreateExpiryDate = $rvCreateExpiryDate;

        return $this;
    }

    /**
     * Get rvCreateExpiryDate
     *
     * @return \DateTime
     */
    public function getRvCreateExpiryDate()
    {
        return $this->rvCreateExpiryDate;
    }

    /**
     * Set rvDateArrive
     *
     * @param \DateTime $rvDateArrive
     *
     * @return RvReservation
     */
    public function setRvDateArrive($rvDateArrive)
    {
        $this->rvDateArrive = $rvDateArrive;

        return $this;
    }

    /**
     * Get rvDateArrive
     *
     * @return \DateTime
     */
    public function getRvDateArrive()
    {
        return $this->rvDateArrive;
    }

    /**
     * Set rvDateChanged
     *
     * @param \DateTime $rvDateChanged
     *
     * @return RvReservation
     */
    public function setRvDateChanged($rvDateChanged)
    {
        $this->rvDateChanged = $rvDateChanged;

        return $this;
    }

    /**
     * Get rvDateChanged
     *
     * @return \DateTime
     */
    public function getRvDateChanged()
    {
        return $this->rvDateChanged;
    }

    /**
     * Set rvDateConsultant
     *
     * @param \DateTime $rvDateConsultant
     *
     * @return RvReservation
     */
    public function setRvDateConsultant($rvDateConsultant)
    {
        $this->rvDateConsultant = $rvDateConsultant;

        return $this;
    }

    /**
     * Get rvDateConsultant
     *
     * @return \DateTime
     */
    public function getRvDateConsultant()
    {
        return $this->rvDateConsultant;
    }

    /**
     * Set rvDateDeleted
     *
     * @param \DateTime $rvDateDeleted
     *
     * @return RvReservation
     */
    public function setRvDateDeleted($rvDateDeleted)
    {
        $this->rvDateDeleted = $rvDateDeleted;

        return $this;
    }

    /**
     * Get rvDateDeleted
     *
     * @return \DateTime
     */
    public function getRvDateDeleted()
    {
        return $this->rvDateDeleted;
    }

    /**
     * Set rvDateDepart
     *
     * @param \DateTime $rvDateDepart
     *
     * @return RvReservation
     */
    public function setRvDateDepart($rvDateDepart)
    {
        $this->rvDateDepart = $rvDateDepart;

        return $this;
    }

    /**
     * Get rvDateDepart
     *
     * @return \DateTime
     */
    public function getRvDateDepart()
    {
        return $this->rvDateDepart;
    }

    /**
     * Set rvDateProforma
     *
     * @param \DateTime $rvDateProforma
     *
     * @return RvReservation
     */
    public function setRvDateProforma($rvDateProforma)
    {
        $this->rvDateProforma = $rvDateProforma;

        return $this;
    }

    /**
     * Get rvDateProforma
     *
     * @return \DateTime
     */
    public function getRvDateProforma()
    {
        return $this->rvDateProforma;
    }

    /**
     * Set rvDateQuote
     *
     * @param \DateTime $rvDateQuote
     *
     * @return RvReservation
     */
    public function setRvDateQuote($rvDateQuote)
    {
        $this->rvDateQuote = $rvDateQuote;

        return $this;
    }

    /**
     * Get rvDateQuote
     *
     * @return \DateTime
     */
    public function getRvDateQuote()
    {
        return $this->rvDateQuote;
    }

    /**
     * Set rvDateRecorded
     *
     * @param \DateTime $rvDateRecorded
     *
     * @return RvReservation
     */
    public function setRvDateRecorded($rvDateRecorded)
    {
        $this->rvDateRecorded = $rvDateRecorded;

        return $this;
    }

    /**
     * Get rvDateRecorded
     *
     * @return \DateTime
     */
    public function getRvDateRecorded()
    {
        return $this->rvDateRecorded;
    }

    /**
     * Set rvExchgExpiryDate
     *
     * @param \DateTime $rvExchgExpiryDate
     *
     * @return RvReservation
     */
    public function setRvExchgExpiryDate($rvExchgExpiryDate)
    {
        $this->rvExchgExpiryDate = $rvExchgExpiryDate;

        return $this;
    }

    /**
     * Get rvExchgExpiryDate
     *
     * @return \DateTime
     */
    public function getRvExchgExpiryDate()
    {
        return $this->rvExchgExpiryDate;
    }

    /**
     * Set rvExchgRate
     *
     * @param string $rvExchgRate
     *
     * @return RvReservation
     */
    public function setRvExchgRate($rvExchgRate)
    {
        $this->rvExchgRate = $rvExchgRate;

        return $this;
    }

    /**
     * Get rvExchgRate
     *
     * @return string
     */
    public function getRvExchgRate()
    {
        return $this->rvExchgRate;
    }

    /**
     * Set rvFolioLevelInd
     *
     * @param boolean $rvFolioLevelInd
     *
     * @return RvReservation
     */
    public function setRvFolioLevelInd($rvFolioLevelInd)
    {
        $this->rvFolioLevelInd = $rvFolioLevelInd;

        return $this;
    }

    /**
     * Get rvFolioLevelInd
     *
     * @return boolean
     */
    public function getRvFolioLevelInd()
    {
        return $this->rvFolioLevelInd;
    }

    /**
     * Set rvInvoiceDate
     *
     * @param \DateTime $rvInvoiceDate
     *
     * @return RvReservation
     */
    public function setRvInvoiceDate($rvInvoiceDate)
    {
        $this->rvInvoiceDate = $rvInvoiceDate;

        return $this;
    }

    /**
     * Get rvInvoiceDate
     *
     * @return \DateTime
     */
    public function getRvInvoiceDate()
    {
        return $this->rvInvoiceDate;
    }

    /**
     * Set rvNoteConf
     *
     * @param string $rvNoteConf
     *
     * @return RvReservation
     */
    public function setRvNoteConf($rvNoteConf)
    {
        $this->rvNoteConf = $rvNoteConf;

        return $this;
    }

    /**
     * Get rvNoteConf
     *
     * @return string
     */
    public function getRvNoteConf()
    {
        return $this->rvNoteConf;
    }

    /**
     * Set rvNoteGeneral
     *
     * @param string $rvNoteGeneral
     *
     * @return RvReservation
     */
    public function setRvNoteGeneral($rvNoteGeneral)
    {
        $this->rvNoteGeneral = $rvNoteGeneral;

        return $this;
    }

    /**
     * Get rvNoteGeneral
     *
     * @return string
     */
    public function getRvNoteGeneral()
    {
        return $this->rvNoteGeneral;
    }

    /**
     * Set rvNoteGuests
     *
     * @param string $rvNoteGuests
     *
     * @return RvReservation
     */
    public function setRvNoteGuests($rvNoteGuests)
    {
        $this->rvNoteGuests = $rvNoteGuests;

        return $this;
    }

    /**
     * Get rvNoteGuests
     *
     * @return string
     */
    public function getRvNoteGuests()
    {
        return $this->rvNoteGuests;
    }

    /**
     * Set rvNoteInternal
     *
     * @param string $rvNoteInternal
     *
     * @return RvReservation
     */
    public function setRvNoteInternal($rvNoteInternal)
    {
        $this->rvNoteInternal = $rvNoteInternal;

        return $this;
    }

    /**
     * Get rvNoteInternal
     *
     * @return string
     */
    public function getRvNoteInternal()
    {
        return $this->rvNoteInternal;
    }

    /**
     * Set rvPaxCount
     *
     * @param integer $rvPaxCount
     *
     * @return RvReservation
     */
    public function setRvPaxCount($rvPaxCount)
    {
        $this->rvPaxCount = $rvPaxCount;

        return $this;
    }

    /**
     * Get rvPaxCount
     *
     * @return integer
     */
    public function getRvPaxCount()
    {
        return $this->rvPaxCount;
    }

    /**
     * Set rvProvDate
     *
     * @param \DateTime $rvProvDate
     *
     * @return RvReservation
     */
    public function setRvProvDate($rvProvDate)
    {
        $this->rvProvDate = $rvProvDate;

        return $this;
    }

    /**
     * Get rvProvDate
     *
     * @return \DateTime
     */
    public function getRvProvDate()
    {
        return $this->rvProvDate;
    }

    /**
     * Set rvProvisionExpiryDate
     *
     * @param \DateTime $rvProvisionExpiryDate
     *
     * @return RvReservation
     */
    public function setRvProvisionExpiryDate($rvProvisionExpiryDate)
    {
        $this->rvProvisionExpiryDate = $rvProvisionExpiryDate;

        return $this;
    }

    /**
     * Get rvProvisionExpiryDate
     *
     * @return \DateTime
     */
    public function getRvProvisionExpiryDate()
    {
        return $this->rvProvisionExpiryDate;
    }

    /**
     * Set rvRefNum
     *
     * @param integer $rvRefNum
     *
     * @return RvReservation
     */
    public function setRvRefNum($rvRefNum)
    {
        $this->rvRefNum = $rvRefNum;

        return $this;
    }

    /**
     * Get rvRefNum
     *
     * @return integer
     */
    public function getRvRefNum()
    {
        return $this->rvRefNum;
    }

    /**
     * Set rvResName
     *
     * @param string $rvResName
     *
     * @return RvReservation
     */
    public function setRvResName($rvResName)
    {
        $this->rvResName = $rvResName;

        return $this;
    }

    /**
     * Get rvResName
     *
     * @return string
     */
    public function getRvResName()
    {
        return $this->rvResName;
    }

    /**
     * Set rvReservationTypeInd
     *
     * @param boolean $rvReservationTypeInd
     *
     * @return RvReservation
     */
    public function setRvReservationTypeInd($rvReservationTypeInd)
    {
        $this->rvReservationTypeInd = $rvReservationTypeInd;

        return $this;
    }

    /**
     * Get rvReservationTypeInd
     *
     * @return boolean
     */
    public function getRvReservationTypeInd()
    {
        return $this->rvReservationTypeInd;
    }

    /**
     * Set rvTbaExtraYn
     *
     * @param boolean $rvTbaExtraYn
     *
     * @return RvReservation
     */
    public function setRvTbaExtraYn($rvTbaExtraYn)
    {
        $this->rvTbaExtraYn = $rvTbaExtraYn;

        return $this;
    }

    /**
     * Get rvTbaExtraYn
     *
     * @return boolean
     */
    public function getRvTbaExtraYn()
    {
        return $this->rvTbaExtraYn;
    }

    /**
     * Set rvTbaTravelYn
     *
     * @param boolean $rvTbaTravelYn
     *
     * @return RvReservation
     */
    public function setRvTbaTravelYn($rvTbaTravelYn)
    {
        $this->rvTbaTravelYn = $rvTbaTravelYn;

        return $this;
    }

    /**
     * Get rvTbaTravelYn
     *
     * @return boolean
     */
    public function getRvTbaTravelYn()
    {
        return $this->rvTbaTravelYn;
    }

    /**
     * Set rvWaitListDate
     *
     * @param \DateTime $rvWaitListDate
     *
     * @return RvReservation
     */
    public function setRvWaitListDate($rvWaitListDate)
    {
        $this->rvWaitListDate = $rvWaitListDate;

        return $this;
    }

    /**
     * Get rvWaitListDate
     *
     * @return \DateTime
     */
    public function getRvWaitListDate()
    {
        return $this->rvWaitListDate;
    }

    /**
     * Set acPayPlanId
     *
     * @param string $acPayPlanId
     *
     * @return RvReservation
     */
    public function setAcPayPlanId($acPayPlanId)
    {
        $this->acPayPlanId = $acPayPlanId;

        return $this;
    }

    /**
     * Get acPayPlanId
     *
     * @return string
     */
    public function getAcPayPlanId()
    {
        return $this->acPayPlanId;
    }

    /**
     * Set rfCountryId
     *
     * @param string $rfCountryId
     *
     * @return RvReservation
     */
    public function setRfCountryId($rfCountryId)
    {
        $this->rfCountryId = $rfCountryId;

        return $this;
    }

    /**
     * Get rfCountryId
     *
     * @return string
     */
    public function getRfCountryId()
    {
        return $this->rfCountryId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return RvReservation
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set rfReservationStatusId
     *
     * @param integer $rfReservationStatusId
     *
     * @return RvReservation
     */
    public function setRfReservationStatusId($rfReservationStatusId)
    {
        $this->rfReservationStatusId = $rfReservationStatusId;

        return $this;
    }

    /**
     * Get rfReservationStatusId
     *
     * @return integer
     */
    public function getRfReservationStatusId()
    {
        return $this->rfReservationStatusId;
    }

    /**
     * Set rfConfirmationId
     *
     * @param string $rfConfirmationId
     *
     * @return RvReservation
     */
    public function setRfConfirmationId($rfConfirmationId)
    {
        $this->rfConfirmationId = $rfConfirmationId;

        return $this;
    }

    /**
     * Get rfConfirmationId
     *
     * @return string
     */
    public function getRfConfirmationId()
    {
        return $this->rfConfirmationId;
    }

    /**
     * Set rfSourceIx
     *
     * @param string $rfSourceIx
     *
     * @return RvReservation
     */
    public function setRfSourceIx($rfSourceIx)
    {
        $this->rfSourceIx = $rfSourceIx;

        return $this;
    }

    /**
     * Get rfSourceIx
     *
     * @return string
     */
    public function getRfSourceIx()
    {
        return $this->rfSourceIx;
    }

    /**
     * Set rvAgentId
     *
     * @param string $rvAgentId
     *
     * @return RvReservation
     */
    public function setRvAgentId($rvAgentId)
    {
        $this->rvAgentId = $rvAgentId;

        return $this;
    }

    /**
     * Get rvAgentId
     *
     * @return string
     */
    public function getRvAgentId()
    {
        return $this->rvAgentId;
    }

    /**
     * Set rvBillingPersonaId
     *
     * @param string $rvBillingPersonaId
     *
     * @return RvReservation
     */
    public function setRvBillingPersonaId($rvBillingPersonaId)
    {
        $this->rvBillingPersonaId = $rvBillingPersonaId;

        return $this;
    }

    /**
     * Get rvBillingPersonaId
     *
     * @return string
     */
    public function getRvBillingPersonaId()
    {
        return $this->rvBillingPersonaId;
    }

    /**
     * Set rvCancelUserId
     *
     * @param string $rvCancelUserId
     *
     * @return RvReservation
     */
    public function setRvCancelUserId($rvCancelUserId)
    {
        $this->rvCancelUserId = $rvCancelUserId;

        return $this;
    }

    /**
     * Get rvCancelUserId
     *
     * @return string
     */
    public function getRvCancelUserId()
    {
        return $this->rvCancelUserId;
    }

    /**
     * Set rvConfirmationUserId
     *
     * @param string $rvConfirmationUserId
     *
     * @return RvReservation
     */
    public function setRvConfirmationUserId($rvConfirmationUserId)
    {
        $this->rvConfirmationUserId = $rvConfirmationUserId;

        return $this;
    }

    /**
     * Get rvConfirmationUserId
     *
     * @return string
     */
    public function getRvConfirmationUserId()
    {
        return $this->rvConfirmationUserId;
    }

    /**
     * Set rvConsultantId
     *
     * @param string $rvConsultantId
     *
     * @return RvReservation
     */
    public function setRvConsultantId($rvConsultantId)
    {
        $this->rvConsultantId = $rvConsultantId;

        return $this;
    }

    /**
     * Get rvConsultantId
     *
     * @return string
     */
    public function getRvConsultantId()
    {
        return $this->rvConsultantId;
    }

    /**
     * Set rvCorrPersonaId
     *
     * @param string $rvCorrPersonaId
     *
     * @return RvReservation
     */
    public function setRvCorrPersonaId($rvCorrPersonaId)
    {
        $this->rvCorrPersonaId = $rvCorrPersonaId;

        return $this;
    }

    /**
     * Get rvCorrPersonaId
     *
     * @return string
     */
    public function getRvCorrPersonaId()
    {
        return $this->rvCorrPersonaId;
    }

    /**
     * Set rvInvoiceCurrencyId
     *
     * @param string $rvInvoiceCurrencyId
     *
     * @return RvReservation
     */
    public function setRvInvoiceCurrencyId($rvInvoiceCurrencyId)
    {
        $this->rvInvoiceCurrencyId = $rvInvoiceCurrencyId;

        return $this;
    }

    /**
     * Get rvInvoiceCurrencyId
     *
     * @return string
     */
    public function getRvInvoiceCurrencyId()
    {
        return $this->rvInvoiceCurrencyId;
    }

    /**
     * Set rvInvoicePersonaId
     *
     * @param string $rvInvoicePersonaId
     *
     * @return RvReservation
     */
    public function setRvInvoicePersonaId($rvInvoicePersonaId)
    {
        $this->rvInvoicePersonaId = $rvInvoicePersonaId;

        return $this;
    }

    /**
     * Get rvInvoicePersonaId
     *
     * @return string
     */
    public function getRvInvoicePersonaId()
    {
        return $this->rvInvoicePersonaId;
    }

    /**
     * Set rvNoteBusinessId
     *
     * @param string $rvNoteBusinessId
     *
     * @return RvReservation
     */
    public function setRvNoteBusinessId($rvNoteBusinessId)
    {
        $this->rvNoteBusinessId = $rvNoteBusinessId;

        return $this;
    }

    /**
     * Get rvNoteBusinessId
     *
     * @return string
     */
    public function getRvNoteBusinessId()
    {
        return $this->rvNoteBusinessId;
    }

    /**
     * Set rvOriginAgentId
     *
     * @param string $rvOriginAgentId
     *
     * @return RvReservation
     */
    public function setRvOriginAgentId($rvOriginAgentId)
    {
        $this->rvOriginAgentId = $rvOriginAgentId;

        return $this;
    }

    /**
     * Get rvOriginAgentId
     *
     * @return string
     */
    public function getRvOriginAgentId()
    {
        return $this->rvOriginAgentId;
    }

    /**
     * Set rvWaitListUserId
     *
     * @param string $rvWaitListUserId
     *
     * @return RvReservation
     */
    public function setRvWaitListUserId($rvWaitListUserId)
    {
        $this->rvWaitListUserId = $rvWaitListUserId;

        return $this;
    }

    /**
     * Get rvWaitListUserId
     *
     * @return string
     */
    public function getRvWaitListUserId()
    {
        return $this->rvWaitListUserId;
    }

    /**
     * Set rvReservationTimestamp
     *
     * @param \DateTime $rvReservationTimestamp
     *
     * @return RvReservation
     */
    public function setRvReservationTimestamp($rvReservationTimestamp)
    {
        $this->rvReservationTimestamp = $rvReservationTimestamp;

        return $this;
    }

    /**
     * Get rvReservationTimestamp
     *
     * @return \DateTime
     */
    public function getRvReservationTimestamp()
    {
        return $this->rvReservationTimestamp;
    }

    /**
     * Set prReservationUserId
     *
     * @param string $prReservationUserId
     *
     * @return RvReservation
     */
    public function setPrReservationUserId($prReservationUserId)
    {
        $this->prReservationUserId = $prReservationUserId;

        return $this;
    }

    /**
     * Get prReservationUserId
     *
     * @return string
     */
    public function getPrReservationUserId()
    {
        return $this->prReservationUserId;
    }

    /**
     * Set blBlockPeriodId
     *
     * @param string $blBlockPeriodId
     *
     * @return RvReservation
     */
    public function setBlBlockPeriodId($blBlockPeriodId)
    {
        $this->blBlockPeriodId = $blBlockPeriodId;

        return $this;
    }

    /**
     * Get blBlockPeriodId
     *
     * @return string
     */
    public function getBlBlockPeriodId()
    {
        return $this->blBlockPeriodId;
    }

    /**
     * Set acPosId
     *
     * @param string $acPosId
     *
     * @return RvReservation
     */
    public function setAcPosId($acPosId)
    {
        $this->acPosId = $acPosId;

        return $this;
    }

    /**
     * Get acPosId
     *
     * @return string
     */
    public function getAcPosId()
    {
        return $this->acPosId;
    }

    /**
     * Set rvDeletedYn
     *
     * @param boolean $rvDeletedYn
     *
     * @return RvReservation
     */
    public function setRvDeletedYn($rvDeletedYn)
    {
        $this->rvDeletedYn = $rvDeletedYn;

        return $this;
    }

    /**
     * Get rvDeletedYn
     *
     * @return boolean
     */
    public function getRvDeletedYn()
    {
        return $this->rvDeletedYn;
    }
    
    /**
     * Set rvModRequestYn
     *
     * @param boolean $rvModRequestYn
     *
     * @return RvReservation
     */
    public function setRvModRequestYn($rvModRequestYn)
    {
        $this->rvModRequestYn = $rvModRequestYn;

        return $this;
    }

    /**
     * Get rvModRequestYn
     *
     * @return boolean
     */
    public function getRvModRequestYn()
    {
        return $this->rvModRequestYn;
    }

    /**
     * Set rvModRequestDate
     *
     * @param \DateTime $rvModRequestDate
     *
     * @return RvReservation
     */
    public function setRvModRequestDate($rvModRequestDate)
    {
        $this->rvModRequestDate = $rvModRequestDate;

        return $this;
    }

    /**
     * Get rvModRequestDate
     *
     * @return \DateTime
     */
    public function getRvModRequestDate()
    {
        return $this->rvModRequestDate;
    }
    
    /**
     * Set rvModRequestAckDate
     *
     * @param \DateTime $rvModRequestAckDate
     *
     * @return RvReservation
     */
    public function setRvModRequestAckDate($rvModRequestAckDate)
    {
        $this->rvModRequestAckDate = $rvModRequestAckDate;

        return $this;
    }

    /**
     * Get rvModRequestDate
     *
     * @return \DateTime
     */
    public function getRvModRequestAckDate()
    {
        return $this->rvModRequestAckDate;
    }

    /**
     * Set rvModRequestAckId
     *
     * @param string $rvModRequestAckId
     *
     * @return RvReservation
     */
    public function setRvModRequestAckId($rvModRequestAckId)
    {
        $this->rvModRequestAckId = $rvModRequestAckId;

        return $this;
    }

    /**
     * Get rvModRequestAckId
     *
     * @return string
     */
    public function getRvModRequestAckId()
    {
        return $this->rvModRequestAckId;
    }

    /**
     * Set rvModYn
     *
     * @param boolean $rvModYn
     *
     * @return RvReservation
     */
    public function setRvModYn($rvModYn)
    {
        $this->rvModYn = $rvModYn;

        return $this;
    }

    /**
     * Get rvModYn
     *
     * @return boolean
     */
    public function getRvModYn()
    {
        return $this->rvModYn;
    }

    /**
     * Set rvModDate
     *
     * @param \DateTime $rvModDate
     *
     * @return RvReservation
     */
    public function setRvModDate($rvModDate)
    {
        $this->rvModDate = $rvModDate;

        return $this;
    }

    /**
     * Get rvModDate
     *
     * @return \DateTime
     */
    public function getRvModDate()
    {
        return $this->rvModDate;
    }
    
    /**
     * Set rvModAckDate
     *
     * @param \DateTime $rvModAckDate
     *
     * @return RvReservation
     */
    public function setRvModAckDate($rvModAckDate)
    {
        $this->rvModAckDate = $rvModAckDate;

        return $this;
    }

    /**
     * Get rvModAckDate
     *
     * @return \DateTime
     */
    public function getRvModAckDate()
    {
        return $this->rvModAckDate;
    }

    /**
     * Set rvModAckId
     *
     * @param string $rvModAckId
     *
     * @return RvReservation
     */
    public function setRvModAckId($rvModAckId)
    {
        $this->rvModAckId = $rvModAckId;

        return $this;
    }

    /**
     * Get rvModAckId
     *
     * @return string
     */
    public function getRvModAckId()
    {
        return $this->rvModAckId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvReservation
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvReservationTrfYn
     *
     * @param boolean $rvReservationTrfYn
     *
     * @return RvReservation
     */
    public function setRvReservationTrfYn($rvReservationTrfYn)
    {
        $this->rvReservationTrfYn = $rvReservationTrfYn;

        return $this;
    }

    /**
     * Get rvReservationTrfYn
     *
     * @return boolean
     */
    public function getRvReservationTrfYn()
    {
        return $this->rvReservationTrfYn;
    }
}
