<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvReservationGuest
 *
 * @ORM\Table(name="rv_reservation_guest", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_guest_trf_yn", columns={"rv_reservation_guest_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rv_reservation_id", columns={"rv_reservation_id", "pr_guest_id"})})
 * @ORM\Entity
 */
class RvReservationGuest
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_guest_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvReservationGuestIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_guest_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvReservationGuestDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_reservation_guest_id", type="integer", nullable=true)
     */
    private $rvReservationGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=true)
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_reservation_guest_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvReservationGuestTrfYn;



    /**
     * Get rvReservationGuestIx
     *
     * @return string
     */
    public function getRvReservationGuestIx()
    {
        return $this->rvReservationGuestIx;
    }

    /**
     * Set rvReservationGuestDb
     *
     * @param string $rvReservationGuestDb
     *
     * @return RvReservationGuest
     */
    public function setRvReservationGuestDb($rvReservationGuestDb)
    {
        $this->rvReservationGuestDb = $rvReservationGuestDb;

        return $this;
    }

    /**
     * Get rvReservationGuestDb
     *
     * @return string
     */
    public function getRvReservationGuestDb()
    {
        return $this->rvReservationGuestDb;
    }

    /**
     * Set rvReservationGuestId
     *
     * @param integer $rvReservationGuestId
     *
     * @return RvReservationGuest
     */
    public function setRvReservationGuestId($rvReservationGuestId)
    {
        $this->rvReservationGuestId = $rvReservationGuestId;

        return $this;
    }

    /**
     * Get rvReservationGuestId
     *
     * @return integer
     */
    public function getRvReservationGuestId()
    {
        return $this->rvReservationGuestId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvReservationGuest
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set prGuestId
     *
     * @param string $prGuestId
     *
     * @return RvReservationGuest
     */
    public function setPrGuestId($prGuestId)
    {
        $this->prGuestId = $prGuestId;

        return $this;
    }

    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvReservationGuest
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvReservationGuestTrfYn
     *
     * @param boolean $rvReservationGuestTrfYn
     *
     * @return RvReservationGuest
     */
    public function setRvReservationGuestTrfYn($rvReservationGuestTrfYn)
    {
        $this->rvReservationGuestTrfYn = $rvReservationGuestTrfYn;

        return $this;
    }

    /**
     * Get rvReservationGuestTrfYn
     *
     * @return boolean
     */
    public function getRvReservationGuestTrfYn()
    {
        return $this->rvReservationGuestTrfYn;
    }
}
