<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvReservationItem
 *
 * @ORM\Table(name="rv_reservation_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="ac_accomm_type_id", columns={"ac_accomm_type_id"}), @ORM\Index(name="rv_reservation_item_trf_yn", columns={"rv_reservation_item_trf_yn"}), @ORM\Index(name="fn_folio_id", columns={"fn_folio_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="rv_item_date_arrive", columns={"rv_item_date_arrive"}),@ORM\Index(name="rv_item_date_depart", columns={"rv_item_date_depart"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvReservationItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvReservationItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_item_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rvReservationItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_reservation_item_id", type="integer", nullable=false)
     */
    private $rvReservationItemId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_item_accomm_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvItemAccommCount;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_comm", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_gross", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemAmtGross;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_nett", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemAmtNett;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_payable", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemAmtPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $rvItemAmtTax;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_amt_sp_discount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemAmtSpDiscount;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_overide_level_ind", type="boolean", nullable=true)
     */
    private $rvItemOverideLevelInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_overide_amt", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $rvItemOverideAmt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_date_added", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")

     */
    private $rvItemDateAdded;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_date_added_tz", type="string", length=40, nullable=false)
     */
    private $rvItemDateAddedTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_date_arrive", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvItemDateArrive;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_date_depart", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvItemDateDepart;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_date_changed", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")

     */
    private $rvItemDateChanged;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_date_changed_tz", type="string", length=40, nullable=false)
     */
    private $rvItemDateChangedTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_date_booked", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")

     */
    private $rvItemDateBooked;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_date_booked_tz", type="string", length=40, nullable=false)
     */
    private $rvItemDateBookedTz;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_item_adult_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvItemAdultCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_item_child_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvItemChildCount;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_exch_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="1.000000"})
     */
    private $rvItemExchRate;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_item_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $rvItemNights;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_note_conf", type="text", length=65535, nullable=true)
     */
    private $rvItemNoteConf;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_note_general", type="text", length=65535, nullable=true)
     */
    private $rvItemNoteGeneral;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_split_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemSplitYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_item_comm_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvItemCommYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_var_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rvItemVarPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true)
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_series_id", type="string", length=36, nullable=true)
     */
    private $blSeriesId;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_series_sequence_number", type="integer", nullable=true)
     */
    private $blSeriesSequenceNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_id", type="string", length=36, nullable=true)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_sp_benefit_ind", type="boolean", nullable=true)
     */
    private $rvSpBenefitInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_link_res_item_id", type="string", length=36, nullable=true)
     */
    private $rvLinkResItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvReservationId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_item_timestamp", type="datetime", columnDefinition="timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")

     */
    private $rvItemTimestamp;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_timestamp_tz", type="string", length=40, nullable=false)
     */
    private $rvItemTimestampTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_item_user_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvItemUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_itinerary_id", type="string", length=36, nullable=true)
     */
    private $blBlockItineraryId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_alloc_expiry_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rvAllocExpiryDate;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_reservation_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvReservationItemTrfYn;



    /**
     * Get rvReservationItemIx
     *
     * @return string
     */
    public function getRvReservationItemIx()
    {
        return $this->rvReservationItemIx;
    }

    /**
     * Set rvReservationItemDb
     *
     * @param string $rvReservationItemDb
     *
     * @return RvReservationItem
     */
    public function setRvReservationItemDb($rvReservationItemDb)
    {
        $this->rvReservationItemDb = $rvReservationItemDb;

        return $this;
    }

    /**
     * Get rvReservationItemDb
     *
     * @return string
     */
    public function getRvReservationItemDb()
    {
        return $this->rvReservationItemDb;
    }

    /**
     * Set rvReservationItemId
     *
     * @param integer $rvReservationItemId
     *
     * @return RvReservationItem
     */
    public function setRvReservationItemId($rvReservationItemId)
    {
        $this->rvReservationItemId = $rvReservationItemId;

        return $this;
    }

    /**
     * Get rvReservationItemId
     *
     * @return integer
     */
    public function getRvReservationItemId()
    {
        return $this->rvReservationItemId;
    }

    /**
     * Set rvItemAccommCount
     *
     * @param integer $rvItemAccommCount
     *
     * @return RvReservationItem
     */
    public function setRvItemAccommCount($rvItemAccommCount)
    {
        $this->rvItemAccommCount = $rvItemAccommCount;

        return $this;
    }

    /**
     * Get rvItemAccommCount
     *
     * @return integer
     */
    public function getRvItemAccommCount()
    {
        return $this->rvItemAccommCount;
    }

    /**
     * Set rvItemAmtComm
     *
     * @param string $rvItemAmtComm
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtComm($rvItemAmtComm)
    {
        $this->rvItemAmtComm = $rvItemAmtComm;

        return $this;
    }

    /**
     * Get rvItemAmtComm
     *
     * @return string
     */
    public function getRvItemAmtComm()
    {
        return $this->rvItemAmtComm;
    }

    /**
     * Set rvItemAmtGross
     *
     * @param string $rvItemAmtGross
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtGross($rvItemAmtGross)
    {
        $this->rvItemAmtGross = $rvItemAmtGross;

        return $this;
    }

    /**
     * Get rvItemAmtGross
     *
     * @return string
     */
    public function getRvItemAmtGross()
    {
        return $this->rvItemAmtGross;
    }

    /**
     * Set rvItemAmtNett
     *
     * @param string $rvItemAmtNett
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtNett($rvItemAmtNett)
    {
        $this->rvItemAmtNett = $rvItemAmtNett;

        return $this;
    }

    /**
     * Get rvItemAmtNett
     *
     * @return string
     */
    public function getRvItemAmtNett()
    {
        return $this->rvItemAmtNett;
    }

    /**
     * Set rvItemAmtPayable
     *
     * @param string $rvItemAmtPayable
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtPayable($rvItemAmtPayable)
    {
        $this->rvItemAmtPayable = $rvItemAmtPayable;

        return $this;
    }

    /**
     * Get rvItemAmtPayable
     *
     * @return string
     */
    public function getRvItemAmtPayable()
    {
        return $this->rvItemAmtPayable;
    }

    /**
     * Set rvItemAmtTax
     *
     * @param string $rvItemAmtTax
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtTax($rvItemAmtTax)
    {
        $this->rvItemAmtTax = $rvItemAmtTax;

        return $this;
    }

    /**
     * Get rvItemAmtTax
     *
     * @return string
     */
    public function getRvItemAmtTax()
    {
        return $this->rvItemAmtTax;
    }

    /**
     * Set rvItemAmtSpDiscount
     *
     * @param string $rvItemAmtSpDiscount
     *
     * @return RvReservationItem
     */
    public function setRvItemAmtSpDiscount($rvItemAmtSpDiscount)
    {
        $this->rvItemAmtSpDiscount = $rvItemAmtSpDiscount;

        return $this;
    }

    /**
     * Get rvItemAmtSpDiscount
     *
     * @return string
     */
    public function getRvItemAmtSpDiscount()
    {
        return $this->rvItemAmtSpDiscount;
    }

    /**
     * Set rvItemOverideLevelInd
     *
     * @param boolean $rvItemOverideLevelInd
     *
     * @return RvReservationItem
     */
    public function setRvItemOverideLevelInd($rvItemOverideLevelInd)
    {
        $this->rvItemOverideLevelInd = $rvItemOverideLevelInd;

        return $this;
    }

    /**
     * Get rvItemOverideLevelInd
     *
     * @return boolean
     */
    public function getRvItemOverideLevelInd()
    {
        return $this->rvItemOverideLevelInd;
    }

    /**
     * Set rvItemOverideAmt
     *
     * @param string $rvItemOverideAmt
     *
     * @return RvReservationItem
     */
    public function setRvItemOverideAmt($rvItemOverideAmt)
    {
        $this->rvItemOverideAmt = $rvItemOverideAmt;

        return $this;
    }

    /**
     * Get rvItemOverideAmt
     *
     * @return string
     */
    public function getRvItemOverideAmt()
    {
        return $this->rvItemOverideAmt;
    }

    /**
     * Set rvItemDateAdded
     *
     * @param \DateTime $rvItemDateAdded
     *
     * @return RvReservationItem
     */
    public function setRvItemDateAdded($rvItemDateAdded)
    {
        $this->rvItemDateAdded = $rvItemDateAdded;

        return $this;
    }

    /**
     * Get rvItemDateAdded
     *
     * @return \DateTime
     */
    public function getRvItemDateAdded()
    {
        return $this->rvItemDateAdded;
    }

    /**
     * Set rvItemDateAddedTz
     *
     * @param string $rvItemDateAddedTz
     *
     * @return RvReservationItem
     */
    public function setRvItemDateAddedTz($rvItemDateAddedTz)
    {
        $this->rvItemDateAddedTz = $rvItemDateAddedTz;

        return $this;
    }

    /**
     * Get rvItemDateAddedTz
     *
     * @return string
     */
    public function getRvItemDateAddedTz()
    {
        return $this->rvItemDateAddedTz;
    }

    /**
     * Set rvItemDateArrive
     *
     * @param \DateTime $rvItemDateArrive
     *
     * @return RvReservationItem
     */
    public function setRvItemDateArrive($rvItemDateArrive)
    {
        $this->rvItemDateArrive = $rvItemDateArrive;

        return $this;
    }

    /**
     * Get rvItemDateArrive
     *
     * @return \DateTime
     */
    public function getRvItemDateArrive()
    {
        return $this->rvItemDateArrive;
    }

    /**
     * Set rvItemDateDepart
     *
     * @param \DateTime $rvItemDateDepart
     *
     * @return RvReservationItem
     */
    public function setRvItemDateDepart($rvItemDateDepart)
    {
        $this->rvItemDateDepart = $rvItemDateDepart;

        return $this;
    }

    /**
     * Get rvItemDateDepart
     *
     * @return \DateTime
     */
    public function getRvItemDateDepart()
    {
        return $this->rvItemDateDepart;
    }

    /**
     * Set rvItemDateChanged
     *
     * @param \DateTime $rvItemDateChanged
     *
     * @return RvReservationItem
     */
    public function setRvItemDateChanged($rvItemDateChanged)
    {
        $this->rvItemDateChanged = $rvItemDateChanged;

        return $this;
    }

    /**
     * Get rvItemDateChanged
     *
     * @return \DateTime
     */
    public function getRvItemDateChanged()
    {
        return $this->rvItemDateChanged;
    }

    /**
     * Set rvItemDateChangedTz
     *
     * @param string $rvItemDateChangedTz
     *
     * @return RvReservationItem
     */
    public function setRvItemDateChangedTz($rvItemDateChangedTz)
    {
        $this->rvItemDateChangedTz = $rvItemDateChangedTz;

        return $this;
    }

    /**
     * Get rvItemDateChangedTz
     *
     * @return string
     */
    public function getRvItemDateChangedTz()
    {
        return $this->rvItemDateChangedTz;
    }

    /**
     * Set rvItemDateBooked
     *
     * @param \DateTime $rvItemDateBooked
     *
     * @return RvReservationItem
     */
    public function setRvItemDateBooked($rvItemDateBooked)
    {
        $this->rvItemDateBooked = $rvItemDateBooked;

        return $this;
    }

    /**
     * Get rvItemDateBooked
     *
     * @return \DateTime
     */
    public function getRvItemDateBooked()
    {
        return $this->rvItemDateBooked;
    }

    /**
     * Set rvItemDateBookedTz
     *
     * @param string $rvItemDateBookedTz
     *
     * @return RvReservationItem
     */
    public function setRvItemDateBookedTz($rvItemDateBookedTz)
    {
        $this->rvItemDateBookedTz = $rvItemDateBookedTz;

        return $this;
    }

    /**
     * Get rvItemDateBookedTz
     *
     * @return string
     */
    public function getRvItemDateBookedTz()
    {
        return $this->rvItemDateBookedTz;
    }

    /**
     * Set rvItemAdultCount
     *
     * @param integer $rvItemAdultCount
     *
     * @return RvReservationItem
     */
    public function setRvItemAdultCount($rvItemAdultCount)
    {
        $this->rvItemAdultCount = $rvItemAdultCount;

        return $this;
    }

    /**
     * Get rvItemAdultCount
     *
     * @return integer
     */
    public function getRvItemAdultCount()
    {
        return $this->rvItemAdultCount;
    }

    /**
     * Set rvItemChildCount
     *
     * @param integer $rvItemChildCount
     *
     * @return RvReservationItem
     */
    public function setRvItemChildCount($rvItemChildCount)
    {
        $this->rvItemChildCount = $rvItemChildCount;

        return $this;
    }

    /**
     * Get rvItemChildCount
     *
     * @return integer
     */
    public function getRvItemChildCount()
    {
        return $this->rvItemChildCount;
    }

    /**
     * Set rvItemExchRate
     *
     * @param string $rvItemExchRate
     *
     * @return RvReservationItem
     */
    public function setRvItemExchRate($rvItemExchRate)
    {
        $this->rvItemExchRate = $rvItemExchRate;

        return $this;
    }

    /**
     * Get rvItemExchRate
     *
     * @return string
     */
    public function getRvItemExchRate()
    {
        return $this->rvItemExchRate;
    }

    /**
     * Set rvItemNights
     *
     * @param integer $rvItemNights
     *
     * @return RvReservationItem
     */
    public function setRvItemNights($rvItemNights)
    {
        $this->rvItemNights = $rvItemNights;

        return $this;
    }

    /**
     * Get rvItemNights
     *
     * @return integer
     */
    public function getRvItemNights()
    {
        return $this->rvItemNights;
    }

    /**
     * Set rvItemNoteConf
     *
     * @param string $rvItemNoteConf
     *
     * @return RvReservationItem
     */
    public function setRvItemNoteConf($rvItemNoteConf)
    {
        $this->rvItemNoteConf = $rvItemNoteConf;

        return $this;
    }

    /**
     * Get rvItemNoteConf
     *
     * @return string
     */
    public function getRvItemNoteConf()
    {
        return $this->rvItemNoteConf;
    }

    /**
     * Set rvItemNoteGeneral
     *
     * @param string $rvItemNoteGeneral
     *
     * @return RvReservationItem
     */
    public function setRvItemNoteGeneral($rvItemNoteGeneral)
    {
        $this->rvItemNoteGeneral = $rvItemNoteGeneral;

        return $this;
    }

    /**
     * Get rvItemNoteGeneral
     *
     * @return string
     */
    public function getRvItemNoteGeneral()
    {
        return $this->rvItemNoteGeneral;
    }

    /**
     * Set rvItemSplitYn
     *
     * @param boolean $rvItemSplitYn
     *
     * @return RvReservationItem
     */
    public function setRvItemSplitYn($rvItemSplitYn)
    {
        $this->rvItemSplitYn = $rvItemSplitYn;

        return $this;
    }

    /**
     * Get rvItemSplitYn
     *
     * @return boolean
     */
    public function getRvItemSplitYn()
    {
        return $this->rvItemSplitYn;
    }

    /**
     * Set rvItemCommYn
     *
     * @param boolean $rvItemCommYn
     *
     * @return RvReservationItem
     */
    public function setRvItemCommYn($rvItemCommYn)
    {
        $this->rvItemCommYn = $rvItemCommYn;

        return $this;
    }

    /**
     * Get rvItemCommYn
     *
     * @return boolean
     */
    public function getRvItemCommYn()
    {
        return $this->rvItemCommYn;
    }

    /**
     * Set rvItemVarPerc
     *
     * @param string $rvItemVarPerc
     *
     * @return RvReservationItem
     */
    public function setRvItemVarPerc($rvItemVarPerc)
    {
        $this->rvItemVarPerc = $rvItemVarPerc;

        return $this;
    }

    /**
     * Get rvItemVarPerc
     *
     * @return string
     */
    public function getRvItemVarPerc()
    {
        return $this->rvItemVarPerc;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return RvReservationItem
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set blSeriesId
     *
     * @param string $blSeriesId
     *
     * @return RvReservationItem
     */
    public function setBlSeriesId($blSeriesId)
    {
        $this->blSeriesId = $blSeriesId;

        return $this;
    }

    /**
     * Get blSeriesId
     *
     * @return string
     */
    public function getBlSeriesId()
    {
        return $this->blSeriesId;
    }

    /**
     * Set blSeriesSequenceNumber
     *
     * @param integer $blSeriesSequenceNumber
     *
     * @return RvReservationItem
     */
    public function setBlSeriesSequenceNumber($blSeriesSequenceNumber)
    {
        $this->blSeriesSequenceNumber = $blSeriesSequenceNumber;

        return $this;
    }

    /**
     * Get blSeriesSequenceNumber
     *
     * @return integer
     */
    public function getBlSeriesSequenceNumber()
    {
        return $this->blSeriesSequenceNumber;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return RvReservationItem
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RvReservationItem
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnFolioId
     *
     * @param string $fnFolioId
     *
     * @return RvReservationItem
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return string
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return RvReservationItem
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return RvReservationItem
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set rvSpBenefitInd
     *
     * @param boolean $rvSpBenefitInd
     *
     * @return RvReservationItem
     */
    public function setRvSpBenefitInd($rvSpBenefitInd)
    {
        $this->rvSpBenefitInd = $rvSpBenefitInd;

        return $this;
    }

    /**
     * Get rvSpBenefitInd
     *
     * @return boolean
     */
    public function getRvSpBenefitInd()
    {
        return $this->rvSpBenefitInd;
    }

    /**
     * Set rvLinkResItemId
     *
     * @param string $rvLinkResItemId
     *
     * @return RvReservationItem
     */
    public function setRvLinkResItemId($rvLinkResItemId)
    {
        $this->rvLinkResItemId = $rvLinkResItemId;

        return $this;
    }

    /**
     * Get rvLinkResItemId
     *
     * @return string
     */
    public function getRvLinkResItemId()
    {
        return $this->rvLinkResItemId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvReservationItem
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvItemTimestamp
     *
     * @param \DateTime $rvItemTimestamp
     *
     * @return RvReservationItem
     */
    public function setRvItemTimestamp($rvItemTimestamp)
    {
        $this->rvItemTimestamp = $rvItemTimestamp;

        return $this;
    }

    /**
     * Get rvItemTimestamp
     *
     * @return \DateTime
     */
    public function getRvItemTimestamp()
    {
        return $this->rvItemTimestamp;
    }

    /**
     * Set rvItemTimestampTz
     *
     * @param string $rvItemTimestampTz
     *
     * @return RvReservationItem
     */
    public function setRvItemTimestampTz($rvItemTimestampTz)
    {
        $this->rvItemTimestampTz = $rvItemTimestampTz;

        return $this;
    }

    /**
     * Get rvItemTimestampTz
     *
     * @return string
     */
    public function getRvItemTimestampTz()
    {
        return $this->rvItemTimestampTz;
    }

    /**
     * Set rvItemUserId
     *
     * @param string $rvItemUserId
     *
     * @return RvReservationItem
     */
    public function setRvItemUserId($rvItemUserId)
    {
        $this->rvItemUserId = $rvItemUserId;

        return $this;
    }

    /**
     * Get rvItemUserId
     *
     * @return string
     */
    public function getRvItemUserId()
    {
        return $this->rvItemUserId;
    }

    /**
     * Set blBlockItineraryId
     *
     * @param string $blBlockItineraryId
     *
     * @return RvReservationItem
     */
    public function setBlBlockItineraryId($blBlockItineraryId)
    {
        $this->blBlockItineraryId = $blBlockItineraryId;

        return $this;
    }

    /**
     * Get blBlockItineraryId
     *
     * @return string
     */
    public function getBlBlockItineraryId()
    {
        return $this->blBlockItineraryId;
    }

    /**
     * Set rvAllocExpiryDate
     *
     * @param \DateTime $rvAllocExpiryDate
     *
     * @return RvReservationItem
     */
    public function setRvAllocExpiryDate($rvAllocExpiryDate)
    {
        $this->rvAllocExpiryDate = $rvAllocExpiryDate;

        return $this;
    }

    /**
     * Get rvAllocExpiryDate
     *
     * @return \DateTime
     */
    public function getRvAllocExpiryDate()
    {
        return $this->rvAllocExpiryDate;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvReservationItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvReservationItemTrfYn
     *
     * @param boolean $rvReservationItemTrfYn
     *
     * @return RvReservationItem
     */
    public function setRvReservationItemTrfYn($rvReservationItemTrfYn)
    {
        $this->rvReservationItemTrfYn = $rvReservationItemTrfYn;

        return $this;
    }

    /**
     * Get rvReservationItemTrfYn
     *
     * @return boolean
     */
    public function getRvReservationItemTrfYn()
    {
        return $this->rvReservationItemTrfYn;
    }
}
