<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvSpecial
 *
 * @ORM\Table(name="rv_special", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_special_trf_yn", columns={"rv_special_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RvSpecial
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_special_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvSpecialIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_special_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvSpecialDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_special_id", type="integer", nullable=false)
     */
    private $rvSpecialId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_sp_overide_yn", type="string", length=36, nullable=true)
     */
    private $rvSpOverideYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_sp_overide_user_id", type="string", length=36, nullable=true)
     */
    private $rvSpOverideUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rv_sp_overide_date_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rvSpOverideDateTime;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_sp_overide_date_time_tz", type="string", length=40, nullable=false)
     */
    private $rvSpOverideDateTimeTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_special_trf_yn", type="boolean", nullable=true)
     */
    private $rvSpecialTrfYn;



    /**
     * Get rvSpecialIx
     *
     * @return string
     */
    public function getRvSpecialIx()
    {
        return $this->rvSpecialIx;
    }

    /**
     * Set rvSpecialDb
     *
     * @param string $rvSpecialDb
     *
     * @return RvSpecial
     */
    public function setRvSpecialDb($rvSpecialDb)
    {
        $this->rvSpecialDb = $rvSpecialDb;

        return $this;
    }

    /**
     * Get rvSpecialDb
     *
     * @return string
     */
    public function getRvSpecialDb()
    {
        return $this->rvSpecialDb;
    }

    /**
     * Set rvSpecialId
     *
     * @param integer $rvSpecialId
     *
     * @return RvSpecial
     */
    public function setRvSpecialId($rvSpecialId)
    {
        $this->rvSpecialId = $rvSpecialId;

        return $this;
    }

    /**
     * Get rvSpecialId
     *
     * @return integer
     */
    public function getRvSpecialId()
    {
        return $this->rvSpecialId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvSpecial
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return RvSpecial
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set rvSpOverideYn
     *
     * @param string $rvSpOverideYn
     *
     * @return RvSpecial
     */
    public function setRvSpOverideYn($rvSpOverideYn)
    {
        $this->rvSpOverideYn = $rvSpOverideYn;

        return $this;
    }

    /**
     * Get rvSpOverideYn
     *
     * @return string
     */
    public function getRvSpOverideYn()
    {
        return $this->rvSpOverideYn;
    }

    /**
     * Set rvSpOverideUserId
     *
     * @param string $rvSpOverideUserId
     *
     * @return RvSpecial
     */
    public function setRvSpOverideUserId($rvSpOverideUserId)
    {
        $this->rvSpOverideUserId = $rvSpOverideUserId;

        return $this;
    }

    /**
     * Get rvSpOverideUserId
     *
     * @return string
     */
    public function getRvSpOverideUserId()
    {
        return $this->rvSpOverideUserId;
    }

    /**
     * Set rvSpOverideDateTime
     *
     * @param \DateTime $rvSpOverideDateTime
     *
     * @return RvSpecial
     */
    public function setRvSpOverideDateTime($rvSpOverideDateTime)
    {
        $this->rvSpOverideDateTime = $rvSpOverideDateTime;

        return $this;
    }

    /**
     * Get rvSpOverideDateTime
     *
     * @return \DateTime
     */
    public function getRvSpOverideDateTime()
    {
        return $this->rvSpOverideDateTime;
    }

    /**
     * Set rvSpOverideDateTimeTz
     *
     * @param string $rvSpOverideDateTimeTz
     *
     * @return RvSpecial
     */
    public function setRvSpOverideDateTimeTz($rvSpOverideDateTimeTz)
    {
        $this->rvSpOverideDateTimeTz = $rvSpOverideDateTimeTz;

        return $this;
    }

    /**
     * Get rvSpOverideDateTimeTz
     *
     * @return string
     */
    public function getRvSpOverideDateTimeTz()
    {
        return $this->rvSpOverideDateTimeTz;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RvSpecial
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RvSpecial
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return RvSpecial
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return RvSpecial
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return RvSpecial
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return RvSpecial
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return RvSpecial
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return RvSpecial
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return RvSpecial
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvSpecial
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvSpecialTrfYn
     *
     * @param boolean $rvSpecialTrfYn
     *
     * @return RvSpecial
     */
    public function setRvSpecialTrfYn($rvSpecialTrfYn)
    {
        $this->rvSpecialTrfYn = $rvSpecialTrfYn;

        return $this;
    }

    /**
     * Get rvSpecialTrfYn
     *
     * @return boolean
     */
    public function getRvSpecialTrfYn()
    {
        return $this->rvSpecialTrfYn;
    }
}
