<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RvTripObjData
 *
 * @ORM\Table(name="rv_trip_obj_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_trip_obj_data_trf_yn", columns={"rv_trip_obj_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="rf_obj_trip_data_id", columns={"rf_obj_trip_data_id"}), @ORM\Index(name="rf_obj_trip_id", columns={"rf_obj_trip_id"}), @ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"})})
 * @ORM\Entity
 */
class RvTripObjData
{
    /**
     * @var string
     *
     * @ORM\Column(name="rv_trip_obj_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvTripObjDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_trip_obj_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rvTripObjDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rv_trip_obj_data_id", type="integer", nullable=false)
     */
    private $rvTripObjDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_trip_obj_data", type="text", length=16777215, nullable=true)
     */
    private $rvTripObjData;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_data_id", type="string", length=36, nullable=true)
     */
    private $rfObjTripDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_id", type="string", length=36, nullable=true)
     */
    private $rfObjTripId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=true)
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_trip_obj_data_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rvTripObjDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rv_trip_obj_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rvTripObjDataTrfYn;



    /**
     * Get rvTripObjDataIx
     *
     * @return string
     */
    public function getRvTripObjDataIx()
    {
        return $this->rvTripObjDataIx;
    }

    /**
     * Set rvTripObjDataDb
     *
     * @param string $rvTripObjDataDb
     *
     * @return RvTripObjData
     */
    public function setRvTripObjDataDb($rvTripObjDataDb)
    {
        $this->rvTripObjDataDb = $rvTripObjDataDb;

        return $this;
    }

    /**
     * Get rvTripObjDataDb
     *
     * @return string
     */
    public function getRvTripObjDataDb()
    {
        return $this->rvTripObjDataDb;
    }

    /**
     * Set rvTripObjDataId
     *
     * @param integer $rvTripObjDataId
     *
     * @return RvTripObjData
     */
    public function setRvTripObjDataId($rvTripObjDataId)
    {
        $this->rvTripObjDataId = $rvTripObjDataId;

        return $this;
    }

    /**
     * Get rvTripObjDataId
     *
     * @return integer
     */
    public function getRvTripObjDataId()
    {
        return $this->rvTripObjDataId;
    }

    /**
     * Set rvTripObjData
     *
     * @param string $rvTripObjData
     *
     * @return RvTripObjData
     */
    public function setRvTripObjData($rvTripObjData)
    {
        $this->rvTripObjData = $rvTripObjData;

        return $this;
    }

    /**
     * Get rvTripObjData
     *
     * @return string
     */
    public function getRvTripObjData()
    {
        return $this->rvTripObjData;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RvTripObjData
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfObjTripDataId
     *
     * @param string $rfObjTripDataId
     *
     * @return RvTripObjData
     */
    public function setRfObjTripDataId($rfObjTripDataId)
    {
        $this->rfObjTripDataId = $rfObjTripDataId;

        return $this;
    }

    /**
     * Get rfObjTripDataId
     *
     * @return string
     */
    public function getRfObjTripDataId()
    {
        return $this->rfObjTripDataId;
    }

    /**
     * Set rfObjTripId
     *
     * @param string $rfObjTripId
     *
     * @return RvTripObjData
     */
    public function setRfObjTripId($rfObjTripId)
    {
        $this->rfObjTripId = $rfObjTripId;

        return $this;
    }

    /**
     * Get rfObjTripId
     *
     * @return string
     */
    public function getRfObjTripId()
    {
        return $this->rfObjTripId;
    }

    /**
     * Set prGuestId
     *
     * @param string $prGuestId
     *
     * @return RvTripObjData
     */
    public function setPrGuestId($prGuestId)
    {
        $this->prGuestId = $prGuestId;

        return $this;
    }

    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return RvTripObjData
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvTripObjDataInactiveYn
     *
     * @param boolean $rvTripObjDataInactiveYn
     *
     * @return RvTripObjData
     */
    public function setRvTripObjDataInactiveYn($rvTripObjDataInactiveYn)
    {
        $this->rvTripObjDataInactiveYn = $rvTripObjDataInactiveYn;

        return $this;
    }

    /**
     * Get rvTripObjDataInactiveYn
     *
     * @return boolean
     */
    public function getRvTripObjDataInactiveYn()
    {
        return $this->rvTripObjDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvTripObjData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rvTripObjDataTrfYn
     *
     * @param boolean $rvTripObjDataTrfYn
     *
     * @return RvTripObjData
     */
    public function setRvTripObjDataTrfYn($rvTripObjDataTrfYn)
    {
        $this->rvTripObjDataTrfYn = $rvTripObjDataTrfYn;

        return $this;
    }

    /**
     * Get rvTripObjDataTrfYn
     *
     * @return boolean
     */
    public function getRvTripObjDataTrfYn()
    {
        return $this->rvTripObjDataTrfYn;
    }
}
