<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScAccomm
 *
 * @ORM\Table(name="sc_accomm", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_accomm_trf_yn", columns={"sc_accomm_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScAccomm
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_accomm_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scAccommId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_group_id", type="integer", nullable=true)
     */
    private $scGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_accomm_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scAccommTrfYn;



    /**
     * Get scAccommId
     *
     * @return integer
     */
    public function getScAccommId()
    {
        return $this->scAccommId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return ScAccomm
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set scGroupId
     *
     * @param integer $scGroupId
     *
     * @return ScAccomm
     */
    public function setScGroupId($scGroupId)
    {
        $this->scGroupId = $scGroupId;

        return $this;
    }

    /**
     * Get scGroupId
     *
     * @return integer
     */
    public function getScGroupId()
    {
        return $this->scGroupId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScAccomm
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scAccommTrfYn
     *
     * @param boolean $scAccommTrfYn
     *
     * @return ScAccomm
     */
    public function setScAccommTrfYn($scAccommTrfYn)
    {
        $this->scAccommTrfYn = $scAccommTrfYn;

        return $this;
    }

    /**
     * Get scAccommTrfYn
     *
     * @return boolean
     */
    public function getScAccommTrfYn()
    {
        return $this->scAccommTrfYn;
    }
}
