<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScField
 *
 * @ORM\Table(name="sc_field", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="sc_field_id", columns={"sc_field_id"})})
 * @ORM\Entity
 */
class ScField
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_field_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     */
    private $scFieldId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="sc_fld_name_db", type="text", length=65535, nullable=true)
     */
    private $scFldNameDb;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_fld_help", type="text", length=65535, nullable=true)
     */
    private $scFldHelp;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_fld_conf_yn", type="boolean", nullable=true)
     */
    private $scFldConfYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_field_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scFieldTrfYn = '0';



    /**
     * Set scFieldId
     *
     * @param integer $scFieldId
     *
     * @return ScField
     */
    public function setScFieldId($scFieldId)
    {
        $this->scFieldId = $scFieldId;

        return $this;
    }

    /**
     * Get scFieldId
     *
     * @return integer
     */
    public function getScFieldId()
    {
        return $this->scFieldId;
    }

    /**
     * Set scFldNameDb
     *
     * @param string $scFldNameDb
     *
     * @return ScField
     */
    public function setScFldNameDb($scFldNameDb)
    {
        $this->scFldNameDb = $scFldNameDb;

        return $this;
    }

    /**
     * Get scFldNameDb
     *
     * @return string
     */
    public function getScFldNameDb()
    {
        return $this->scFldNameDb;
    }

    /**
     * Set scFldHelp
     *
     * @param string $scFldHelp
     *
     * @return ScField
     */
    public function setScFldHelp($scFldHelp)
    {
        $this->scFldHelp = $scFldHelp;

        return $this;
    }

    /**
     * Get scFldHelp
     *
     * @return string
     */
    public function getScFldHelp()
    {
        return $this->scFldHelp;
    }

    /**
     * Set scFldConfYn
     *
     * @param boolean $scFldConfYn
     *
     * @return ScField
     */
    public function setScFldConfYn($scFldConfYn)
    {
        $this->scFldConfYn = $scFldConfYn;

        return $this;
    }

    /**
     * Get scFldConfYn
     *
     * @return boolean
     */
    public function getScFldConfYn()
    {
        return $this->scFldConfYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScField
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scFieldTrfYn
     *
     * @param boolean $scFieldTrfYn
     *
     * @return ScField
     */
    public function setScFieldTrfYn($scFieldTrfYn)
    {
        $this->scFieldTrfYn = $scFieldTrfYn;

        return $this;
    }

    /**
     * Get scFieldTrfYn
     *
     * @return boolean
     */
    public function getScFieldTrfYn()
    {
        return $this->scFieldTrfYn;
    }
}
