<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScFunGroup
 *
 * @ORM\Table(name="sc_fun_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_fun_group_trf_yn", columns={"sc_fun_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="sc_group_id", columns={"sc_group_id"}), @ORM\Index(name="sc_function_id", columns={"sc_function_id"})})
 * @ORM\Entity
 */
class ScFunGroup
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_fun_group_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scFunGroupId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_function_id", type="integer", nullable=true)
     */
    private $scFunctionId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_group_id", type="integer", nullable=true)
     */
    private $scGroupId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_fun_grp_level", type="integer", nullable=true)
     */
    private $scFunGrpLevel;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_fun_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scFunGroupTrfYn;



    /**
     * Get scFunGroupId
     *
     * @return integer
     */
    public function getScFunGroupId()
    {
        return $this->scFunGroupId;
    }

    /**
     * Set scFunctionId
     *
     * @param integer $scFunctionId
     *
     * @return ScFunGroup
     */
    public function setScFunctionId($scFunctionId)
    {
        $this->scFunctionId = $scFunctionId;

        return $this;
    }

    /**
     * Get scFunctionId
     *
     * @return integer
     */
    public function getScFunctionId()
    {
        return $this->scFunctionId;
    }

    /**
     * Set scGroupId
     *
     * @param integer $scGroupId
     *
     * @return ScFunGroup
     */
    public function setScGroupId($scGroupId)
    {
        $this->scGroupId = $scGroupId;

        return $this;
    }

    /**
     * Get scGroupId
     *
     * @return integer
     */
    public function getScGroupId()
    {
        return $this->scGroupId;
    }

    /**
     * Set scFunGrpLevel
     *
     * @param boolean $scFunGrpLevel
     *
     * @return ScFunGroup
     */
    public function setScFunGrpLevel($scFunGrpLevel)
    {
        $this->scFunGrpLevel = $scFunGrpLevel;

        return $this;
    }

    /**
     * Get scFunGrpLevel
     *
     * @return boolean
     */
    public function getScFunGrpLevel()
    {
        return $this->scFunGrpLevel;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScFunGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scFunGroupTrfYn
     *
     * @param boolean $scFunGroupTrfYn
     *
     * @return ScFunGroup
     */
    public function setScFunGroupTrfYn($scFunGroupTrfYn)
    {
        $this->scFunGroupTrfYn = $scFunGroupTrfYn;

        return $this;
    }

    /**
     * Get scFunGroupTrfYn
     *
     * @return boolean
     */
    public function getScFunGroupTrfYn()
    {
        return $this->scFunGroupTrfYn;
    }
}
