<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScFunJob
 *
 * @ORM\Table(name="sc_fun_job", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_fun_job_trf_yn", columns={"sc_fun_job_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScFunJob
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_fun_job_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scFunJobId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_job_id", type="integer", nullable=true)
     */
    private $scJobId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_function_id", type="integer", nullable=true)
     */
    private $scFunctionId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_fun_job_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scFunJobTrfYn;



    /**
     * Get scFunJobId
     *
     * @return integer
     */
    public function getScFunJobId()
    {
        return $this->scFunJobId;
    }

    /**
     * Set scJobId
     *
     * @param integer $scJobId
     *
     * @return ScFunJob
     */
    public function setScJobId($scJobId)
    {
        $this->scJobId = $scJobId;

        return $this;
    }

    /**
     * Get scJobId
     *
     * @return integer
     */
    public function getScJobId()
    {
        return $this->scJobId;
    }

    /**
     * Set scFunctionId
     *
     * @param integer $scFunctionId
     *
     * @return ScFunJob
     */
    public function setScFunctionId($scFunctionId)
    {
        $this->scFunctionId = $scFunctionId;

        return $this;
    }

    /**
     * Get scFunctionId
     *
     * @return integer
     */
    public function getScFunctionId()
    {
        return $this->scFunctionId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScFunJob
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scFunJobTrfYn
     *
     * @param boolean $scFunJobTrfYn
     *
     * @return ScFunJob
     */
    public function setScFunJobTrfYn($scFunJobTrfYn)
    {
        $this->scFunJobTrfYn = $scFunJobTrfYn;

        return $this;
    }

    /**
     * Get scFunJobTrfYn
     *
     * @return boolean
     */
    public function getScFunJobTrfYn()
    {
        return $this->scFunJobTrfYn;
    }
}
