<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScFunction
 *
 * @ORM\Table(name="sc_function", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_function_trf_yn", columns={"sc_function_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScFunction
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_function_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scFunctionId;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_fun_code", type="string", length=10, nullable=true, options={"fixed"="true"})
     */
    private $scFunCode;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_fun_desc", type="string", length=50, nullable=true, options={"fixed"="true"})
     */
    private $scFunDesc;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_fun_sys_code", type="integer", nullable=false, options={"default"="0"})
     */
    private $scFunSysCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_function_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scFunctionTrfYn;



    /**
     * Get scFunctionId
     *
     * @return integer
     */
    public function getScFunctionId()
    {
        return $this->scFunctionId;
    }

    /**
     * Set scFunCode
     *
     * @param string $scFunCode
     *
     * @return ScFunction
     */
    public function setScFunCode($scFunCode)
    {
        $this->scFunCode = $scFunCode;

        return $this;
    }

    /**
     * Get scFunCode
     *
     * @return string
     */
    public function getScFunCode()
    {
        return $this->scFunCode;
    }

    /**
     * Set scFunDesc
     *
     * @param string $scFunDesc
     *
     * @return ScFunction
     */
    public function setScFunDesc($scFunDesc)
    {
        $this->scFunDesc = $scFunDesc;

        return $this;
    }

    /**
     * Get scFunDesc
     *
     * @return string
     */
    public function getScFunDesc()
    {
        return $this->scFunDesc;
    }

    /**
     * Set scFunSysCode
     *
     * @param integer $scFunSysCode
     *
     * @return ScFunction
     */
    public function setScFunSysCode($scFunSysCode)
    {
        $this->scFunSysCode = $scFunSysCode;

        return $this;
    }

    /**
     * Get scFunSysCode
     *
     * @return integer
     */
    public function getScFunSysCode()
    {
        return $this->scFunSysCode;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfNoteCustItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scFunctionTrfYn
     *
     * @param boolean $scFunctionTrfYn
     *
     * @return ScFunction
     */
    public function setScFunctionTrfYn($scFunctionTrfYn)
    {
        $this->scFunctionTrfYn = $scFunctionTrfYn;

        return $this;
    }

    /**
     * Get scFunctionTrfYn
     *
     * @return boolean
     */
    public function getScFunctionTrfYn()
    {
        return $this->scFunctionTrfYn;
    }
}
