<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScGroup
 *
 * @ORM\Table(name="sc_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_group_trf_yn", columns={"sc_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScGroup
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_group_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scGroupId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_grp_avail_limit", type="smallint", nullable=false, options={"default"="0"})
     */
    private $scGrpAvailLimit;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_avail_limit_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpAvailLimitYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_avail_prov_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpAvailProvYn;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_grp_code", type="string", length=5, nullable=true)
     */
    private $scGrpCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_consultant_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpConsultantYn;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_grp_desc", type="string", length=50, nullable=true)
     */
    private $scGrpDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_alloc_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpAllocInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_api_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpApiYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_def_optionals_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $scGrpDefOptionalsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_archive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpArchiveYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_force_payment_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpForcePaymentYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_lock_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $scGrpResLockYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_grp_res_lock_days", type="smallint", nullable=false, options={"default"="0"})
     */
    private $scGrpResLockDays;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_lock_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $scGrpResLockInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_status_unalloc_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResStatusUnallocYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_status_alloc_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResStatusAllocYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_void_invoice_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResVoidInvoiceYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_void_payment_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResVoidPaymentYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_cross_invoice_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $scGrpCrossInvoiceYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_rate_type_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrRateTypeYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_amount_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrAmountYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_variance_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrVarianceYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_overbooking_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrOverbookingYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_specials_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrSpecialsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_ovr_total_pax_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResOvrTotalPaxYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_sp_apply_auto_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResSpApplyAutoYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_sp_apply_man_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResSpApplyManYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_wetu_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResWetuYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpInactiveYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_edit_details_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResEditDetailsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_grp_res_edit_itineraries_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGrpResEditItinerariesYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scGroupTrfYn;



    /**
     * Get scGroupId
     *
     * @return integer
     */
    public function getScGroupId()
    {
        return $this->scGroupId;
    }

    /**
     * Set scGrpAvailLimit
     *
     * @param integer $scGrpAvailLimit
     *
     * @return ScGroup
     */
    public function setScGrpAvailLimit($scGrpAvailLimit)
    {
        $this->scGrpAvailLimit = $scGrpAvailLimit;

        return $this;
    }

    /**
     * Get scGrpAvailLimit
     *
     * @return integer
     */
    public function getScGrpAvailLimit()
    {
        return $this->scGrpAvailLimit;
    }

    /**
     * Set scGrpAvailLimitYn
     *
     * @param boolean $scGrpAvailLimitYn
     *
     * @return ScGroup
     */
    public function setScGrpAvailLimitYn($scGrpAvailLimitYn)
    {
        $this->scGrpAvailLimitYn = $scGrpAvailLimitYn;

        return $this;
    }

    /**
     * Get scGrpAvailLimitYn
     *
     * @return boolean
     */
    public function getScGrpAvailLimitYn()
    {
        return $this->scGrpAvailLimitYn;
    }

    /**
     * Set scGrpAvailProvYn
     *
     * @param boolean $scGrpAvailProvYn
     *
     * @return ScGroup
     */
    public function setScGrpAvailProvYn($scGrpAvailProvYn)
    {
        $this->scGrpAvailProvYn = $scGrpAvailProvYn;

        return $this;
    }

    /**
     * Get scGrpAvailProvYn
     *
     * @return boolean
     */
    public function getScGrpAvailProvYn()
    {
        return $this->scGrpAvailProvYn;
    }

    /**
     * Set scGrpCode
     *
     * @param string $scGrpCode
     *
     * @return ScGroup
     */
    public function setScGrpCode($scGrpCode)
    {
        $this->scGrpCode = $scGrpCode;

        return $this;
    }

    /**
     * Get scGrpCode
     *
     * @return string
     */
    public function getScGrpCode()
    {
        return $this->scGrpCode;
    }

    /**
     * Set scGrpConsultantYn
     *
     * @param boolean $scGrpConsultantYn
     *
     * @return ScGroup
     */
    public function setScGrpConsultantYn($scGrpConsultantYn)
    {
        $this->scGrpConsultantYn = $scGrpConsultantYn;

        return $this;
    }

    /**
     * Get scGrpConsultantYn
     *
     * @return boolean
     */
    public function getScGrpConsultantYn()
    {
        return $this->scGrpConsultantYn;
    }

    /**
     * Set scGrpDesc
     *
     * @param string $scGrpDesc
     *
     * @return ScGroup
     */
    public function setScGrpDesc($scGrpDesc)
    {
        $this->scGrpDesc = $scGrpDesc;

        return $this;
    }

    /**
     * Get scGrpDesc
     *
     * @return string
     */
    public function getScGrpDesc()
    {
        return $this->scGrpDesc;
    }

    /**
     * Set scGrpAllocInd
     *
     * @param boolean $scGrpAllocInd
     *
     * @return ScGroup
     */
    public function setScGrpAllocInd($scGrpAllocInd)
    {
        $this->scGrpAllocInd = $scGrpAllocInd;

        return $this;
    }

    /**
     * Get scGrpAllocInd
     *
     * @return boolean
     */
    public function getScGrpAllocInd()
    {
        return $this->scGrpAllocInd;
    }

    /**
     * Set scGrpApiYn
     *
     * @param boolean $scGrpApiYn
     *
     * @return ScGroup
     */
    public function setScGrpApiYn($scGrpApiYn)
    {
        $this->scGrpApiYn = $scGrpApiYn;

        return $this;
    }

    /**
     * Get scGrpApiYn
     *
     * @return boolean
     */
    public function getScGrpApiYn()
    {
        return $this->scGrpApiYn;
    }

    /**
     * Set scGrpDefOptionalsYn
     *
     * @param boolean $scGrpDefOptionalsYn
     *
     * @return ScGroup
     */
    public function setScGrpDefOptionalsYn($scGrpDefOptionalsYn)
    {
        $this->scGrpDefOptionalsYn = $scGrpDefOptionalsYn;

        return $this;
    }

    /**
     * Get scGrpDefOptionalsYn
     *
     * @return boolean
     */
    public function getScGrpDefOptionalsYn()
    {
        return $this->scGrpDefOptionalsYn;
    }

    /**
     * Set scGrpArchiveYn
     *
     * @param boolean $scGrpArchiveYn
     *
     * @return ScGroup
     */
    public function setScGrpArchiveYn($scGrpArchiveYn)
    {
        $this->scGrpArchiveYn = $scGrpArchiveYn;

        return $this;
    }

    /**
     * Get scGrpArchiveYn
     *
     * @return boolean
     */
    public function getScGrpArchiveYn()
    {
        return $this->scGrpArchiveYn;
    }

    /**
     * Set scGrpForcePaymentYn
     *
     * @param boolean $scGrpForcePaymentYn
     *
     * @return ScGroup
     */
    public function setScGrpForcePaymentYn($scGrpForcePaymentYn)
    {
        $this->scGrpForcePaymentYn = $scGrpForcePaymentYn;

        return $this;
    }

    /**
     * Get scGrpForcePaymentYn
     *
     * @return boolean
     */
    public function getScGrpForcePaymentYn()
    {
        return $this->scGrpForcePaymentYn;
    }

    /**
     * Set scGrpResLockYn
     *
     * @param boolean $scGrpResLockYn
     *
     * @return ScGroup
     */
    public function setScGrpResLockYn($scGrpResLockYn)
    {
        $this->scGrpResLockYn = $scGrpResLockYn;

        return $this;
    }

    /**
     * Get scGrpResLockYn
     *
     * @return boolean
     */
    public function getScGrpResLockYn()
    {
        return $this->scGrpResLockYn;
    }

    /**
     * Set scGrpResLockDays
     *
     * @param integer $scGrpResLockDays
     *
     * @return ScGroup
     */
    public function setScGrpResLockDays($scGrpResLockDays)
    {
        $this->scGrpResLockDays = $scGrpResLockDays;

        return $this;
    }

    /**
     * Get scGrpResLockDays
     *
     * @return integer
     */
    public function getScGrpResLockDays()
    {
        return $this->scGrpResLockDays;
    }

    /**
     * Set scGrpResLockInd
     *
     * @param boolean $scGrpResLockInd
     *
     * @return ScGroup
     */
    public function setScGrpResLockInd($scGrpResLockInd)
    {
        $this->scGrpResLockInd = $scGrpResLockInd;

        return $this;
    }

    /**
     * Get scGrpResLockInd
     *
     * @return boolean
     */
    public function getScGrpResLockInd()
    {
        return $this->scGrpResLockInd;
    }

    /**
     * Set scGrpResStatusUnallocYn
     *
     * @param boolean $scGrpResStatusUnallocYn
     *
     * @return ScGroup
     */
    public function setScGrpResStatusUnallocYn($scGrpResStatusUnallocYn)
    {
        $this->scGrpResStatusUnallocYn = $scGrpResStatusUnallocYn;

        return $this;
    }

    /**
     * Get scGrpResStatusUnallocYn
     *
     * @return boolean
     */
    public function getScGrpResStatusUnallocYn()
    {
        return $this->scGrpResStatusUnallocYn;
    }

    /**
     * Set scGrpResStatusAllocYn
     *
     * @param boolean $scGrpResStatusAllocYn
     *
     * @return ScGroup
     */
    public function setScGrpResStatusAllocYn($scGrpResStatusAllocYn)
    {
        $this->scGrpResStatusAllocYn = $scGrpResStatusAllocYn;

        return $this;
    }

    /**
     * Get scGrpResStatusAllocYn
     *
     * @return boolean
     */
    public function getScGrpResStatusAllocYn()
    {
        return $this->scGrpResStatusAllocYn;
    }

    /**
     * Set scGrpResVoidInvoiceYn
     *
     * @param boolean $scGrpResVoidInvoiceYn
     *
     * @return ScGroup
     */
    public function setScGrpResVoidInvoiceYn($scGrpResVoidInvoiceYn)
    {
        $this->scGrpResVoidInvoiceYn = $scGrpResVoidInvoiceYn;

        return $this;
    }

    /**
     * Get scGrpResVoidInvoiceYn
     *
     * @return boolean
     */
    public function getScGrpResVoidInvoiceYn()
    {
        return $this->scGrpResVoidInvoiceYn;
    }

    /**
     * Set scGrpResVoidPaymentYn
     *
     * @param boolean $scGrpResVoidPaymentYn
     *
     * @return ScGroup
     */
    public function setScGrpResVoidPaymentYn($scGrpResVoidPaymentYn)
    {
        $this->scGrpResVoidPaymentYn = $scGrpResVoidPaymentYn;

        return $this;
    }

    /**
     * Get scGrpResVoidPaymentYn
     *
     * @return boolean
     */
    public function getScGrpResVoidPaymentYn()
    {
        return $this->scGrpResVoidPaymentYn;
    }

    /**
     * Set scGrpCrossInvoiceYn
     *
     * @param boolean $scGrpCrossInvoiceYn
     *
     * @return ScGroup
     */
    public function setScGrpCrossInvoiceYn($scGrpCrossInvoiceYn)
    {
        $this->scGrpCrossInvoiceYn = $scGrpCrossInvoiceYn;

        return $this;
    }

    /**
     * Get scGrpCrossInvoiceYn
     *
     * @return boolean
     */
    public function getScGrpCrossInvoiceYn()
    {
        return $this->scGrpCrossInvoiceYn;
    }

    /**
     * Set scGrpResOvrRateTypeYn
     *
     * @param boolean $scGrpResOvrRateTypeYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrRateTypeYn($scGrpResOvrRateTypeYn)
    {
        $this->scGrpResOvrRateTypeYn = $scGrpResOvrRateTypeYn;

        return $this;
    }

    /**
     * Get scGrpResOvrRateTypeYn
     *
     * @return boolean
     */
    public function getScGrpResOvrRateTypeYn()
    {
        return $this->scGrpResOvrRateTypeYn;
    }

    /**
     * Set scGrpResOvrAmountYn
     *
     * @param boolean $scGrpResOvrAmountYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrAmountYn($scGrpResOvrAmountYn)
    {
        $this->scGrpResOvrAmountYn = $scGrpResOvrAmountYn;

        return $this;
    }

    /**
     * Get scGrpResOvrAmountYn
     *
     * @return boolean
     */
    public function getScGrpResOvrAmountYn()
    {
        return $this->scGrpResOvrAmountYn;
    }

    /**
     * Set scGrpResOvrVarianceYn
     *
     * @param boolean $scGrpResOvrVarianceYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrVarianceYn($scGrpResOvrVarianceYn)
    {
        $this->scGrpResOvrVarianceYn = $scGrpResOvrVarianceYn;

        return $this;
    }

    /**
     * Get scGrpResOvrVarianceYn
     *
     * @return boolean
     */
    public function getScGrpResOvrVarianceYn()
    {
        return $this->scGrpResOvrVarianceYn;
    }

    /**
     * Set scGrpResOvrOverbookingYn
     *
     * @param boolean $scGrpResOvrOverbookingYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrOverbookingYn($scGrpResOvrOverbookingYn)
    {
        $this->scGrpResOvrOverbookingYn = $scGrpResOvrOverbookingYn;

        return $this;
    }

    /**
     * Get scGrpResOvrOverbookingYn
     *
     * @return boolean
     */
    public function getScGrpResOvrOverbookingYn()
    {
        return $this->scGrpResOvrOverbookingYn;
    }

    /**
     * Set scGrpResOvrSpecialsYn
     *
     * @param boolean $scGrpResOvrSpecialsYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrSpecialsYn($scGrpResOvrSpecialsYn)
    {
        $this->scGrpResOvrSpecialsYn = $scGrpResOvrSpecialsYn;

        return $this;
    }

    /**
     * Get scGrpResOvrSpecialsYn
     *
     * @return boolean
     */
    public function getScGrpResOvrSpecialsYn()
    {
        return $this->scGrpResOvrSpecialsYn;
    }

    /**
     * Set scGrpResOvrTotalPaxYn
     *
     * @param boolean $scGrpResOvrTotalPaxYn
     *
     * @return ScGroup
     */
    public function setScGrpResOvrTotalPaxYn($scGrpResOvrTotalPaxYn)
    {
        $this->scGrpResOvrTotalPaxYn = $scGrpResOvrTotalPaxYn;

        return $this;
    }

    /**
     * Get scGrpResOvrTotalPaxYn
     *
     * @return boolean
     */
    public function getScGrpResOvrTotalPaxYn()
    {
        return $this->scGrpResOvrTotalPaxYn;
    }

    /**
     * Set scGrpResSpApplyAutoYn
     *
     * @param boolean $scGrpResSpApplyAutoYn
     *
     * @return ScGroup
     */
    public function setScGrpResSpApplyAutoYn($scGrpResSpApplyAutoYn)
    {
        $this->scGrpResSpApplyAutoYn = $scGrpResSpApplyAutoYn;

        return $this;
    }

    /**
     * Get scGrpResSpApplyAutoYn
     *
     * @return boolean
     */
    public function getScGrpResSpApplyAutoYn()
    {
        return $this->scGrpResSpApplyAutoYn;
    }

    /**
     * Set scGrpResSpApplyManYn
     *
     * @param boolean $scGrpResSpApplyManYn
     *
     * @return ScGroup
     */
    public function setScGrpResSpApplyManYn($scGrpResSpApplyManYn)
    {
        $this->scGrpResSpApplyManYn = $scGrpResSpApplyManYn;

        return $this;
    }

    /**
     * Get scGrpResSpApplyManYn
     *
     * @return boolean
     */
    public function getScGrpResSpApplyManYn()
    {
        return $this->scGrpResSpApplyManYn;
    }

     /**
     * Set scGrpResWetuYn
     *
     * @param boolean $scGrpResWetuYn
     *
     * @return ScGroup
     */
    public function setScGrpResWetuYn($scGrpResWetuYn)
    {
        $this->scGrpResWetuYn = $scGrpResWetuYn;

        return $this;
    }

    /**
     * Get scGrpResWetuYn
     *
     * @return boolean
     */
    public function GetScGrpResWetuYn()
    {
        return $this->scGrpResWetuYn;
    }

    /**
     * Set scGrpSysCode
     *
     * @param boolean $scGrpSysCode
     *
     * @return ScGroup
     */
    public function setScGrpSysCode($scGrpSysCode)
    {
        $this->scGrpSysCode = $scGrpSysCode;

        return $this;
    }

    /**
     * Get scGrpSysCode
     *
     * @return boolean
     */
    public function getScGrpSysCode()
    {
        return $this->scGrpSysCode;
    }

    /**
     * Set scGrpInactiveYn
     *
     * @param boolean $scGrpInactiveYn
     *
     * @return ScGroup
     */
    public function setScGrpInactiveYn($scGrpInactiveYn)
    {
        $this->scGrpInactiveYn = $scGrpInactiveYn;

        return $this;
    }

    /**
     * Get scGrpInactiveYn
     *
     * @return boolean
     */
    public function getScGrpInactiveYn()
    {
        return $this->scGrpInactiveYn;
    }
    
    /**
     * Set scGrpResEditDetailsYn
     *
     * @param boolean $scGrpResEditDetailsYn
     *
     * @return ScGroup
     */
    public function setScGrpResEditDetailsYn($scGrpResEditDetailsYn)
    {
        $this->scGrpResEditDetailsYn = $scGrpResEditDetailsYn;

        return $this;
    }

    /**
     * Get scGrpResEditDetailsYn
     *
     * @return boolean
     */
    public function getScGrpResEditDetailsYn()
    {
        return $this->scGrpResEditDetailsYn;
    }

    /**
     * Set scGrpResEditItinerariesYn
     *
     * @param boolean $scGrpResEditItinerariesYn
     *
     * @return ScGroup
     */
    public function setScGrpResEditItinerariesYn($scGrpResEditItinerariesYn)
    {
        $this->scGrpResEditItinerariesYn = $scGrpResEditItinerariesYn;

        return $this;
    }

    /**
     * Get scGrpResEditItinerariesYn
     *
     * @return boolean
     */
    public function getScGrpResEditItinerariesYn()
    {
        return $this->scGrpResEditItinerariesYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scGroupTrfYn
     *
     * @param boolean $scGroupTrfYn
     *
     * @return ScGroup
     */
    public function setScGroupTrfYn($scGroupTrfYn)
    {
        $this->scGroupTrfYn = $scGroupTrfYn;

        return $this;
    }

    /**
     * Get scGroupTrfYn
     *
     * @return boolean
     */
    public function getScGroupTrfYn()
    {
        return $this->scGroupTrfYn;
    }
}
