<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScJob
 *
 * @ORM\Table(name="sc_job", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_job_trf_yn", columns={"sc_job_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScJob
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_job_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $scJobId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="sc_job_desc", type="text", length=65535, nullable=true)
     */
    private $scJobDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_job_level", type="boolean", nullable=false, options={"default"="99"})
     */
    private $scJobLevel = '99';

    /**
     * @var string
     *
     * @ORM\Column(name="sc_job_cords", type="text", length=65535, nullable=false)
     */
    private $scJobCords;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_job_homepage_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scJobHomepageYn = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_job_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scJobTrfYn = '0';



    /**
     * Set scJobId
     *
     * @param integer $scJobId
     *
     * @return ScJob
     */
    public function setScJobId($scJobId)
    {
        $this->scJobId = $scJobId;

        return $this;
    }

    /**
     * Get scJobId
     *
     * @return integer
     */
    public function getScJobId()
    {
        return $this->scJobId;
    }

    /**
     * Set scJobDesc
     *
     * @param string $scJobDesc
     *
     * @return ScJob
     */
    public function setScJobDesc($scJobDesc)
    {
        $this->scJobDesc = $scJobDesc;

        return $this;
    }

    /**
     * Get scJobDesc
     *
     * @return string
     */
    public function getScJobDesc()
    {
        return $this->scJobDesc;
    }

    /**
     * Set scJobLevel
     *
     * @param boolean $scJobLevel
     *
     * @return ScJob
     */
    public function setScJobLevel($scJobLevel)
    {
        $this->scJobLevel = $scJobLevel;

        return $this;
    }

    /**
     * Get scJobLevel
     *
     * @return boolean
     */
    public function getScJobLevel()
    {
        return $this->scJobLevel;
    }

    /**
     * Set scJobCords
     *
     * @param string $scJobCords
     *
     * @return ScJob
     */
    public function setScJobCords($scJobCords)
    {
        $this->scJobCords = $scJobCords;

        return $this;
    }

    /**
     * Get scJobCords
     *
     * @return string
     */
    public function getScJobCords()
    {
        return $this->scJobCords;
    }

    /**
     * Set scJobHomepageYn
     *
     * @param boolean $scJobHomepageYn
     *
     * @return ScJob
     */
    public function setScJobHomepageYn($scJobHomepageYn)
    {
        $this->scJobHomepageYn = $scJobHomepageYn;

        return $this;
    }

    /**
     * Get scJobHomepageYn
     *
     * @return boolean
     */
    public function getScJobHomepageYn()
    {
        return $this->scJobHomepageYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScJob
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scJobTrfYn
     *
     * @param boolean $scJobTrfYn
     *
     * @return ScJob
     */
    public function setScJobTrfYn($scJobTrfYn)
    {
        $this->scJobTrfYn = $scJobTrfYn;

        return $this;
    }

    /**
     * Get scJobTrfYn
     *
     * @return boolean
     */
    public function getScJobTrfYn()
    {
        return $this->scJobTrfYn;
    }
}
