<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScMenu
 *
 * @ORM\Table(name="sc_menu", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_menu_trf_yn", columns={"sc_menu_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScMenu
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scMenuId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_job_top", type="integer", nullable=true)
     */
    private $scMenuJobTop;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_menu_param", type="string", length=100, nullable=true, options={"fixed"="true"})
     */
    private $scMenuParam;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_parent", type="integer", nullable=false, options={"default"="0"})
     */
    private $scMenuParent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_menu_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scMenuSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_menu_title", type="string", length=50, nullable=true, options={"fixed"="true"})
     */
    private $scMenuTitle;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_function_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $scFunctionId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_job_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $scJobId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_format_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $scMenuFormatId;

     /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_menu_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scMenuTrfYn;



    /**
     * Get scMenuId
     *
     * @return integer
     */
    public function getScMenuId()
    {
        return $this->scMenuId;
    }

    /**
     * Set scMenuJobTop
     *
     * @param integer $scMenuJobTop
     *
     * @return ScMenu
     */
    public function setScMenuJobTop($scMenuJobTop)
    {
        $this->scMenuJobTop = $scMenuJobTop;

        return $this;
    }

    /**
     * Get scMenuJobTop
     *
     * @return integer
     */
    public function getScMenuJobTop()
    {
        return $this->scMenuJobTop;
    }

    /**
     * Set scMenuParam
     *
     * @param string $scMenuParam
     *
     * @return ScMenu
     */
    public function setScMenuParam($scMenuParam)
    {
        $this->scMenuParam = $scMenuParam;

        return $this;
    }

    /**
     * Get scMenuParam
     *
     * @return string
     */
    public function getScMenuParam()
    {
        return $this->scMenuParam;
    }

    /**
     * Set scMenuParent
     *
     * @param integer $scMenuParent
     *
     * @return ScMenu
     */
    public function setScMenuParent($scMenuParent)
    {
        $this->scMenuParent = $scMenuParent;

        return $this;
    }

    /**
     * Get scMenuParent
     *
     * @return integer
     */
    public function getScMenuParent()
    {
        return $this->scMenuParent;
    }

    /**
     * Set scMenuSeq
     *
     * @param boolean $scMenuSeq
     *
     * @return ScMenu
     */
    public function setScMenuSeq($scMenuSeq)
    {
        $this->scMenuSeq = $scMenuSeq;

        return $this;
    }

    /**
     * Get scMenuSeq
     *
     * @return boolean
     */
    public function getScMenuSeq()
    {
        return $this->scMenuSeq;
    }

    /**
     * Set scMenuTitle
     *
     * @param string $scMenuTitle
     *
     * @return ScMenu
     */
    public function setScMenuTitle($scMenuTitle)
    {
        $this->scMenuTitle = $scMenuTitle;

        return $this;
    }

    /**
     * Get scMenuTitle
     *
     * @return string
     */
    public function getScMenuTitle()
    {
        return $this->scMenuTitle;
    }

    /**
     * Set scFunctionId
     *
     * @param integer $scFunctionId
     *
     * @return ScMenu
     */
    public function setScFunctionId($scFunctionId)
    {
        $this->scFunctionId = $scFunctionId;

        return $this;
    }

    /**
     * Get scFunctionId
     *
     * @return integer
     */
    public function getScFunctionId()
    {
        return $this->scFunctionId;
    }

    /**
     * Set scJobId
     *
     * @param integer $scJobId
     *
     * @return ScMenu
     */
    public function setScJobId($scJobId)
    {
        $this->scJobId = $scJobId;

        return $this;
    }

    /**
     * Get scJobId
     *
     * @return integer
     */
    public function getScJobId()
    {
        return $this->scJobId;
    }

    /**
     * Set scMenuFormatId
     *
     * @param integer $scMenuFormatId
     *
     * @return ScMenu
     */
    public function setScMenuFormatId($scMenuFormatId)
    {
        $this->scMenuFormatId = $scMenuFormatId;

        return $this;
    }

    /**
     * Get scMenuFormatId
     *
     * @return integer
     */
    public function getScMenuFormatId()
    {
        return $this->scMenuFormatId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScMenu
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scMenuTrfYn
     *
     * @param boolean $scMenuTrfYn
     *
     * @return ScMenu
     */
    public function setScMenuTrfYn($scMenuTrfYn)
    {
        $this->scMenuTrfYn = $scMenuTrfYn;

        return $this;
    }

    /**
     * Get scMenuTrfYn
     *
     * @return boolean
     */
    public function getScMenuTrfYn()
    {
        return $this->scMenuTrfYn;
    }
}
