<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScMenuFormat
 *
 * @ORM\Table(name="sc_menu_format", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_menu_format_trf_yn", columns={"sc_menu_format_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScMenuFormat
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_format_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scMenuFormatId;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_menu_format_desc", type="text", length=65535, nullable=true)
     */
    private $scMenuFormatDesc;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_format_width", type="integer", nullable=false, options={"default"="0"})
     */
    private $scMenuFormatWidth;

     /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_menu_format_height", type="integer", nullable=false, options={"default"="0"})
     */
    private $scMenuFormatHeight;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_menu_format_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scMenuFormatTrfYn;



    /**
     * Get scMenuFormatId
     *
     * @return integer
     */
    public function getScMenuFormatId()
    {
        return $this->scMenuFormatId;
    }

    /**
     * Set scMenuFormatDesc
     *
     * @param string $scMenuFormatDesc
     *
     * @return ScMenuFormat
     */
    public function setScMenuFormatDesc($scMenuFormatDesc)
    {
        $this->scMenuFormatDesc = $scMenuFormatDesc;

        return $this;
    }

    /**
     * Get scMenuFormatDesc
     *
     * @return string
     */
    public function getScMenuFormatDesc()
    {
        return $this->scMenuFormatDesc;
    }

    /**
     * Set scMenuFormatWidth
     *
     * @param integer $scMenuFormatWidth
     *
     * @return ScMenuFormat
     */
    public function setScMenuFormatWidth($scMenuFormatWidth)
    {
        $this->scMenuFormatWidth = $scMenuFormatWidth;

        return $this;
    }

    /**
     * Get scMenuFormatWidth
     *
     * @return integer
     */
    public function getScMenuFormatWidth()
    {
        return $this->scMenuFormatWidth;
    }

    /**
     * Set scMenuFormatHeight
     *
     * @param integer $scMenuFormatHeight
     *
     * @return ScMenuFormat
     */
    public function setScMenuFormatHeight($scMenuFormatHeight)
    {
        $this->scMenuFormatHeight = $scMenuFormatHeight;

        return $this;
    }

    /**
     * Get scMenuFormatHeight
     *
     * @return integer
     */
    public function getScMenuFormatHeight()
    {
        return $this->scMenuFormatHeight;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RvExtraTax
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scMenuFormatTrfYn
     *
     * @param boolean $scMenuFormatTrfYn
     *
     * @return ScMenuFormat
     */
    public function setScMenuFormatTrfYn($scMenuFormatTrfYn)
    {
        $this->scMenuFormatTrfYn = $scMenuFormatTrfYn;

        return $this;
    }

    /**
     * Get scMenuFormatTrfYn
     *
     * @return boolean
     */
    public function getScMenuFormatTrfYn()
    {
        return $this->scMenuFormatTrfYn;
    }
}
