<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScRoute
 *
 * @ORM\Table(name="sc_route", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class ScRoute
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_route_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scRouteId;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_route_name", type="string", length=2083, nullable=true)
     */
    private $scRouteName;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_route_desc", type="string", length=50, nullable=true, options={"fixed"="true"})
     */
    private $scRouteDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_route_level", type="integer", nullable=false, options={"default"="0"})
     */
    private $scRouteLevel = '0';

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_route_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scRouteTrfYn = '0';



    /**
     * Get scRouteId
     *
     * @return integer
     */
    public function getScRouteId()
    {
        return $this->scRouteId;
    }

    /**
     * Set scRouteName
     *
     * @param string $scRouteName
     *
     * @return ScRoute
     */
    public function setScRouteName($scRouteName)
    {
        $this->scRouteName = $scRouteName;

        return $this;
    }

    /**
     * Get scRouteName
     *
     * @return string
     */
    public function getScRouteName()
    {
        return $this->scRouteName;
    }

    /**
     * Set scRouteDesc
     *
     * @param string $scRouteDesc
     *
     * @return ScRoute
     */
    public function setScRouteDesc($scRouteDesc)
    {
        $this->scRouteDesc = $scRouteDesc;

        return $this;
    }

    /**
     * Get scRouteDesc
     *
     * @return string
     */
    public function getScRouteDesc()
    {
        return $this->scRouteDesc;
    }

    /**
     * Set scRouteLevel
     *
     * @param boolean $scRouteLevel
     *
     * @return ScRoute
     */
    public function setScRouteLevel($scRouteLevel)
    {
        $this->scRouteLevel = $scRouteLevel;

        return $this;
    }

    /**
     * Get scRouteLevel
     *
     * @return boolean
     */
    public function getScRouteLevel()
    {
        return $this->scRouteLevel;
    }

    /**
     * Set scRouteTrfYn
     *
     * @param boolean $scRouteTrfYn
     *
     * @return ScRoute
     */
    public function setScRouteTrfYn($scRouteTrfYn)
    {
        $this->scRouteTrfYn = $scRouteTrfYn;

        return $this;
    }

    /**
     * Get scRouteTrfYn
     *
     * @return boolean
     */
    public function getscRouteTrfYn()
    {
        return $this->scRouteTrfYn;
    }
}
