<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScTransfer
 *
 * @ORM\Table(name="sc_transfer", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class ScTransfer
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_transfer_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $scTransferId;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_trf_message", type="text", length=65535, nullable=false)
     */
    private $scTrfMessage;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_trf_status", type="boolean", nullable=true)
     */
    private $scTrfStatus;



    /**
     * Get scTransferId
     *
     * @return integer
     */
    public function getScTransferId()
    {
        return $this->scTransferId;
    }

    /**
     * Set scTrfMessage
     *
     * @param string $scTrfMessage
     *
     * @return ScTransfer
     */
    public function setScTrfMessage($scTrfMessage)
    {
        $this->scTrfMessage = $scTrfMessage;

        return $this;
    }

    /**
     * Get scTrfMessage
     *
     * @return string
     */
    public function getScTrfMessage()
    {
        return $this->scTrfMessage;
    }

    /**
     * Set scTrfStatus
     *
     * @param boolean $scTrfStatus
     *
     * @return ScTransfer
     */
    public function setScTrfStatus($scTrfStatus)
    {
        $this->scTrfStatus = $scTrfStatus;

        return $this;
    }

    /**
     * Get scTrfStatus
     *
     * @return boolean
     */
    public function getScTrfStatus()
    {
        return $this->scTrfStatus;
    }
}
