<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ScUser
 *
 * @ORM\Table(name="sc_user", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sc_user_trf_yn", columns={"sc_user_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ScUser
{
    /**
     * @var integer
     *
     * @ORM\Column(name="sc_user_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $scUserId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_group_id", type="integer", nullable=true)
     */
    private $scGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sc_user_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $scUserTrfYn;



    /**
     * Get scUserId
     *
     * @return integer
     */
    public function getScUserId()
    {
        return $this->scUserId;
    }

    /**
     * Set scGroupId
     *
     * @param integer $scGroupId
     *
     * @return ScUser
     */
    public function setScGroupId($scGroupId)
    {
        $this->scGroupId = $scGroupId;

        return $this;
    }

    /**
     * Get scGroupId
     *
     * @return integer
     */
    public function getScGroupId()
    {
        return $this->scGroupId;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return ScUser
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ScUser
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set scUserTrfYn
     *
     * @param boolean $scUserTrfYn
     *
     * @return ScUser
     */
    public function setScUserTrfYn($scUserTrfYn)
    {
        $this->scUserTrfYn = $scUserTrfYn;

        return $this;
    }

    /**
     * Get scUserTrfYn
     *
     * @return boolean
     */
    public function getScUserTrfYn()
    {
        return $this->scUserTrfYn;
    }
}
