<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpPropRateGroup
 *
 * @ORM\Table(name="sp_prop_rate_group", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sp_prop_rate_group_trf_yn", columns={"sp_prop_rate_group_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class SpPropRateGroup
{
    /**
     * @var string
     *
     * @ORM\Column(name="sp_prop_rate_group_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $spPropRateGroupIx;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_prop_rate_group_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $spPropRateGroupDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_prop_rate_group_id", type="integer", nullable=false)
     */
    private $spPropRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupNights;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_bed_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupBedNights;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_prop_rate_group_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spPropRateGroupTrfYn;



    /**
     * Get spPropRateGroupIx
     *
     * @return string
     */
    public function getSpPropRateGroupIx()
    {
        return $this->spPropRateGroupIx;
    }

    /**
     * Set spPropRateGroupDb
     *
     * @param string $spPropRateGroupDb
     *
     * @return SpPropRateGroup
     */
    public function setSpPropRateGroupDb($spPropRateGroupDb)
    {
        $this->spPropRateGroupDb = $spPropRateGroupDb;

        return $this;
    }

    /**
     * Get spPropRateGroupDb
     *
     * @return string
     */
    public function getSpPropRateGroupDb()
    {
        return $this->spPropRateGroupDb;
    }

    /**
     * Set spPropRateGroupId
     *
     * @param integer $spPropRateGroupId
     *
     * @return SpPropRateGroup
     */
    public function setSpPropRateGroupId($spPropRateGroupId)
    {
        $this->spPropRateGroupId = $spPropRateGroupId;

        return $this;
    }

    /**
     * Get spPropRateGroupId
     *
     * @return integer
     */
    public function getSpPropRateGroupId()
    {
        return $this->spPropRateGroupId;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return SpPropRateGroup
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return SpPropRateGroup
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return SpPropRateGroup
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set spRateGroupCount
     *
     * @param integer $spRateGroupCount
     *
     * @return SpPropRateGroup
     */
    public function setSpRateGroupCount($spRateGroupCount)
    {
        $this->spRateGroupCount = $spRateGroupCount;

        return $this;
    }

    /**
     * Get spRateGroupCount
     *
     * @return integer
     */
    public function getSpRateGroupCount()
    {
        return $this->spRateGroupCount;
    }

    /**
     * Set spRateGroupNights
     *
     * @param integer $spRateGroupNights
     *
     * @return SpPropRateGroup
     */
    public function setSpRateGroupNights($spRateGroupNights)
    {
        $this->spRateGroupNights = $spRateGroupNights;

        return $this;
    }

    /**
     * Get spRateGroupNights
     *
     * @return integer
     */
    public function getSpRateGroupNights()
    {
        return $this->spRateGroupNights;
    }

    /**
     * Set spRateGroupBedNights
     *
     * @param integer $spRateGroupBedNights
     *
     * @return SpPropRateGroup
     */
    public function setSpRateGroupBedNights($spRateGroupBedNights)
    {
        $this->spRateGroupBedNights = $spRateGroupBedNights;

        return $this;
    }

    /**
     * Get spRateGroupBedNights
     *
     * @return integer
     */
    public function getSpRateGroupBedNights()
    {
        return $this->spRateGroupBedNights;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return SpPropRateGroup
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return SpPropRateGroup
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return SpPropRateGroup
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return SpPropRateGroup
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return SpPropRateGroup
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return SpPropRateGroup
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return SpPropRateGroup
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return SpPropRateGroup
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return SpPropRateGroup
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return SpPropRateGroup
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set spPropRateGroupTrfYn
     *
     * @param boolean $spPropRateGroupTrfYn
     *
     * @return SpPropRateGroup
     */
    public function setSpPropRateGroupTrfYn($spPropRateGroupTrfYn)
    {
        $this->spPropRateGroupTrfYn = $spPropRateGroupTrfYn;

        return $this;
    }

    /**
     * Get spPropRateGroupTrfYn
     *
     * @return boolean
     */
    public function getSpPropRateGroupTrfYn()
    {
        return $this->spPropRateGroupTrfYn;
    }
}
