<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpRateGroupBenefit
 *
 * @ORM\Table(name="sp_rate_group_benefit", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="sp_rate_group_benefit_trf_yn", columns={"sp_rate_group_benefit_trf_yn"})})
 * @ORM\Entity
 */
class SpRateGroupBenefit
{
    /**
     * @var string
     *
     * @ORM\Column(name="sp_rate_group_benefit_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $spRateGroupBenefitIx;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_rate_group_benefit_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $spRateGroupBenefitDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_benefit_id", type="integer", nullable=false)
     */
    private $spRateGroupBenefitId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_discount_donor_property_id", type="string", length=36, nullable=true)
     */
    private $spDiscountDonorPropertyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_recipients", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupRecipients;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_discount_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spDiscountNights;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_discount_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $spDiscountPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_discount_amount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $spDiscountAmount;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_free_nights_qty", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spFreeNightsQty;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_free_nights_rate_type", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $spFreeNightsRateType;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_rate_group_benefit_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spRateGroupBenefitTrfYn;



    /**
     * Get spRateGroupBenefitIx
     *
     * @return string
     */
    public function getSpRateGroupBenefitIx()
    {
        return $this->spRateGroupBenefitIx;
    }

    /**
     * Set spRateGroupBenefitDb
     *
     * @param string $spRateGroupBenefitDb
     *
     * @return SpRateGroupBenefit
     */
    public function setSpRateGroupBenefitDb($spRateGroupBenefitDb)
    {
        $this->spRateGroupBenefitDb = $spRateGroupBenefitDb;

        return $this;
    }

    /**
     * Get spRateGroupBenefitDb
     *
     * @return string
     */
    public function getSpRateGroupBenefitDb()
    {
        return $this->spRateGroupBenefitDb;
    }

    /**
     * Set spRateGroupBenefitId
     *
     * @param integer $spRateGroupBenefitId
     *
     * @return SpRateGroupBenefit
     */
    public function setSpRateGroupBenefitId($spRateGroupBenefitId)
    {
        $this->spRateGroupBenefitId = $spRateGroupBenefitId;

        return $this;
    }

    /**
     * Get spRateGroupBenefitId
     *
     * @return integer
     */
    public function getSpRateGroupBenefitId()
    {
        return $this->spRateGroupBenefitId;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return SpRateGroupBenefit
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return SpRateGroupBenefit
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set spDiscountDonorPropertyId
     *
     * @param string $spDiscountDonorPropertyId
     *
     * @return SpRateGroupBenefit
     */
    public function setSpDiscountDonorPropertyId($spDiscountDonorPropertyId)
    {
        $this->spDiscountDonorPropertyId = $spDiscountDonorPropertyId;

        return $this;
    }

    /**
     * Get spDiscountDonorPropertyId
     *
     * @return string
     */
    public function getSpDiscountDonorPropertyId()
    {
        return $this->spDiscountDonorPropertyId;
    }

    /**
     * Set spRateGroupRecipients
     *
     * @param integer $spRateGroupRecipients
     *
     * @return SpRateGroupBenefit
     */
    public function setSpRateGroupRecipients($spRateGroupRecipients)
    {
        $this->spRateGroupRecipients = $spRateGroupRecipients;

        return $this;
    }

    /**
     * Get spRateGroupRecipients
     *
     * @return integer
     */
    public function getSpRateGroupRecipients()
    {
        return $this->spRateGroupRecipients;
    }

    /**
     * Set spDiscountNights
     *
     * @param integer $spDiscountNights
     *
     * @return SpRateGroupBenefit
     */
    public function setSpDiscountNights($spDiscountNights)
    {
        $this->spDiscountNights = $spDiscountNights;

        return $this;
    }

    /**
     * Get spDiscountNights
     *
     * @return integer
     */
    public function getSpDiscountNights()
    {
        return $this->spDiscountNights;
    }

    /**
     * Set spDiscountPerc
     *
     * @param string $spDiscountPerc
     *
     * @return SpRateGroupBenefit
     */
    public function setSpDiscountPerc($spDiscountPerc)
    {
        $this->spDiscountPerc = $spDiscountPerc;

        return $this;
    }

    /**
     * Get spDiscountPerc
     *
     * @return string
     */
    public function getSpDiscountPerc()
    {
        return $this->spDiscountPerc;
    }

    /**
     * Set spDiscountAmount
     *
     * @param string $spDiscountAmount
     *
     * @return SpRateGroupBenefit
     */
    public function setSpDiscountAmount($spDiscountAmount)
    {
        $this->spDiscountAmount = $spDiscountAmount;

        return $this;
    }

    /**
     * Get spDiscountAmount
     *
     * @return string
     */
    public function getSpDiscountAmount()
    {
        return $this->spDiscountAmount;
    }

    /**
     * Set spFreeNightsQty
     *
     * @param integer $spFreeNightsQty
     *
     * @return SpRateGroupBenefit
     */
    public function setSpFreeNightsQty($spFreeNightsQty)
    {
        $this->spFreeNightsQty = $spFreeNightsQty;

        return $this;
    }

    /**
     * Get spFreeNightsQty
     *
     * @return integer
     */
    public function getSpFreeNightsQty()
    {
        return $this->spFreeNightsQty;
    }

    /**
     * Set spFreeNightsRateType
     *
     * @param string $spFreeNightsRateType
     *
     * @return SpRateGroupBenefit
     */
    public function setSpFreeNightsRateType($spFreeNightsRateType)
    {
        $this->spFreeNightsRateType = $spFreeNightsRateType;

        return $this;
    }

    /**
     * Get spFreeNightsRateType
     *
     * @return string
     */
    public function getSpFreeNightsRateType()
    {
        return $this->spFreeNightsRateType;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return SpRateGroupBenefit
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return SpRateGroupBenefit
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return SpRateGroupBenefit
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return SpRateGroupBenefit
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return SpRateGroupBenefit
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return SpRateGroupBenefit
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return SpRateGroupBenefit
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return SpRateGroupBenefit
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return SpRateGroupBenefit
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return SpRateGroupBenefit
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set spRateGroupBenefitTrfYn
     *
     * @param boolean $spRateGroupBenefitTrfYn
     *
     * @return SpRateGroupBenefit
     */
    public function setSpRateGroupBenefitTrfYn($spRateGroupBenefitTrfYn)
    {
        $this->spRateGroupBenefitTrfYn = $spRateGroupBenefitTrfYn;

        return $this;
    }

    /**
     * Get spRateGroupBenefitTrfYn
     *
     * @return boolean
     */
    public function getSpRateGroupBenefitTrfYn()
    {
        return $this->spRateGroupBenefitTrfYn;
    }
}
