<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpRateGroupQualify
 *
 * @ORM\Table(name="sp_rate_group_qualify", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sp_rate_group_qualify_trf_yn", columns={"sp_rate_group_qualify_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class SpRateGroupQualify
{
    /**
     * @var string
     *
     * @ORM\Column(name="sp_rate_group_qualify_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $spRateGroupQualifyIx;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_rate_group_qualify_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $spRateGroupQualifyDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_qualify_id", type="integer", nullable=false)
     */
    private $spRateGroupQualifyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupNights;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_rate_group_bed_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $spRateGroupBedNights;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_rate_group_qualify_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spRateGroupQualifyTrfYn;



    /**
     * Get spRateGroupQualifyIx
     *
     * @return string
     */
    public function getSpRateGroupQualifyIx()
    {
        return $this->spRateGroupQualifyIx;
    }

    /**
     * Set spRateGroupQualifyDb
     *
     * @param string $spRateGroupQualifyDb
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupQualifyDb($spRateGroupQualifyDb)
    {
        $this->spRateGroupQualifyDb = $spRateGroupQualifyDb;

        return $this;
    }

    /**
     * Get spRateGroupQualifyDb
     *
     * @return string
     */
    public function getSpRateGroupQualifyDb()
    {
        return $this->spRateGroupQualifyDb;
    }

    /**
     * Set spRateGroupQualifyId
     *
     * @param integer $spRateGroupQualifyId
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupQualifyId($spRateGroupQualifyId)
    {
        $this->spRateGroupQualifyId = $spRateGroupQualifyId;

        return $this;
    }

    /**
     * Get spRateGroupQualifyId
     *
     * @return integer
     */
    public function getSpRateGroupQualifyId()
    {
        return $this->spRateGroupQualifyId;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return SpRateGroupQualify
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return SpRateGroupQualify
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set spRateGroupCount
     *
     * @param integer $spRateGroupCount
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupCount($spRateGroupCount)
    {
        $this->spRateGroupCount = $spRateGroupCount;

        return $this;
    }

    /**
     * Get spRateGroupCount
     *
     * @return integer
     */
    public function getSpRateGroupCount()
    {
        return $this->spRateGroupCount;
    }

    /**
     * Set spRateGroupNights
     *
     * @param integer $spRateGroupNights
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupNights($spRateGroupNights)
    {
        $this->spRateGroupNights = $spRateGroupNights;

        return $this;
    }

    /**
     * Get spRateGroupNights
     *
     * @return integer
     */
    public function getSpRateGroupNights()
    {
        return $this->spRateGroupNights;
    }

    /**
     * Set spRateGroupBedNights
     *
     * @param integer $spRateGroupBedNights
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupBedNights($spRateGroupBedNights)
    {
        $this->spRateGroupBedNights = $spRateGroupBedNights;

        return $this;
    }

    /**
     * Get spRateGroupBedNights
     *
     * @return integer
     */
    public function getSpRateGroupBedNights()
    {
        return $this->spRateGroupBedNights;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return SpRateGroupQualify
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return SpRateGroupQualify
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return SpRateGroupQualify
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return SpRateGroupQualify
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return SpRateGroupQualify
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return SpRateGroupQualify
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return SpRateGroupQualify
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return SpRateGroupQualify
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return SpRateGroupQualify
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return SpRateGroupQualify
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set spRateGroupQualifyTrfYn
     *
     * @param boolean $spRateGroupQualifyTrfYn
     *
     * @return SpRateGroupQualify
     */
    public function setSpRateGroupQualifyTrfYn($spRateGroupQualifyTrfYn)
    {
        $this->spRateGroupQualifyTrfYn = $spRateGroupQualifyTrfYn;

        return $this;
    }

    /**
     * Get spRateGroupQualifyTrfYn
     *
     * @return boolean
     */
    public function getSpRateGroupQualifyTrfYn()
    {
        return $this->spRateGroupQualifyTrfYn;
    }
}
