<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpSpecial
 *
 * @ORM\Table(name="sp_special", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sp_special_trf_yn", columns={"sp_special_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class SpSpecial
{
    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $spSpecialIx;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $spSpecialDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_id", type="integer", nullable=false)
     */
    private $spSpecialId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_desc", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $spSpecialDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_note", type="text", length=65535, nullable=false)
     */
    private $spSpecialNote;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sp_special_date_from", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $spSpecialDateFrom;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sp_special_date_to", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $spSpecialDateTo;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_lead_time_ind", type="integer", nullable=false, options={"default"="0"})
     */
    private $spSpecialLeadTimeInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_lead_time_amt", type="integer", nullable=false, options={"default"="0"})
     */
    private $spSpecialLeadTimeAmt;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_comm_perc", type="integer", nullable=false, options={"default"="0"})
     */
    private $spSpecialCommPerc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_special_commissionable_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spSpecialCommissionableYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_min_properties", type="integer", nullable=false, options={"default"="0"})
     */
    private $spSpecialMinProperties;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_priority", type="integer", nullable=false, options={"default"="0"})
     */
    private $spSpecialPriority;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_special_inactive_yn", type="boolean", nullable=false)
     */
    private $spSpecialInactiveYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_special_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spSpecialTrfYn;



    /**
     * Get spSpecialIx
     *
     * @return string
     */
    public function getSpSpecialIx()
    {
        return $this->spSpecialIx;
    }

    /**
     * Set spSpecialDb
     *
     * @param string $spSpecialDb
     *
     * @return SpSpecial
     */
    public function setSpSpecialDb($spSpecialDb)
    {
        $this->spSpecialDb = $spSpecialDb;

        return $this;
    }

    /**
     * Get spSpecialDb
     *
     * @return string
     */
    public function getSpSpecialDb()
    {
        return $this->spSpecialDb;
    }

    /**
     * Set spSpecialId
     *
     * @param integer $spSpecialId
     *
     * @return SpSpecial
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return integer
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set spSpecialDesc
     *
     * @param string $spSpecialDesc
     *
     * @return SpSpecial
     */
    public function setSpSpecialDesc($spSpecialDesc)
    {
        $this->spSpecialDesc = $spSpecialDesc;

        return $this;
    }

    /**
     * Get spSpecialDesc
     *
     * @return string
     */
    public function getSpSpecialDesc()
    {
        return $this->spSpecialDesc;
    }

    /**
     * Set spSpecialNote
     *
     * @param string $spSpecialNote
     *
     * @return SpSpecial
     */
    public function setSpSpecialNote($spSpecialNote)
    {
        $this->spSpecialNote = $spSpecialNote;

        return $this;
    }

    /**
     * Get spSpecialNote
     *
     * @return string
     */
    public function getSpSpecialNote()
    {
        return $this->spSpecialNote;
    }

    /**
     * Set spSpecialDateFrom
     *
     * @param \DateTime $spSpecialDateFrom
     *
     * @return SpSpecial
     */
    public function setSpSpecialDateFrom($spSpecialDateFrom)
    {
        $this->spSpecialDateFrom = $spSpecialDateFrom;

        return $this;
    }

    /**
     * Get spSpecialDateFrom
     *
     * @return \DateTime
     */
    public function getSpSpecialDateFrom()
    {
        return $this->spSpecialDateFrom;
    }

    /**
     * Set spSpecialDateTo
     *
     * @param \DateTime $spSpecialDateTo
     *
     * @return SpSpecial
     */
    public function setSpSpecialDateTo($spSpecialDateTo)
    {
        $this->spSpecialDateTo = $spSpecialDateTo;

        return $this;
    }

    /**
     * Get spSpecialDateTo
     *
     * @return \DateTime
     */
    public function getSpSpecialDateTo()
    {
        return $this->spSpecialDateTo;
    }

    /**
     * Set spSpecialLeadTimeInd
     *
     * @param integer $spSpecialLeadTimeInd
     *
     * @return SpSpecial
     */
    public function setSpSpecialLeadTimeInd($spSpecialLeadTimeInd)
    {
        $this->spSpecialLeadTimeInd = $spSpecialLeadTimeInd;

        return $this;
    }

    /**
     * Get spSpecialLeadTimeInd
     *
     * @return integer
     */
    public function getSpSpecialLeadTimeInd()
    {
        return $this->spSpecialLeadTimeInd;
    }

    /**
     * Set spSpecialLeadTimeAmt
     *
     * @param integer $spSpecialLeadTimeAmt
     *
     * @return SpSpecial
     */
    public function setSpSpecialLeadTimeAmt($spSpecialLeadTimeAmt)
    {
        $this->spSpecialLeadTimeAmt = $spSpecialLeadTimeAmt;

        return $this;
    }

    /**
     * Get spSpecialLeadTimeAmt
     *
     * @return integer
     */
    public function getSpSpecialLeadTimeAmt()
    {
        return $this->spSpecialLeadTimeAmt;
    }

    /**
     * Set spSpecialCommPerc
     *
     * @param integer $spSpecialCommPerc
     *
     * @return SpSpecial
     */
    public function setSpSpecialCommPerc($spSpecialCommPerc)
    {
        $this->spSpecialCommPerc = $spSpecialCommPerc;

        return $this;
    }

    /**
     * Get spSpecialCommPerc
     *
     * @return integer
     */
    public function getSpSpecialCommPerc()
    {
        return $this->spSpecialCommPerc;
    }

    /**
     * Set spSpecialCommissionableYn
     *
     * @param boolean $spSpecialCommissionableYn
     *
     * @return SpSpecial
     */
    public function setSpSpecialCommissionableYn($spSpecialCommissionableYn)
    {
        $this->spSpecialCommissionableYn = $spSpecialCommissionableYn;

        return $this;
    }

    /**
     * Get spSpecialCommissionableYn
     *
     * @return boolean
     */
    public function getSpSpecialCommissionableYn()
    {
        return $this->spSpecialCommissionableYn;
    }

    /**
     * Set spSpecialMinProperties
     *
     * @param integer $spSpecialMinProperties
     *
     * @return SpSpecial
     */
    public function setSpSpecialMinProperties($spSpecialMinProperties)
    {
        $this->spSpecialMinProperties = $spSpecialMinProperties;

        return $this;
    }

    /**
     * Get spSpecialMinProperties
     *
     * @return integer
     */
    public function getSpSpecialMinProperties()
    {
        return $this->spSpecialMinProperties;
    }

    /**
     * Set spSpecialPriority
     *
     * @param integer $spSpecialPriority
     *
     * @return SpSpecial
     */
    public function setSpSpecialPriority($spSpecialPriority)
    {
        $this->spSpecialPriority = $spSpecialPriority;

        return $this;
    }

    /**
     * Get spSpecialPriority
     *
     * @return integer
     */
    public function getSpSpecialPriority()
    {
        return $this->spSpecialPriority;
    }

    /**
     * Set spSpecialInactiveYn
     *
     * @param boolean $spSpecialInactiveYn
     *
     * @return SpSpecial
     */
    public function setSpSpecialInactiveYn($spSpecialInactiveYn)
    {
        $this->spSpecialInactiveYn = $spSpecialInactiveYn;

        return $this;
    }

    /**
     * Get spSpecialInactiveYn
     *
     * @return boolean
     */
    public function getSpSpecialInactiveYn()
    {
        return $this->spSpecialInactiveYn;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return SpSpecial
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return SpSpecial
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return SpSpecial
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return SpSpecial
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return SpSpecial
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return SpSpecial
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return SpSpecial
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return SpSpecial
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return SpSpecial
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return SpSpecial
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set spSpecialTrfYn
     *
     * @param boolean $spSpecialTrfYn
     *
     * @return SpSpecial
     */
    public function setSpSpecialTrfYn($spSpecialTrfYn)
    {
        $this->spSpecialTrfYn = $spSpecialTrfYn;

        return $this;
    }

    /**
     * Get spSpecialTrfYn
     *
     * @return boolean
     */
    public function getSpSpecialTrfYn()
    {
        return $this->spSpecialTrfYn;
    }
}
