<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpSpecialRateType
 *
 * @ORM\Table(name="sp_special_rate_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="sp_special_rate_type_trf_yn", columns={"sp_special_rate_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class SpSpecialRateType
{
    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_rate_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $spSpecialRateTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_rate_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $spSpecialRateTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="sp_special_rate_type_id", type="integer", nullable=false)
     */
    private $spSpecialRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true)
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="sp_special_id", type="string", length=36, nullable=true)
     */
    private $spSpecialId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sp_special_rate_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $spSpecialRateTypeTrfYn;



    /**
     * Get spSpecialRateTypeIx
     *
     * @return string
     */
    public function getSpSpecialRateTypeIx()
    {
        return $this->spSpecialRateTypeIx;
    }

    /**
     * Set spSpecialRateTypeDb
     *
     * @param string $spSpecialRateTypeDb
     *
     * @return SpSpecialRateType
     */
    public function setSpSpecialRateTypeDb($spSpecialRateTypeDb)
    {
        $this->spSpecialRateTypeDb = $spSpecialRateTypeDb;

        return $this;
    }

    /**
     * Get spSpecialRateTypeDb
     *
     * @return string
     */
    public function getSpSpecialRateTypeDb()
    {
        return $this->spSpecialRateTypeDb;
    }

    /**
     * Set spSpecialRateTypeId
     *
     * @param integer $spSpecialRateTypeId
     *
     * @return SpSpecialRateType
     */
    public function setSpSpecialRateTypeId($spSpecialRateTypeId)
    {
        $this->spSpecialRateTypeId = $spSpecialRateTypeId;

        return $this;
    }

    /**
     * Get spSpecialRateTypeId
     *
     * @return integer
     */
    public function getSpSpecialRateTypeId()
    {
        return $this->spSpecialRateTypeId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return SpSpecialRateType
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set spSpecialId
     *
     * @param string $spSpecialId
     *
     * @return SpSpecialRateType
     */
    public function setSpSpecialId($spSpecialId)
    {
        $this->spSpecialId = $spSpecialId;

        return $this;
    }

    /**
     * Get spSpecialId
     *
     * @return string
     */
    public function getSpSpecialId()
    {
        return $this->spSpecialId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return SpSpecialRateType
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return SpSpecialRateType
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return SpSpecialRateType
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return SpSpecialRateType
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return SpSpecialRateType
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return SpSpecialRateType
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return SpSpecialRateType
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return SpSpecialRateType
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return SpSpecialRateType
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return SpSpecialRateType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set spSpecialRateTypeTrfYn
     *
     * @param boolean $spSpecialRateTypeTrfYn
     *
     * @return SpSpecialRateType
     */
    public function setSpSpecialRateTypeTrfYn($spSpecialRateTypeTrfYn)
    {
        $this->spSpecialRateTypeTrfYn = $spSpecialRateTypeTrfYn;

        return $this;
    }

    /**
     * Get spSpecialRateTypeTrfYn
     *
     * @return boolean
     */
    public function getSpSpecialRateTypeTrfYn()
    {
        return $this->spSpecialRateTypeTrfYn;
    }
}
