<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcPropResUpdate
 *
 * @ORM\Table(name="tc_prop_res_update", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="tc_prop_res_update_id", columns={"tc_prop_res_update_id"})})
 * @ORM\Entity
 */
class TcPropResUpdate
{
    /**
     * @var string
     *
     * @ORM\Column(name="tc_prop_res_update_id", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcPropResUpdateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfDbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=false, options={"default"=""})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rvReservationId;



    /**
     * Set tcPropResUpdateId
     *
     * @param string $tcPropResUpdateId
     *
     * @return TcPropResUpdate
     */
    public function setTcPropResUpdateId($tcPropResUpdateId)
    {
        $this->tcPropResUpdateId = $tcPropResUpdateId;

        return $this;
    }

    /**
     * Get tcPropResUpdateId
     *
     * @return string
     */
    public function getTcPropResUpdateId()
    {
        return $this->tcPropResUpdateId;
    }

    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return TcPropResUpdate
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return TcPropResUpdate
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }
}
