<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcPropStockUpdate
 *
 * @ORM\Table(name="tc_prop_stock_update", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class TcPropStockUpdate
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=false, options={"default"=""})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommTypeId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_prop_stock_date", type="date", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcPropStockDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_prop_stock_type_ind", type="boolean", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcPropStockTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=false, options={"fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfDbCode;



    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return TcPropStockUpdate
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set tcPropStockDate
     *
     * @param \DateTime $tcPropStockDate
     *
     * @return TcPropStockUpdate
     */
    public function setTcPropStockDate($tcPropStockDate)
    {
        $this->tcPropStockDate = $tcPropStockDate;

        return $this;
    }

    /**
     * Get tcPropStockDate
     *
     * @return \DateTime
     */
    public function getTcPropStockDate()
    {
        return $this->tcPropStockDate;
    }

    /**
     * Set tcPropStockTypeInd
     *
     * @param boolean $tcPropStockTypeInd
     *
     * @return TcPropStockUpdate
     */
    public function setTcPropStockTypeInd($tcPropStockTypeInd)
    {
        $this->tcPropStockTypeInd = $tcPropStockTypeInd;

        return $this;
    }

    /**
     * Get tcPropStockTypeInd
     *
     * @return boolean
     */
    public function getTcPropStockTypeInd()
    {
        return $this->tcPropStockTypeInd;
    }

    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return TcPropStockUpdate
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }
}
