<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcPropertyTrf
 *
 * @ORM\Table(name="tc_property_trf", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_db_code", columns={"rf_db_code"}), @ORM\Index(name="tc_table_id", columns={"tc_table_id"})})
 * @ORM\Entity
 */
class TcPropertyTrf
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=true, options={"default"="", "fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfDbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_prop_record_id", type="string", length=36, nullable=false, options={"default"=""})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcPropRecordId;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcTableId;



    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return TcPropertyTrf
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }

    /**
     * Set tcPropRecordId
     *
     * @param string $tcPropRecordId
     *
     * @return TcPropertyTrf
     */
    public function setTcPropRecordId($tcPropRecordId)
    {
        $this->tcPropRecordId = $tcPropRecordId;

        return $this;
    }

    /**
     * Get tcPropRecordId
     *
     * @return string
     */
    public function getTcPropRecordId()
    {
        return $this->tcPropRecordId;
    }

    /**
     * Set tcTableId
     *
     * @param integer $tcTableId
     *
     * @return TcPropertyTrf
     */
    public function setTcTableId($tcTableId)
    {
        $this->tcTableId = $tcTableId;

        return $this;
    }

    /**
     * Get tcTableId
     *
     * @return integer
     */
    public function getTcTableId()
    {
        return $this->tcTableId;
    }
}
