<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcResUpdate
 *
 * @ORM\Table(name="tc_res_update", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="rv_reservation_id", columns={"rv_reservation_id"})})
 * @ORM\Entity
 */
class TcResUpdate
{
    /**
     * @var integer
     *
     * @ORM\Column(name="tc_res_update_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $tcResUpdateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;



    /**
     * Get tcResUpdateId
     *
     * @return integer
     */
    public function getTcResUpdateId()
    {
        return $this->tcResUpdateId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return TcResUpdate
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }
}
