<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcTable
 *
 * @ORM\Table(name="tc_table", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="tc_table_name", columns={"tc_table_name"})}, indexes={@ORM\Index(name="tc_table_trf_yn", columns={"tc_table_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class TcTable
{
    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $tcTableId;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_table_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $tcTableName;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_seq", type="integer", nullable=false, options={"default"="0"})
     */
    private $tcTableSeq;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_table_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $tcTableSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_table_key_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $tcTableKeyInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_table_user_facing_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $tcTableUserFacingYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_table_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $tcTableTrfYn;



    /**
     * Get tcTableId
     *
     * @return integer
     */
    public function getTcTableId()
    {
        return $this->tcTableId;
    }

    /**
     * Set tcTableName
     *
     * @param string $tcTableName
     *
     * @return TcTable
     */
    public function setTcTableName($tcTableName)
    {
        $this->tcTableName = $tcTableName;

        return $this;
    }

    /**
     * Get tcTableName
     *
     * @return string
     */
    public function getTcTableName()
    {
        return $this->tcTableName;
    }

    /**
     * Set tcTableSeq
     *
     * @param integer $tcTableSeq
     *
     * @return TcTable
     */
    public function setTcTableSeq($tcTableSeq)
    {
        $this->tcTableSeq = $tcTableSeq;

        return $this;
    }

    /**
     * Get tcTableSeq
     *
     * @return integer
     */
    public function getTcTableSeq()
    {
        return $this->tcTableSeq;
    }

    /**
     * Set tcTableSysCode
     *
     * @param boolean $tcTableSysCode
     *
     * @return TcTable
     */
    public function setTcTableSysCode($tcTableSysCode)
    {
        $this->tcTableSysCode = $tcTableSysCode;

        return $this;
    }

    /**
     * Get tcTableSysCode
     *
     * @return boolean
     */
    public function getTcTableSysCode()
    {
        return $this->tcTableSysCode;
    }

    /**
     * Set tcTableKeyInd
     *
     * @param boolean $tcTableKeyInd
     *
     * @return TcTable
     */
    public function setTcTableKeyInd($tcTableKeyInd)
    {
        $this->tcTableKeyInd = $tcTableKeyInd;

        return $this;
    }

    /**
     * Get tcTableKeyInd
     *
     * @return boolean
     */
    public function getTcTableKeyInd()
    {
        return $this->tcTableKeyInd;
    }

    /**
     * Set tcTableUserFacingYn
     *
     * @param boolean $tcTableUserFacingYn
     *
     * @return TcTable
     */
    public function setTcTableUserFacingYn($tcTableUserFacingYn)
    {
        $this->tcTableUserFacingYn = $tcTableUserFacingYn;

        return $this;
    }

    /**
     * Get tcTableUserFacingYn
     *
     * @return boolean
     */
    public function getTcTableUserFacingYn()
    {
        return $this->tcTableUserFacingYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return TcTable
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set tcTableTrfYn
     *
     * @param boolean $tcTableTrfYn
     *
     * @return TcTable
     */
    public function setTcTableTrfYn($tcTableTrfYn)
    {
        $this->tcTableTrfYn = $tcTableTrfYn;

        return $this;
    }

    /**
     * Get tcTableTrfYn
     *
     * @return boolean
     */
    public function getTcTableTrfYn()
    {
        return $this->tcTableTrfYn;
    }
}
