<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcTransfer
 *
 * @ORM\Table(name="tc_transfer", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="tc_transfer_trf_yn", columns={"tc_transfer_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class TcTransfer
{
    /**
     * @var string
     *
     * @ORM\Column(name="tc_transfer_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcTransferIx;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_transfer_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $tcTransferDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_transfer_id", type="integer", nullable=false)
     */
    private $tcTransferId;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_source", type="string", length=2, nullable=true, options={"fixed"="true"})
     */
    private $tcTrfSource;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_trf_file_size", type="integer", nullable=false, options={"default"="0"})
     */
    private $tcTrfFileSize;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_start", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeStart;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_start_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeStartTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_extract", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeExtract;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_extract_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeExtractTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_send", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeSend;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_send_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeSendTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_imp_start", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeImpStart;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_imp_start_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeImpStartTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_imp_end", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeImpEnd;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_imp_end_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeImpEndTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="tc_trf_time_close", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $tcTrfTimeClose;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_time_close_tz", type="string", length=40, nullable=false)
     */
    private $tcTrfTimeCloseTz;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_user_id", type="string", length=50, nullable=true)
     */
    private $tcUserId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_transfer_id", type="integer", nullable=true)
     */
    private $scTransferId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_transfer_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $tcTransferTrfYn;



    /**
     * Get tcTransferIx
     *
     * @return string
     */
    public function getTcTransferIx()
    {
        return $this->tcTransferIx;
    }

    /**
     * Set tcTransferDb
     *
     * @param string $tcTransferDb
     *
     * @return TcTransfer
     */
    public function setTcTransferDb($tcTransferDb)
    {
        $this->tcTransferDb = $tcTransferDb;

        return $this;
    }

    /**
     * Get tcTransferDb
     *
     * @return string
     */
    public function getTcTransferDb()
    {
        return $this->tcTransferDb;
    }

    /**
     * Set tcTransferId
     *
     * @param integer $tcTransferId
     *
     * @return TcTransfer
     */
    public function setTcTransferId($tcTransferId)
    {
        $this->tcTransferId = $tcTransferId;

        return $this;
    }

    /**
     * Get tcTransferId
     *
     * @return integer
     */
    public function getTcTransferId()
    {
        return $this->tcTransferId;
    }

    /**
     * Set tcTrfSource
     *
     * @param string $tcTrfSource
     *
     * @return TcTransfer
     */
    public function setTcTrfSource($tcTrfSource)
    {
        $this->tcTrfSource = $tcTrfSource;

        return $this;
    }

    /**
     * Get tcTrfSource
     *
     * @return string
     */
    public function getTcTrfSource()
    {
        return $this->tcTrfSource;
    }

    /**
     * Set tcTrfFileSize
     *
     * @param integer $tcTrfFileSize
     *
     * @return TcTransfer
     */
    public function setTcTrfFileSize($tcTrfFileSize)
    {
        $this->tcTrfFileSize = $tcTrfFileSize;

        return $this;
    }

    /**
     * Get tcTrfFileSize
     *
     * @return integer
     */
    public function getTcTrfFileSize()
    {
        return $this->tcTrfFileSize;
    }

    /**
     * Set tcTrfTimeStart
     *
     * @param \DateTime $tcTrfTimeStart
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeStart($tcTrfTimeStart)
    {
        $this->tcTrfTimeStart = $tcTrfTimeStart;

        return $this;
    }

    /**
     * Get tcTrfTimeStart
     *
     * @return \DateTime
     */
    public function getTcTrfTimeStart()
    {
        return $this->tcTrfTimeStart;
    }

    /**
     * Set tcTrfTimeStartTz
     *
     * @param string $tcTrfTimeStartTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeStartTz($tcTrfTimeStartTz)
    {
        $this->tcTrfTimeStartTz = $tcTrfTimeStartTz;

        return $this;
    }

    /**
     * Get tcTrfTimeStartTz
     *
     * @return string
     */
    public function getTcTrfTimeStartTz()
    {
        return $this->tcTrfTimeStartTz;
    }

    /**
     * Set tcTrfTimeExtract
     *
     * @param \DateTime $tcTrfTimeExtract
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeExtract($tcTrfTimeExtract)
    {
        $this->tcTrfTimeExtract = $tcTrfTimeExtract;

        return $this;
    }

    /**
     * Get tcTrfTimeExtract
     *
     * @return \DateTime
     */
    public function getTcTrfTimeExtract()
    {
        return $this->tcTrfTimeExtract;
    }

    /**
     * Set tcTrfTimeExtractTz
     *
     * @param string $tcTrfTimeExtractTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeExtractTz($tcTrfTimeExtractTz)
    {
        $this->tcTrfTimeExtractTz = $tcTrfTimeExtractTz;

        return $this;
    }

    /**
     * Get tcTrfTimeExtractTz
     *
     * @return string
     */
    public function getTcTrfTimeExtractTz()
    {
        return $this->tcTrfTimeExtractTz;
    }

    /**
     * Set tcTrfTimeSend
     *
     * @param \DateTime $tcTrfTimeSend
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeSend($tcTrfTimeSend)
    {
        $this->tcTrfTimeSend = $tcTrfTimeSend;

        return $this;
    }

    /**
     * Get tcTrfTimeSend
     *
     * @return \DateTime
     */
    public function getTcTrfTimeSend()
    {
        return $this->tcTrfTimeSend;
    }

    /**
     * Set tcTrfTimeSendTz
     *
     * @param string $tcTrfTimeSendTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeSendTz($tcTrfTimeSendTz)
    {
        $this->tcTrfTimeSendTz = $tcTrfTimeSendTz;

        return $this;
    }

    /**
     * Get tcTrfTimeSendTz
     *
     * @return string
     */
    public function getTcTrfTimeSendTz()
    {
        return $this->tcTrfTimeSendTz;
    }

    /**
     * Set tcTrfTimeImpStart
     *
     * @param \DateTime $tcTrfTimeImpStart
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeImpStart($tcTrfTimeImpStart)
    {
        $this->tcTrfTimeImpStart = $tcTrfTimeImpStart;

        return $this;
    }

    /**
     * Get tcTrfTimeImpStart
     *
     * @return \DateTime
     */
    public function getTcTrfTimeImpStart()
    {
        return $this->tcTrfTimeImpStart;
    }

    /**
     * Set tcTrfTimeImpStartTz
     *
     * @param string $tcTrfTimeImpStartTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeImpStartTz($tcTrfTimeImpStartTz)
    {
        $this->tcTrfTimeImpStartTz = $tcTrfTimeImpStartTz;

        return $this;
    }

    /**
     * Get tcTrfTimeImpStartTz
     *
     * @return string
     */
    public function getTcTrfTimeImpStartTz()
    {
        return $this->tcTrfTimeImpStartTz;
    }

    /**
     * Set tcTrfTimeImpEnd
     *
     * @param \DateTime $tcTrfTimeImpEnd
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeImpEnd($tcTrfTimeImpEnd)
    {
        $this->tcTrfTimeImpEnd = $tcTrfTimeImpEnd;

        return $this;
    }

    /**
     * Get tcTrfTimeImpEnd
     *
     * @return \DateTime
     */
    public function getTcTrfTimeImpEnd()
    {
        return $this->tcTrfTimeImpEnd;
    }

    /**
     * Set tcTrfTimeImpEndTz
     *
     * @param string $tcTrfTimeImpEndTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeImpEndTz($tcTrfTimeImpEndTz)
    {
        $this->tcTrfTimeImpEndTz = $tcTrfTimeImpEndTz;

        return $this;
    }

    /**
     * Get tcTrfTimeImpEndTz
     *
     * @return string
     */
    public function getTcTrfTimeImpEndTz()
    {
        return $this->tcTrfTimeImpEndTz;
    }

    /**
     * Set tcTrfTimeClose
     *
     * @param \DateTime $tcTrfTimeClose
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeClose($tcTrfTimeClose)
    {
        $this->tcTrfTimeClose = $tcTrfTimeClose;

        return $this;
    }

    /**
     * Get tcTrfTimeClose
     *
     * @return \DateTime
     */
    public function getTcTrfTimeClose()
    {
        return $this->tcTrfTimeClose;
    }

    /**
     * Set tcTrfTimeCloseTz
     *
     * @param string $tcTrfTimeCloseTz
     *
     * @return TcTransfer
     */
    public function setTcTrfTimeCloseTz($tcTrfTimeCloseTz)
    {
        $this->tcTrfTimeCloseTz = $tcTrfTimeCloseTz;

        return $this;
    }

    /**
     * Get tcTrfTimeCloseTz
     *
     * @return string
     */
    public function getTcTrfTimeCloseTz()
    {
        return $this->tcTrfTimeCloseTz;
    }

    /**
     * Set tcUserId
     *
     * @param string $tcUserId
     *
     * @return TcTransfer
     */
    public function setTcUserId($tcUserId)
    {
        $this->tcUserId = $tcUserId;

        return $this;
    }

    /**
     * Get tcUserId
     *
     * @return string
     */
    public function getTcUserId()
    {
        return $this->tcUserId;
    }

    /**
     * Set scTransferId
     *
     * @param integer $scTransferId
     *
     * @return TcTransfer
     */
    public function setScTransferId($scTransferId)
    {
        $this->scTransferId = $scTransferId;

        return $this;
    }

    /**
     * Get scTransferId
     *
     * @return integer
     */
    public function getScTransferId()
    {
        return $this->scTransferId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return TcTransfer
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set tcTransferTrfYn
     *
     * @param boolean $tcTransferTrfYn
     *
     * @return TcTransfer
     */
    public function setTcTransferTrfYn($tcTransferTrfYn)
    {
        $this->tcTransferTrfYn = $tcTransferTrfYn;

        return $this;
    }

    /**
     * Get tcTransferTrfYn
     *
     * @return boolean
     */
    public function getTcTransferTrfYn()
    {
        return $this->tcTransferTrfYn;
    }
}
