<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TcTransferTable
 *
 * @ORM\Table(name="tc_transfer_table", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="tc_transfer_table_trf_yn", columns={"tc_transfer_table_trf_yn"}), @ORM\Index(name="tc_transfer_id", columns={"tc_transfer_id"}), @ORM\Index(name="tc_table_id", columns={"tc_table_id"})})
 * @ORM\Entity
 */
class TcTransferTable
{
    /**
     * @var string
     *
     * @ORM\Column(name="tc_transfer_table_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $tcTransferTableIx;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_transfer_table_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $tcTransferTableDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_transfer_table_id", type="integer", nullable=false)
     */
    private $tcTransferTableId;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_tbl_last_exp_rec", type="string", length=36, nullable=true)
     */
    private $tcTrfTblLastExpRec;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_trf_tbl_last_imp_rec", type="string", length=36, nullable=true)
     */
    private $tcTrfTblLastImpRec;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_trf_tbl_recs_exp", type="integer", nullable=true)
     */
    private $tcTrfTblRecsExp;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_trf_tbl_recs_imp", type="integer", nullable=true)
     */
    private $tcTrfTblRecsImp;

    /**
     * @var string
     *
     * @ORM\Column(name="tc_transfer_id", type="string", length=36, nullable=true)
     */
    private $tcTransferId;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id", type="integer", nullable=true)
     */
    private $tcTableId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tc_transfer_table_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $tcTransferTableTrfYn;



    /**
     * Get tcTransferTableIx
     *
     * @return string
     */
    public function getTcTransferTableIx()
    {
        return $this->tcTransferTableIx;
    }

    /**
     * Set tcTransferTableDb
     *
     * @param string $tcTransferTableDb
     *
     * @return TcTransferTable
     */
    public function setTcTransferTableDb($tcTransferTableDb)
    {
        $this->tcTransferTableDb = $tcTransferTableDb;

        return $this;
    }

    /**
     * Get tcTransferTableDb
     *
     * @return string
     */
    public function getTcTransferTableDb()
    {
        return $this->tcTransferTableDb;
    }

    /**
     * Set tcTransferTableId
     *
     * @param integer $tcTransferTableId
     *
     * @return TcTransferTable
     */
    public function setTcTransferTableId($tcTransferTableId)
    {
        $this->tcTransferTableId = $tcTransferTableId;

        return $this;
    }

    /**
     * Get tcTransferTableId
     *
     * @return integer
     */
    public function getTcTransferTableId()
    {
        return $this->tcTransferTableId;
    }

    /**
     * Set tcTrfTblLastExpRec
     *
     * @param string $tcTrfTblLastExpRec
     *
     * @return TcTransferTable
     */
    public function setTcTrfTblLastExpRec($tcTrfTblLastExpRec)
    {
        $this->tcTrfTblLastExpRec = $tcTrfTblLastExpRec;

        return $this;
    }

    /**
     * Get tcTrfTblLastExpRec
     *
     * @return string
     */
    public function getTcTrfTblLastExpRec()
    {
        return $this->tcTrfTblLastExpRec;
    }

    /**
     * Set tcTrfTblLastImpRec
     *
     * @param string $tcTrfTblLastImpRec
     *
     * @return TcTransferTable
     */
    public function setTcTrfTblLastImpRec($tcTrfTblLastImpRec)
    {
        $this->tcTrfTblLastImpRec = $tcTrfTblLastImpRec;

        return $this;
    }

    /**
     * Get tcTrfTblLastImpRec
     *
     * @return string
     */
    public function getTcTrfTblLastImpRec()
    {
        return $this->tcTrfTblLastImpRec;
    }

    /**
     * Set tcTrfTblRecsExp
     *
     * @param integer $tcTrfTblRecsExp
     *
     * @return TcTransferTable
     */
    public function setTcTrfTblRecsExp($tcTrfTblRecsExp)
    {
        $this->tcTrfTblRecsExp = $tcTrfTblRecsExp;

        return $this;
    }

    /**
     * Get tcTrfTblRecsExp
     *
     * @return integer
     */
    public function getTcTrfTblRecsExp()
    {
        return $this->tcTrfTblRecsExp;
    }

    /**
     * Set tcTrfTblRecsImp
     *
     * @param integer $tcTrfTblRecsImp
     *
     * @return TcTransferTable
     */
    public function setTcTrfTblRecsImp($tcTrfTblRecsImp)
    {
        $this->tcTrfTblRecsImp = $tcTrfTblRecsImp;

        return $this;
    }

    /**
     * Get tcTrfTblRecsImp
     *
     * @return integer
     */
    public function getTcTrfTblRecsImp()
    {
        return $this->tcTrfTblRecsImp;
    }

    /**
     * Set tcTransferId
     *
     * @param string $tcTransferId
     *
     * @return TcTransferTable
     */
    public function setTcTransferId($tcTransferId)
    {
        $this->tcTransferId = $tcTransferId;

        return $this;
    }

    /**
     * Get tcTransferId
     *
     * @return string
     */
    public function getTcTransferId()
    {
        return $this->tcTransferId;
    }

    /**
     * Set tcTableId
     *
     * @param integer $tcTableId
     *
     * @return TcTransferTable
     */
    public function setTcTableId($tcTableId)
    {
        $this->tcTableId = $tcTableId;

        return $this;
    }

    /**
     * Get tcTableId
     *
     * @return integer
     */
    public function getTcTableId()
    {
        return $this->tcTableId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return TcTransferTable
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set tcTransferTableTrfYn
     *
     * @param boolean $tcTransferTableTrfYn
     *
     * @return TcTransferTable
     */
    public function setTcTransferTableTrfYn($tcTransferTableTrfYn)
    {
        $this->tcTransferTableTrfYn = $tcTransferTableTrfYn;

        return $this;
    }

    /**
     * Get tcTransferTableTrfYn
     *
     * @return boolean
     */
    public function getTcTransferTableTrfYn()
    {
        return $this->tcTransferTableTrfYn;
    }
}
