<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TrRule
 *
 * @ORM\Table(name="tr_rule", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="tr_rule_trf_yn", columns={"tr_rule_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class TrRule
{
    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $trRuleIx;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $trRuleDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="tr_rule_id", type="integer", nullable=false)
     */
    private $trRuleId;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_desc", type="string", length=50, nullable=true)
     */
    private $trRuleDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_field_1", type="text", length=65535, nullable=true)
     */
    private $trRuleField1;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_field_2", type="text", length=65535, nullable=true)
     */
    private $trRuleField2;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tr_rule_inc_excl", type="boolean", nullable=false, options={"default"="0"})
     */
    private $trRuleIncExcl;

    /**
     * @var integer
     *
     * @ORM\Column(name="tr_rule_seq", type="integer", nullable=false, options={"default"="0"})
     */
    private $trRuleSeq;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tr_rule_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $trRuleSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tr_rule_type", type="boolean", nullable=false, options={"default"="0"})
     */
    private $trRuleType;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $tcTableId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tr_rule_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $trRuleTrfYn;



    /**
     * Get trRuleIx
     *
     * @return string
     */
    public function getTrRuleIx()
    {
        return $this->trRuleIx;
    }

    /**
     * Set trRuleDb
     *
     * @param string $trRuleDb
     *
     * @return TrRule
     */
    public function setTrRuleDb($trRuleDb)
    {
        $this->trRuleDb = $trRuleDb;

        return $this;
    }

    /**
     * Get trRuleDb
     *
     * @return string
     */
    public function getTrRuleDb()
    {
        return $this->trRuleDb;
    }

    /**
     * Set trRuleId
     *
     * @param integer $trRuleId
     *
     * @return TrRule
     */
    public function setTrRuleId($trRuleId)
    {
        $this->trRuleId = $trRuleId;

        return $this;
    }

    /**
     * Get trRuleId
     *
     * @return integer
     */
    public function getTrRuleId()
    {
        return $this->trRuleId;
    }

    /**
     * Set trRuleDesc
     *
     * @param string $trRuleDesc
     *
     * @return TrRule
     */
    public function setTrRuleDesc($trRuleDesc)
    {
        $this->trRuleDesc = $trRuleDesc;

        return $this;
    }

    /**
     * Get trRuleDesc
     *
     * @return string
     */
    public function getTrRuleDesc()
    {
        return $this->trRuleDesc;
    }

    /**
     * Set trRuleField1
     *
     * @param string $trRuleField1
     *
     * @return TrRule
     */
    public function setTrRuleField1($trRuleField1)
    {
        $this->trRuleField1 = $trRuleField1;

        return $this;
    }

    /**
     * Get trRuleField1
     *
     * @return string
     */
    public function getTrRuleField1()
    {
        return $this->trRuleField1;
    }

    /**
     * Set trRuleField2
     *
     * @param string $trRuleField2
     *
     * @return TrRule
     */
    public function setTrRuleField2($trRuleField2)
    {
        $this->trRuleField2 = $trRuleField2;

        return $this;
    }

    /**
     * Get trRuleField2
     *
     * @return string
     */
    public function getTrRuleField2()
    {
        return $this->trRuleField2;
    }

    /**
     * Set trRuleIncExcl
     *
     * @param boolean $trRuleIncExcl
     *
     * @return TrRule
     */
    public function setTrRuleIncExcl($trRuleIncExcl)
    {
        $this->trRuleIncExcl = $trRuleIncExcl;

        return $this;
    }

    /**
     * Get trRuleIncExcl
     *
     * @return boolean
     */
    public function getTrRuleIncExcl()
    {
        return $this->trRuleIncExcl;
    }

    /**
     * Set trRuleSeq
     *
     * @param integer $trRuleSeq
     *
     * @return TrRule
     */
    public function setTrRuleSeq($trRuleSeq)
    {
        $this->trRuleSeq = $trRuleSeq;

        return $this;
    }

    /**
     * Get trRuleSeq
     *
     * @return integer
     */
    public function getTrRuleSeq()
    {
        return $this->trRuleSeq;
    }

    /**
     * Set trRuleSysCode
     *
     * @param boolean $trRuleSysCode
     *
     * @return TrRule
     */
    public function setTrRuleSysCode($trRuleSysCode)
    {
        $this->trRuleSysCode = $trRuleSysCode;

        return $this;
    }

    /**
     * Get trRuleSysCode
     *
     * @return boolean
     */
    public function getTrRuleSysCode()
    {
        return $this->trRuleSysCode;
    }

    /**
     * Set trRuleType
     *
     * @param boolean $trRuleType
     *
     * @return TrRule
     */
    public function setTrRuleType($trRuleType)
    {
        $this->trRuleType = $trRuleType;

        return $this;
    }

    /**
     * Get trRuleType
     *
     * @return boolean
     */
    public function getTrRuleType()
    {
        return $this->trRuleType;
    }

    /**
     * Set tcTableId
     *
     * @param integer $tcTableId
     *
     * @return TrRule
     */
    public function setTcTableId($tcTableId)
    {
        $this->tcTableId = $tcTableId;

        return $this;
    }

    /**
     * Get tcTableId
     *
     * @return integer
     */
    public function getTcTableId()
    {
        return $this->tcTableId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return TrRule
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set trRuleTrfYn
     *
     * @param boolean $trRuleTrfYn
     *
     * @return TrRule
     */
    public function setTrRuleTrfYn($trRuleTrfYn)
    {
        $this->trRuleTrfYn = $trRuleTrfYn;

        return $this;
    }

    /**
     * Get trRuleTrfYn
     *
     * @return boolean
     */
    public function getTrRuleTrfYn()
    {
        return $this->trRuleTrfYn;
    }
}
