<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TrRuleItem
 *
 * @ORM\Table(name="tr_rule_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="tr_rule_item_trf_yn", columns={"tr_rule_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class TrRuleItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $trRuleItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_item_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $trRuleItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="tr_rule_item_id", type="integer", nullable=false)
     */
    private $trRuleItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=true, options={"fixed"="true"})
     */
    private $rfDbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tr_rule_id", type="string", length=36, nullable=true)
     */
    private $trRuleId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="tr_rule_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $trRuleItemTrfYn;



    /**
     * Get trRuleItemIx
     *
     * @return string
     */
    public function getTrRuleItemIx()
    {
        return $this->trRuleItemIx;
    }

    /**
     * Set trRuleItemDb
     *
     * @param string $trRuleItemDb
     *
     * @return TrRuleItem
     */
    public function setTrRuleItemDb($trRuleItemDb)
    {
        $this->trRuleItemDb = $trRuleItemDb;

        return $this;
    }

    /**
     * Get trRuleItemDb
     *
     * @return string
     */
    public function getTrRuleItemDb()
    {
        return $this->trRuleItemDb;
    }

    /**
     * Set trRuleItemId
     *
     * @param integer $trRuleItemId
     *
     * @return TrRuleItem
     */
    public function setTrRuleItemId($trRuleItemId)
    {
        $this->trRuleItemId = $trRuleItemId;

        return $this;
    }

    /**
     * Get trRuleItemId
     *
     * @return integer
     */
    public function getTrRuleItemId()
    {
        return $this->trRuleItemId;
    }

    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return TrRuleItem
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }

    /**
     * Set trRuleId
     *
     * @param string $trRuleId
     *
     * @return TrRuleItem
     */
    public function setTrRuleId($trRuleId)
    {
        $this->trRuleId = $trRuleId;

        return $this;
    }

    /**
     * Get trRuleId
     *
     * @return string
     */
    public function getTrRuleId()
    {
        return $this->trRuleId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return TrRuleItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set trRuleItemTrfYn
     *
     * @param boolean $trRuleItemTrfYn
     *
     * @return TrRuleItem
     */
    public function setTrRuleItemTrfYn($trRuleItemTrfYn)
    {
        $this->trRuleItemTrfYn = $trRuleItemTrfYn;

        return $this;
    }

    /**
     * Get trRuleItemTrfYn
     *
     * @return boolean
     */
    public function getTrRuleItemTrfYn()
    {
        return $this->trRuleItemTrfYn;
    }
}
